/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class BooleanMessage
extends BaseMessage<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(BooleanMessage.class);

    BooleanMessage(boolean send, String address, Boolean body) {
        super(send, address, body);
    }

    public BooleanMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            this.body = new Boolean(readBuff.getByte(pos + 1) == 1);
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendByte((Boolean)this.body != false ? (byte)1 : 0);
        }
    }

    @Override
    protected int getBodyLength() {
        return 1 + (this.body == null ? 0 : 1);
    }

    @Override
    protected Message copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 2;
    }

    protected void handleReply(Boolean reply, Handler<Message<Boolean>> replyHandler) {
        this.bus.send(this.replyAddress, reply, replyHandler);
    }

    @Override
    protected BaseMessage createReplyMessage(Boolean reply) {
        return new BooleanMessage(true, this.replyAddress, reply);
    }
}

