/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class CharacterMessage
extends BaseMessage<Character> {
    private static final Logger log = LoggerFactory.getLogger(CharacterMessage.class);

    CharacterMessage(boolean send, String address, Character body) {
        super(send, address, body);
    }

    public CharacterMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            this.body = Character.valueOf((char)readBuff.getShort(++pos));
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendShort((short)((Character)this.body).charValue());
        }
    }

    @Override
    protected int getBodyLength() {
        return 1 + (this.body == null ? 0 : 2);
    }

    @Override
    protected Message copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 5;
    }

    @Override
    protected BaseMessage createReplyMessage(Character reply) {
        return new CharacterMessage(true, this.replyAddress, reply);
    }
}

