/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.jboss.netty.util.CharsetUtil;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class JsonArrayMessage
extends BaseMessage<JsonArray> {
    private static final Logger log = LoggerFactory.getLogger(JsonArrayMessage.class);
    private byte[] encoded;

    JsonArrayMessage(boolean send, String address, JsonArray body) {
        super(send, address, body);
    }

    private JsonArrayMessage(JsonArrayMessage other) {
        super(other.send, other.address, other.body == null ? null : ((JsonArray)other.body).copy());
        this.replyAddress = other.replyAddress;
        this.bus = other.bus;
        this.sender = other.sender;
    }

    public JsonArrayMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            int strLength = readBuff.getInt(++pos);
            byte[] bytes = readBuff.getBytes(pos += 4, pos + strLength);
            String str = new String(bytes, CharsetUtil.UTF_8);
            this.body = new JsonArray(str);
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendInt(this.encoded.length);
            buff.appendBytes(this.encoded);
        }
    }

    @Override
    protected int getBodyLength() {
        if (this.body == null) {
            return 1;
        }
        String strJson = ((JsonArray)this.body).encode();
        this.encoded = strJson.getBytes(CharsetUtil.UTF_8);
        return 5 + this.encoded.length;
    }

    @Override
    protected Message copy() {
        return new JsonArrayMessage(this);
    }

    @Override
    protected byte type() {
        return 12;
    }

    @Override
    protected BaseMessage createReplyMessage(JsonArray reply) {
        return new JsonArrayMessage(true, this.replyAddress, reply);
    }
}

