/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.vertx.java.core.eventbus.impl.ClusterManager;
import org.vertx.java.core.eventbus.impl.SubsMap;
import org.vertx.java.core.eventbus.impl.hazelcast.HazelcastServerID;
import org.vertx.java.core.eventbus.impl.hazelcast.HazelcastSubsMap;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class HazelcastClusterManager
implements ClusterManager {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private static final String CONFIG_FILE = "cluster.xml";
    private static HazelcastInstance instance;
    private final VertxInternal vertx;

    public HazelcastClusterManager(VertxInternal vertx) {
        this.vertx = vertx;
        this.initHazelcast();
    }

    private synchronized HazelcastInstance initHazelcast() {
        if (instance == null) {
            Config cfg = this.getConfig(null);
            if (cfg == null) {
                log.warn("Cannot find cluster.xml on classpath. Using default cluster configuration");
            }
            instance = Hazelcast.init(cfg);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Hazelcast.shutdownAll();
                }
            });
        }
        return instance;
    }

    protected Config getConfig(String configfile) {
        if (configfile == null) {
            configfile = CONFIG_FILE;
        }
        Config cfg = null;
        try (InputStream is = HazelcastClusterManager.class.getClassLoader().getResourceAsStream(configfile);
             BufferedInputStream bis = new BufferedInputStream(is);){
            if (is != null) {
                cfg = new XmlConfigBuilder(bis).build();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cfg;
    }

    @Override
    public SubsMap getSubsMap(String name) {
        MultiMap<String, HazelcastServerID> map = instance.getMultiMap(name);
        return new HazelcastSubsMap(this.vertx, map);
    }

    @Override
    public void close() {
    }

    public HazelcastInstance getInstance() {
        return instance;
    }
}

