/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.file.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Set;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.file.FileSystemException;
import org.vertx.java.core.impl.BlockingAction;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class DefaultAsyncFile
implements AsyncFile {
    private static final Logger log = LoggerFactory.getLogger(AsyncFile.class);
    private final VertxInternal vertx;
    private final AsynchronousFileChannel ch;
    private final Context context;
    private boolean closed;
    private ReadStream readStream;
    private WriteStream writeStream;
    private Runnable closedDeferred;
    private long writesOutstanding;

    DefaultAsyncFile(VertxInternal vertx, String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, Context context) throws Exception {
        if (!read && !write) {
            throw new FileSystemException("Cannot open file for neither reading nor writing");
        }
        this.vertx = vertx;
        Path file = Paths.get(path, new String[0]);
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        if (read) {
            options.add(StandardOpenOption.READ);
        }
        if (write) {
            options.add(StandardOpenOption.WRITE);
        }
        if (createNew) {
            options.add(StandardOpenOption.CREATE);
        }
        if (flush) {
            options.add(StandardOpenOption.DSYNC);
        }
        if (perms != null) {
            FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
            this.ch = AsynchronousFileChannel.open(file, options, vertx.getBackgroundPool(), attrs);
        } else {
            this.ch = AsynchronousFileChannel.open(file, options, vertx.getBackgroundPool(), new FileAttribute[0]);
        }
        this.context = context;
    }

    @Override
    public void close() {
        this.closeInternal(null);
    }

    @Override
    public void close(AsyncResultHandler handler) {
        this.closeInternal(handler);
    }

    @Override
    public void write(Buffer buffer, int position, AsyncResultHandler<Void> handler) {
        this.check();
        ByteBuffer bb = buffer.getChannelBuffer().toByteBuffer();
        this.doWrite(bb, position, handler);
    }

    @Override
    public void read(Buffer buffer, int offset, int position, int length, AsyncResultHandler<Buffer> handler) {
        this.check();
        ByteBuffer bb = ByteBuffer.allocate(length);
        this.doRead(buffer, offset, bb, position, handler);
    }

    @Override
    public WriteStream getWriteStream() {
        this.check();
        if (this.writeStream == null) {
            this.writeStream = new WriteStream(){
                Handler<Exception> exceptionHandler;
                Handler<Void> drainHandler;
                int pos;
                int maxWrites = 131072;
                int lwm = this.maxWrites / 2;

                @Override
                public void writeBuffer(Buffer buffer) {
                    DefaultAsyncFile.this.check();
                    int length = buffer.length();
                    ByteBuffer bb = buffer.getChannelBuffer().toByteBuffer();
                    DefaultAsyncFile.this.doWrite(bb, this.pos, new AsyncResultHandler<Void>(){

                        @Override
                        public void handle(AsyncResult<Void> deferred) {
                            if (deferred.succeeded()) {
                                DefaultAsyncFile.this.checkContext();
                                this.checkDrained();
                                if (DefaultAsyncFile.this.writesOutstanding == 0L && DefaultAsyncFile.this.closedDeferred != null) {
                                    DefaultAsyncFile.this.closedDeferred.run();
                                }
                            } else {
                                this.handleException(deferred.exception);
                            }
                        }
                    });
                    this.pos += length;
                }

                private void checkDrained() {
                    if (this.drainHandler != null && DefaultAsyncFile.this.writesOutstanding <= (long)this.lwm) {
                        Handler<Void> handler = this.drainHandler;
                        this.drainHandler = null;
                        handler.handle(null);
                    }
                }

                @Override
                public void setWriteQueueMaxSize(int maxSize) {
                    DefaultAsyncFile.this.check();
                    this.maxWrites = maxSize;
                    this.lwm = this.maxWrites / 2;
                }

                @Override
                public boolean writeQueueFull() {
                    DefaultAsyncFile.this.check();
                    return DefaultAsyncFile.this.writesOutstanding >= (long)this.maxWrites;
                }

                @Override
                public void drainHandler(Handler<Void> handler) {
                    DefaultAsyncFile.this.check();
                    this.drainHandler = handler;
                    this.checkDrained();
                }

                @Override
                public void exceptionHandler(Handler<Exception> handler) {
                    DefaultAsyncFile.this.check();
                    this.exceptionHandler = handler;
                }

                void handleException(Exception e) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle(e);
                    } else {
                        log.error("Unhandled exception", e);
                    }
                }
            };
        }
        return this.writeStream;
    }

    @Override
    public ReadStream getReadStream() {
        this.check();
        if (this.readStream == null) {
            this.readStream = new ReadStream(){
                boolean paused;
                Handler<Buffer> dataHandler;
                Handler<Exception> exceptionHandler;
                Handler<Void> endHandler;
                int pos;
                boolean readInProgress;

                void doRead() {
                    if (!this.readInProgress) {
                        this.readInProgress = true;
                        Buffer buff = new Buffer(8192);
                        DefaultAsyncFile.this.read(buff, 0, this.pos, 8192, new AsyncResultHandler<Buffer>(){

                            @Override
                            public void handle(AsyncResult<Buffer> ar) {
                                if (ar.exception == null) {
                                    readInProgress = false;
                                    Buffer buffer = (Buffer)ar.result;
                                    if (buffer.length() == 0) {
                                        this.handleEnd();
                                    } else {
                                        pos += buffer.length();
                                        this.handleData(buffer);
                                        if (!paused && dataHandler != null) {
                                            this.doRead();
                                        }
                                    }
                                } else {
                                    this.handleException(ar.exception);
                                }
                            }
                        });
                    }
                }

                @Override
                public void dataHandler(Handler<Buffer> handler) {
                    DefaultAsyncFile.this.check();
                    this.dataHandler = handler;
                    if (this.dataHandler != null && !this.paused && !DefaultAsyncFile.this.closed) {
                        this.doRead();
                    }
                }

                @Override
                public void exceptionHandler(Handler<Exception> handler) {
                    DefaultAsyncFile.this.check();
                    this.exceptionHandler = handler;
                }

                @Override
                public void endHandler(Handler<Void> handler) {
                    DefaultAsyncFile.this.check();
                    this.endHandler = handler;
                }

                @Override
                public void pause() {
                    DefaultAsyncFile.this.check();
                    this.paused = true;
                }

                @Override
                public void resume() {
                    DefaultAsyncFile.this.check();
                    if (this.paused && !DefaultAsyncFile.this.closed) {
                        this.paused = false;
                        if (this.dataHandler != null) {
                            this.doRead();
                        }
                    }
                }

                void handleException(Exception e) {
                    if (this.exceptionHandler != null) {
                        DefaultAsyncFile.this.checkContext();
                        this.exceptionHandler.handle(e);
                    } else {
                        log.error("Unhandled exception", e);
                    }
                }

                void handleData(Buffer buffer) {
                    if (this.dataHandler != null) {
                        DefaultAsyncFile.this.checkContext();
                        this.dataHandler.handle(buffer);
                    }
                }

                void handleEnd() {
                    if (this.endHandler != null) {
                        DefaultAsyncFile.this.checkContext();
                        this.endHandler.handle(null);
                    }
                }
            };
        }
        return this.readStream;
    }

    @Override
    public void flush() {
        this.doFlush(null);
    }

    @Override
    public void flush(AsyncResultHandler handler) {
        this.doFlush(handler);
    }

    private void doFlush(AsyncResultHandler handler) {
        this.checkClosed();
        this.checkContext();
        new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                DefaultAsyncFile.this.ch.force(false);
                return null;
            }
        }.run();
    }

    private void doWrite(ByteBuffer buff, int position, AsyncResultHandler<Void> handler) {
        this.writesOutstanding += (long)buff.limit();
        this.writeInternal(buff, position, handler);
    }

    private void writeInternal(final ByteBuffer buff, final int position, final AsyncResultHandler<Void> handler) {
        this.ch.write(buff, position, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer bytesWritten, Object attachment) {
                int pos = position;
                if (buff.hasRemaining()) {
                    DefaultAsyncFile.this.writeInternal(buff, pos += bytesWritten.intValue(), handler);
                } else {
                    DefaultAsyncFile.this.context.execute(new Runnable(){

                        @Override
                        public void run() {
                            DefaultAsyncFile.this.writesOutstanding -= buff.limit();
                            handler.handle(new AsyncResult<Void>((Void)null));
                        }
                    });
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof Exception) {
                    final Exception e = (Exception)exc;
                    DefaultAsyncFile.this.context.execute(new Runnable(){

                        @Override
                        public void run() {
                            handler.handle(new AsyncResult(e));
                        }
                    });
                } else {
                    log.error("Error occurred", exc);
                }
            }
        });
    }

    private void doRead(final Buffer writeBuff, final int offset, final ByteBuffer buff, final int position, final AsyncResultHandler<Buffer> handler) {
        this.ch.read(buff, position, null, new CompletionHandler<Integer, Object>(){
            int pos;
            {
                this.pos = position;
            }

            private void done() {
                DefaultAsyncFile.this.context.execute(new Runnable(){

                    @Override
                    public void run() {
                        buff.flip();
                        writeBuff.setBytes(offset, buff);
                        handler.handle(new AsyncResult<Buffer>(writeBuff));
                    }
                });
            }

            @Override
            public void completed(Integer bytesRead, Object attachment) {
                if (bytesRead == -1) {
                    this.done();
                } else if (buff.hasRemaining()) {
                    this.pos += bytesRead.intValue();
                    DefaultAsyncFile.this.doRead(writeBuff, offset, buff, this.pos, handler);
                } else {
                    this.done();
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof Exception) {
                    final Exception e = (Exception)exc;
                    DefaultAsyncFile.this.context.execute(new Runnable(){

                        @Override
                        public void run() {
                            handler.handle(new AsyncResult(e));
                        }
                    });
                } else {
                    DefaultAsyncFile.this.vertx.reportException(exc);
                }
            }
        });
    }

    private void check() {
        this.checkClosed();
        this.checkContext();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("File handle is closed");
        }
    }

    private void checkContext() {
        if (!this.vertx.getContext().equals(this.context)) {
            throw new IllegalStateException("AsyncFile must only be used in the context that created it, expected: " + this.context + " actual " + this.vertx.getContext());
        }
    }

    private void doClose(AsyncResultHandler<Void> handler) {
        AsyncResult<Object> res;
        try {
            this.ch.close();
            res = new AsyncResult<Void>((Void)null);
        }
        catch (IOException e) {
            res = new AsyncResult(e);
        }
        if (handler != null) {
            handler.handle(res);
        }
    }

    private void closeInternal(final AsyncResultHandler<Void> handler) {
        this.check();
        this.closed = true;
        if (this.writesOutstanding == 0L) {
            this.doClose(handler);
        } else {
            this.closedDeferred = new Runnable(){

                @Override
                public void run() {
                    DefaultAsyncFile.this.doClose(handler);
                }
            };
        }
    }
}

