/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.file.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.file.FileProps;
import org.vertx.java.core.file.FileSystem;
import org.vertx.java.core.file.FileSystemException;
import org.vertx.java.core.file.FileSystemProps;
import org.vertx.java.core.file.impl.DefaultAsyncFile;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.impl.BlockingAction;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultFileSystem
implements FileSystem {
    private static final Logger log = LoggerFactory.getLogger(DefaultFileSystem.class);
    protected final VertxInternal vertx;

    public DefaultFileSystem(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public void copy(String from, String to, AsyncResultHandler<Void> handler) {
        this.copyInternal(from, to, handler).run();
    }

    @Override
    public void copySync(String from, String to) throws Exception {
        this.copyInternal(from, to, null).action();
    }

    @Override
    public void copy(String from, String to, boolean recursive, AsyncResultHandler<Void> handler) {
        this.copyInternal(from, to, recursive, handler).run();
    }

    @Override
    public void copySync(String from, String to, boolean recursive) throws Exception {
        this.copyInternal(from, to, recursive, null).action();
    }

    @Override
    public void move(String from, String to, AsyncResultHandler<Void> handler) {
        this.moveInternal(from, to, handler).run();
    }

    @Override
    public void moveSync(String from, String to) throws Exception {
        this.moveInternal(from, to, null).action();
    }

    @Override
    public void truncate(String path, long len, AsyncResultHandler<Void> handler) {
        this.truncateInternal(path, len, handler).run();
    }

    @Override
    public void truncateSync(String path, long len) throws Exception {
        this.truncateInternal(path, len, null).action();
    }

    @Override
    public void chmod(String path, String perms, AsyncResultHandler<Void> handler) {
        this.chmodInternal(path, perms, handler).run();
    }

    @Override
    public void chmodSync(String path, String perms) throws Exception {
        this.chmodInternal(path, perms, null).action();
    }

    @Override
    public void chmod(String path, String perms, String dirPerms, AsyncResultHandler<Void> handler) {
        this.chmodInternal(path, perms, dirPerms, handler).run();
    }

    @Override
    public void chmodSync(String path, String perms, String dirPerms) throws Exception {
        this.chmodInternal(path, perms, dirPerms, null).action();
    }

    @Override
    public void props(String path, AsyncResultHandler<FileProps> handler) {
        this.propsInternal(path, handler).run();
    }

    @Override
    public FileProps propsSync(String path) throws Exception {
        return this.propsInternal(path, null).action();
    }

    @Override
    public void lprops(String path, AsyncResultHandler<FileProps> handler) {
        this.lpropsInternal(path, handler).run();
    }

    @Override
    public FileProps lpropsSync(String path) throws Exception {
        return this.lpropsInternal(path, null).action();
    }

    @Override
    public void link(String link, String existing, AsyncResultHandler<Void> handler) {
        this.linkInternal(link, existing, handler).run();
    }

    @Override
    public void linkSync(String link, String existing) throws Exception {
        this.linkInternal(link, existing, null).action();
    }

    @Override
    public void symlink(String link, String existing, AsyncResultHandler<Void> handler) {
        this.symlinkInternal(link, existing, handler).run();
    }

    @Override
    public void symlinkSync(String link, String existing) throws Exception {
        this.symlinkInternal(link, existing, null).action();
    }

    @Override
    public void unlink(String link, AsyncResultHandler<Void> handler) {
        this.unlinkInternal(link, handler).run();
    }

    @Override
    public void unlinkSync(String link) throws Exception {
        this.unlinkInternal(link, null).action();
    }

    @Override
    public void readSymlink(String link, AsyncResultHandler<String> handler) {
        this.readSymlinkInternal(link, handler).run();
    }

    @Override
    public String readSymlinkSync(String link) throws Exception {
        return this.readSymlinkInternal(link, null).action();
    }

    @Override
    public void delete(String path, AsyncResultHandler<Void> handler) {
        this.deleteInternal(path, handler).run();
    }

    @Override
    public void deleteSync(String path) throws Exception {
        this.deleteInternal(path, null).action();
    }

    @Override
    public void delete(String path, boolean recursive, AsyncResultHandler<Void> handler) {
        this.deleteInternal(path, recursive, handler).run();
    }

    @Override
    public void deleteSync(String path, boolean recursive) throws Exception {
        this.deleteInternal(path, recursive, null).action();
    }

    @Override
    public void mkdir(String path, AsyncResultHandler<Void> handler) {
        this.mkdirInternal(path, handler).run();
    }

    @Override
    public void mkdirSync(String path) throws Exception {
        this.mkdirInternal(path, null).action();
    }

    @Override
    public void mkdir(String path, boolean createParents, AsyncResultHandler<Void> handler) {
        this.mkdirInternal(path, createParents, handler).run();
    }

    @Override
    public void mkdirSync(String path, boolean createParents) throws Exception {
        this.mkdirInternal(path, createParents, null).action();
    }

    @Override
    public void mkdir(String path, String perms, AsyncResultHandler<Void> handler) {
        this.mkdirInternal(path, perms, handler).run();
    }

    @Override
    public void mkdirSync(String path, String perms) throws Exception {
        this.mkdirInternal(path, perms, null).action();
    }

    @Override
    public void mkdir(String path, String perms, boolean createParents, AsyncResultHandler<Void> handler) {
        this.mkdirInternal(path, perms, createParents, handler).run();
    }

    @Override
    public void mkdirSync(String path, String perms, boolean createParents) throws Exception {
        this.mkdirInternal(path, perms, createParents, null).action();
    }

    @Override
    public void readDir(String path, AsyncResultHandler<String[]> handler) {
        this.readDirInternal(path, handler).run();
    }

    @Override
    public String[] readDirSync(String path) throws Exception {
        return this.readDirInternal(path, null).action();
    }

    @Override
    public void readDir(String path, String filter, AsyncResultHandler<String[]> handler) {
        this.readDirInternal(path, filter, handler).run();
    }

    @Override
    public String[] readDirSync(String path, String filter) throws Exception {
        return this.readDirInternal(path, filter, null).action();
    }

    @Override
    public void readFile(String path, AsyncResultHandler<Buffer> handler) {
        this.readFileInternal(path, handler).run();
    }

    @Override
    public Buffer readFileSync(String path) throws Exception {
        return this.readFileInternal(path, null).action();
    }

    @Override
    public void writeFile(String path, Buffer data, AsyncResultHandler<Void> handler) {
        this.writeFileInternal(path, data, handler).run();
    }

    @Override
    public void writeFileSync(String path, Buffer data) throws Exception {
        this.writeFileInternal(path, data, null).action();
    }

    @Override
    public void open(String path, AsyncResultHandler<AsyncFile> handler) {
        this.openInternal(path, handler).run();
    }

    @Override
    public AsyncFile openSync(String path) throws Exception {
        return this.openInternal(path, null).action();
    }

    @Override
    public void open(String path, String perms, AsyncResultHandler<AsyncFile> handler) {
        this.openInternal(path, perms, handler).run();
    }

    @Override
    public AsyncFile openSync(String path, String perms) throws Exception {
        return this.openInternal(path, perms, null).action();
    }

    @Override
    public void open(String path, String perms, boolean createNew, AsyncResultHandler<AsyncFile> handler) {
        this.openInternal(path, perms, createNew, handler).run();
    }

    @Override
    public AsyncFile openSync(String path, String perms, boolean createNew) throws Exception {
        return this.openInternal(path, perms, createNew, null).action();
    }

    @Override
    public void open(String path, String perms, boolean read, boolean write, boolean createNew, AsyncResultHandler<AsyncFile> handler) {
        this.openInternal(path, perms, read, write, createNew, handler).run();
    }

    @Override
    public AsyncFile openSync(String path, String perms, boolean read, boolean write, boolean createNew) throws Exception {
        return this.openInternal(path, perms, read, write, createNew, null).action();
    }

    @Override
    public void open(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, AsyncResultHandler<AsyncFile> handler) {
        this.openInternal(path, perms, read, write, createNew, flush, handler).run();
    }

    @Override
    public AsyncFile openSync(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush) throws Exception {
        return this.openInternal(path, perms, read, write, createNew, flush, null).action();
    }

    @Override
    public void createFile(String path, AsyncResultHandler<Void> handler) {
        this.createFileInternal(path, handler).run();
    }

    @Override
    public void createFileSync(String path) throws Exception {
        this.createFileInternal(path, null).action();
    }

    @Override
    public void createFile(String path, String perms, AsyncResultHandler<Void> handler) {
        this.createFileInternal(path, perms, handler).run();
    }

    @Override
    public void createFileSync(String path, String perms) throws Exception {
        this.createFileInternal(path, perms, null).action();
    }

    @Override
    public void exists(String path, AsyncResultHandler<Boolean> handler) {
        this.existsInternal(path, handler).run();
    }

    @Override
    public boolean existsSync(String path) throws Exception {
        return this.existsInternal(path, null).action();
    }

    @Override
    public void fsProps(String path, AsyncResultHandler<FileSystemProps> handler) {
        this.fsPropsInternal(path, handler).run();
    }

    @Override
    public FileSystemProps fsPropsSync(String path) throws Exception {
        return this.fsPropsInternal(path, null).action();
    }

    private BlockingAction<Void> copyInternal(String from, String to, AsyncResultHandler<Void> handler) {
        return this.copyInternal(from, to, false, handler);
    }

    private BlockingAction<Void> copyInternal(String from, String to, final boolean recursive, AsyncResultHandler<Void> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(from, new String[0]));
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(to, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                try {
                    if (recursive) {
                        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                block2: {
                                    Path targetDir = target.resolve(source.relativize(dir));
                                    try {
                                        Files.copy(dir, targetDir, new CopyOption[0]);
                                    }
                                    catch (FileAlreadyExistsException e) {
                                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                        throw e;
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.copy(file, target.resolve(source.relativize(file)), new CopyOption[0]);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.copy(source, target, new CopyOption[0]);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("File already exists " + e.getMessage());
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> moveInternal(String from, String to, AsyncResultHandler<Void> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(from, new String[0]));
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(to, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                try {
                    Files.move(source, target, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("Failed to move between " + source + " and " + target + ". Target already exists");
                }
                catch (AtomicMoveNotSupportedException e) {
                    throw new FileSystemException("Atomic move not supported between " + source + " and " + target);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> truncateInternal(String p, final long len, AsyncResultHandler<Void> handler) {
        final String path = PathAdjuster.adjust(this.vertx, p);
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                if (len < 0L) {
                    throw new FileSystemException("Cannot truncate file to size < 0");
                }
                if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                    throw new FileSystemException("Cannot truncate file " + path + ". Does not exist");
                }
                try (RandomAccessFile raf = null;){
                    raf = new RandomAccessFile(path, "rw");
                    raf.getChannel().truncate(len);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> chmodInternal(String path, String perms, AsyncResultHandler<Void> handler) {
        return this.chmodInternal(path, perms, null, handler);
    }

    protected BlockingAction<Void> chmodInternal(String path, String perms, String dirPerms, AsyncResultHandler<Void> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        final Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(perms);
        final Set<PosixFilePermission> dirPermissions = dirPerms == null ? null : PosixFilePermissions.fromString(dirPerms);
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                try {
                    if (dirPermissions != null) {
                        Files.walkFileTree(target, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(dir, dirPermissions);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(file, permissions);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.setPosixFilePermissions(target, permissions);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chmod on " + target);
                }
                return null;
            }
        };
    }

    private BlockingAction<FileProps> propsInternal(String path, AsyncResultHandler<FileProps> handler) {
        return this.props(path, true, handler);
    }

    private BlockingAction<FileProps> lpropsInternal(String path, AsyncResultHandler<FileProps> handler) {
        return this.props(path, false, handler);
    }

    private BlockingAction<FileProps> props(String path, final boolean followLinks, AsyncResultHandler<FileProps> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<FileProps>(this.vertx, handler){

            @Override
            public FileProps action() throws Exception {
                try {
                    BasicFileAttributes attrs = followLinks ? Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]) : Files.readAttributes(target, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    return new FileProps(attrs);
                }
                catch (NoSuchFileException e) {
                    throw new FileSystemException("No such file: " + target);
                }
            }
        };
    }

    private BlockingAction<Void> linkInternal(String link, String existing, AsyncResultHandler<Void> handler) {
        return this.link(link, existing, false, handler);
    }

    private BlockingAction<Void> symlinkInternal(String link, String existing, AsyncResultHandler<Void> handler) {
        return this.link(link, existing, true, handler);
    }

    private BlockingAction<Void> link(String link, String existing, final boolean symbolic, AsyncResultHandler<Void> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(link, new String[0]));
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(existing, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                try {
                    if (symbolic) {
                        Files.createSymbolicLink(source, target, new FileAttribute[0]);
                    } else {
                        Files.createLink(source, target);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("Cannot create link, file already exists: " + source);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> unlinkInternal(String link, AsyncResultHandler<Void> handler) {
        return this.deleteInternal(link, handler);
    }

    private BlockingAction<String> readSymlinkInternal(String link, AsyncResultHandler<String> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(link, new String[0]));
        return new BlockingAction<String>(this.vertx, handler){

            @Override
            public String action() throws Exception {
                try {
                    return Files.readSymbolicLink(source).toString();
                }
                catch (NotLinkException e) {
                    throw new FileSystemException("Cannot read " + source + " it's not a symbolic link");
                }
            }
        };
    }

    private BlockingAction<Void> deleteInternal(String path, AsyncResultHandler<Void> handler) {
        return this.deleteInternal(path, false, handler);
    }

    private BlockingAction<Void> deleteInternal(String path, final boolean recursive, AsyncResultHandler<Void> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                if (recursive) {
                    Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                            if (e == null) {
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                            throw e;
                        }
                    });
                } else {
                    try {
                        Files.delete(source);
                    }
                    catch (NoSuchFileException e) {
                        throw new FileSystemException("Cannot delete file, it does not exist: " + source);
                    }
                    catch (DirectoryNotEmptyException e) {
                        throw new FileSystemException("Cannot delete directory, it is not empty: " + source + ". Use recursive delete");
                    }
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> mkdirInternal(String path, AsyncResultHandler<Void> handler) {
        return this.mkdirInternal(path, null, false, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path, boolean createParents, AsyncResultHandler<Void> handler) {
        return this.mkdirInternal(path, null, createParents, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path, String perms, AsyncResultHandler<Void> handler) {
        return this.mkdirInternal(path, perms, false, handler);
    }

    protected BlockingAction<Void> mkdirInternal(String path, String perms, final boolean createParents, AsyncResultHandler<Void> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                try {
                    if (createParents) {
                        if (attrs != null) {
                            Files.createDirectories(source, attrs);
                        } else {
                            Files.createDirectories(source, new FileAttribute[0]);
                        }
                    } else if (attrs != null) {
                        Files.createDirectory(source, attrs);
                    } else {
                        Files.createDirectory(source, new FileAttribute[0]);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("Cannot create directory: " + source + ". It already exists");
                }
                catch (NoSuchFileException e) {
                    throw new FileSystemException("Canot create directory: " + source + " it has parents");
                }
                return null;
            }
        };
    }

    private BlockingAction<String[]> readDirInternal(String path, AsyncResultHandler<String[]> handler) {
        return this.readDirInternal(path, null, handler);
    }

    private BlockingAction<String[]> readDirInternal(String p, final String filter, AsyncResultHandler<String[]> handler) {
        final String path = PathAdjuster.adjust(this.vertx, p);
        return new BlockingAction<String[]>(this.vertx, handler){

            @Override
            public String[] action() throws Exception {
                File file = new File(path);
                if (!file.exists()) {
                    throw new FileSystemException("Cannot read directory " + path + ". Does not exist");
                }
                if (!file.isDirectory()) {
                    throw new FileSystemException("Cannot read directory " + path + ". It's not a directory");
                }
                FilenameFilter fnFilter = filter != null ? new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return Pattern.matches(filter, name);
                    }
                } : null;
                File[] files = fnFilter == null ? file.listFiles() : file.listFiles(fnFilter);
                String[] ret = new String[files.length];
                int i = 0;
                for (File f : files) {
                    ret[i++] = f.getCanonicalPath();
                }
                return ret;
            }
        };
    }

    private BlockingAction<Buffer> readFileInternal(String path, AsyncResultHandler<Buffer> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<Buffer>(this.vertx, handler){

            @Override
            public Buffer action() throws Exception {
                byte[] bytes = Files.readAllBytes(target);
                Buffer buff = new Buffer(bytes);
                return buff;
            }
        };
    }

    private BlockingAction<Void> writeFileInternal(String path, final Buffer data, AsyncResultHandler<Void> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                Files.write(target, data.getBytes(), new OpenOption[0]);
                return null;
            }
        };
    }

    private BlockingAction<AsyncFile> openInternal(String path, AsyncResultHandler<AsyncFile> handler) {
        return this.openInternal(path, null, true, true, true, false, handler);
    }

    private BlockingAction<AsyncFile> openInternal(String path, String perms, AsyncResultHandler<AsyncFile> handler) {
        return this.openInternal(path, perms, true, true, true, false, handler);
    }

    private BlockingAction<AsyncFile> openInternal(String path, String perms, boolean createNew, AsyncResultHandler<AsyncFile> handler) {
        return this.openInternal(path, perms, true, true, createNew, false, handler);
    }

    private BlockingAction<AsyncFile> openInternal(String path, String perms, boolean read, boolean write, boolean createNew, AsyncResultHandler<AsyncFile> handler) {
        return this.openInternal(path, perms, read, write, createNew, false, handler);
    }

    private BlockingAction<AsyncFile> openInternal(String p, final String perms, final boolean read, final boolean write, final boolean createNew, final boolean flush, AsyncResultHandler<AsyncFile> handler) {
        final String path = PathAdjuster.adjust(this.vertx, p);
        return new BlockingAction<AsyncFile>(this.vertx, handler){

            @Override
            public AsyncFile action() throws Exception {
                return DefaultFileSystem.this.doOpen(path, perms, read, write, createNew, flush, this.context);
            }
        };
    }

    protected AsyncFile doOpen(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, Context context) throws Exception {
        return new DefaultAsyncFile(this.vertx, path, perms, read, write, createNew, flush, context);
    }

    private BlockingAction<Void> createFileInternal(String path, AsyncResultHandler<Void> handler) {
        return this.createFileInternal(path, null, handler);
    }

    protected BlockingAction<Void> createFileInternal(String p, String perms, AsyncResultHandler<Void> handler) {
        final String path = PathAdjuster.adjust(this.vertx, p);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() throws Exception {
                try {
                    Path target = Paths.get(path, new String[0]);
                    if (attrs != null) {
                        Files.createFile(target, attrs);
                    } else {
                        Files.createFile(target, new FileAttribute[0]);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("Cannot create link, file already exists: " + path);
                }
                return null;
            }
        };
    }

    private BlockingAction<Boolean> existsInternal(String path, AsyncResultHandler<Boolean> handler) {
        final File file = new File(PathAdjuster.adjust(this.vertx, path));
        return new BlockingAction<Boolean>(this.vertx, handler){

            @Override
            public Boolean action() throws Exception {
                return file.exists();
            }
        };
    }

    private BlockingAction<FileSystemProps> fsPropsInternal(String path, AsyncResultHandler<FileSystemProps> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<FileSystemProps>(this.vertx, handler){

            @Override
            public FileSystemProps action() throws Exception {
                FileStore fs = Files.getFileStore(target);
                return new FileSystemProps(fs.getTotalSpace(), fs.getUnallocatedSpace(), fs.getUsableSpace());
            }
        };
    }
}

