/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class RouteMatcher
implements Handler<HttpServerRequest> {
    private static final Logger log = LoggerFactory.getLogger(RouteMatcher.class);
    private List<PatternBinding> getBindings = new ArrayList<PatternBinding>();
    private List<PatternBinding> putBindings = new ArrayList<PatternBinding>();
    private List<PatternBinding> postBindings = new ArrayList<PatternBinding>();
    private List<PatternBinding> deleteBindings = new ArrayList<PatternBinding>();
    private List<PatternBinding> optionsBindings = new ArrayList<PatternBinding>();
    private List<PatternBinding> headBindings = new ArrayList<PatternBinding>();
    private List<PatternBinding> traceBindings = new ArrayList<PatternBinding>();
    private List<PatternBinding> connectBindings = new ArrayList<PatternBinding>();
    private List<PatternBinding> patchBindings = new ArrayList<PatternBinding>();
    private Handler<HttpServerRequest> noMatchHandler;

    @Override
    public void handle(HttpServerRequest request) {
        switch (request.method) {
            case "GET": {
                this.route(request, this.getBindings);
                break;
            }
            case "PUT": {
                this.route(request, this.putBindings);
                break;
            }
            case "POST": {
                this.route(request, this.postBindings);
                break;
            }
            case "DELETE": {
                this.route(request, this.deleteBindings);
                break;
            }
            case "OPTIONS": {
                this.route(request, this.optionsBindings);
                break;
            }
            case "HEAD": {
                this.route(request, this.headBindings);
                break;
            }
            case "TRACE": {
                this.route(request, this.traceBindings);
                break;
            }
            case "PATCH": {
                this.route(request, this.patchBindings);
                break;
            }
            case "CONNECT": {
                this.route(request, this.connectBindings);
            }
        }
    }

    public void get(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.getBindings);
    }

    public void put(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.putBindings);
    }

    public void post(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.postBindings);
    }

    public void delete(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.deleteBindings);
    }

    public void options(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.optionsBindings);
    }

    public void head(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.headBindings);
    }

    public void trace(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.traceBindings);
    }

    public void connect(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.connectBindings);
    }

    public void patch(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.patchBindings);
    }

    public void all(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(pattern, handler, this.getBindings);
        this.addPattern(pattern, handler, this.putBindings);
        this.addPattern(pattern, handler, this.postBindings);
        this.addPattern(pattern, handler, this.deleteBindings);
        this.addPattern(pattern, handler, this.optionsBindings);
        this.addPattern(pattern, handler, this.headBindings);
        this.addPattern(pattern, handler, this.traceBindings);
        this.addPattern(pattern, handler, this.connectBindings);
        this.addPattern(pattern, handler, this.patchBindings);
    }

    public void getWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.getBindings);
    }

    public void putWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.putBindings);
    }

    public void postWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.postBindings);
    }

    public void deleteWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.deleteBindings);
    }

    public void optionsWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.optionsBindings);
    }

    public void headWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.headBindings);
    }

    public void traceWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.traceBindings);
    }

    public void connectWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.connectBindings);
    }

    public void patchWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.patchBindings);
    }

    public void allWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(regex, handler, this.getBindings);
        this.addRegEx(regex, handler, this.putBindings);
        this.addRegEx(regex, handler, this.postBindings);
        this.addRegEx(regex, handler, this.deleteBindings);
        this.addRegEx(regex, handler, this.optionsBindings);
        this.addRegEx(regex, handler, this.headBindings);
        this.addRegEx(regex, handler, this.traceBindings);
        this.addRegEx(regex, handler, this.connectBindings);
        this.addRegEx(regex, handler, this.patchBindings);
    }

    public void noMatch(Handler<HttpServerRequest> handler) {
        this.noMatchHandler = handler;
    }

    private void addPattern(String input, Handler<HttpServerRequest> handler, List<PatternBinding> bindings) {
        Matcher m = Pattern.compile(":([A-Za-z][A-Za-z0-9]*)").matcher(input);
        StringBuffer sb = new StringBuffer();
        HashSet<String> groups = new HashSet<String>();
        while (m.find()) {
            String group = m.group().substring(1);
            if (groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, "(?<$1>[^\\/]+)");
            groups.add(group);
        }
        m.appendTail(sb);
        String regex = sb.toString();
        PatternBinding binding = new PatternBinding(Pattern.compile(regex), groups, handler);
        bindings.add(binding);
    }

    private void addRegEx(String input, Handler<HttpServerRequest> handler, List<PatternBinding> bindings) {
        PatternBinding binding = new PatternBinding(Pattern.compile(input), null, handler);
        bindings.add(binding);
    }

    private void route(HttpServerRequest request, List<PatternBinding> bindings) {
        for (PatternBinding binding : bindings) {
            Matcher m = binding.pattern.matcher(request.path);
            if (!m.matches()) continue;
            HashMap<String, String> params = new HashMap<String, String>(m.groupCount());
            if (binding.paramNames != null) {
                for (String param : binding.paramNames) {
                    params.put(param, m.group(param));
                }
            } else {
                for (int i = 0; i < m.groupCount(); ++i) {
                    params.put("param" + i, m.group(i + 1));
                }
            }
            request.params().putAll(params);
            binding.handler.handle(request);
            return;
        }
        if (this.noMatchHandler != null) {
            this.noMatchHandler.handle(request);
        } else {
            request.response.statusCode = 404;
            request.response.end();
        }
    }

    private static class PatternBinding {
        final Pattern pattern;
        final Handler<HttpServerRequest> handler;
        final Set<String> paramNames;

        private PatternBinding(Pattern pattern, Set<String> paramNames, Handler<HttpServerRequest> handler) {
            this.pattern = pattern;
            this.paramNames = paramNames;
            this.handler = handler;
        }
    }
}

