/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.WebSocket;
import org.vertx.java.core.http.WebSocketVersion;
import org.vertx.java.core.http.impl.AbstractConnection;
import org.vertx.java.core.http.impl.DefaultHttpClient;
import org.vertx.java.core.http.impl.DefaultHttpClientRequest;
import org.vertx.java.core.http.impl.DefaultHttpClientResponse;
import org.vertx.java.core.http.impl.DefaultWebSocket;
import org.vertx.java.core.http.impl.SwitchingHttpResponseDecoder;
import org.vertx.java.core.http.impl.ws.Handshake;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.http.impl.ws.hybi00.Handshake00;
import org.vertx.java.core.http.impl.ws.hybi08.Handshake08;
import org.vertx.java.core.http.impl.ws.hybi17.HandshakeRFC6455;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class ClientConnection
extends AbstractConnection {
    private static final Logger log = LoggerFactory.getLogger(ClientConnection.class);
    final DefaultHttpClient client;
    final String hostHeader;
    boolean keepAlive;
    private final boolean ssl;
    private boolean wsHandshakeConnection;
    private volatile DefaultHttpClientRequest currentRequest;
    private final Queue<DefaultHttpClientRequest> requests = new ConcurrentLinkedQueue<DefaultHttpClientRequest>();
    private volatile DefaultHttpClientResponse currentResponse;
    private DefaultWebSocket ws;

    ClientConnection(VertxInternal vertx, DefaultHttpClient client, Channel channel, String hostHeader, boolean ssl, boolean keepAlive, Context context) {
        super(vertx, channel, context);
        this.client = client;
        this.hostHeader = hostHeader;
        this.ssl = ssl;
        this.keepAlive = keepAlive;
    }

    void toWebSocket(String uri, final Handler<WebSocket> wsConnect, WebSocketVersion wsVersion) {
        if (this.ws != null) {
            throw new IllegalStateException("Already websocket");
        }
        try {
            Handshake shake;
            if (wsVersion == WebSocketVersion.HYBI_00) {
                shake = new Handshake00();
            } else if (wsVersion == WebSocketVersion.HYBI_08) {
                shake = new Handshake08();
            } else if (wsVersion == WebSocketVersion.RFC6455) {
                shake = new HandshakeRFC6455();
            } else {
                throw new IllegalArgumentException("Invalid version");
            }
            final ChannelPipeline p = this.channel.getPipeline();
            SwitchingHttpResponseDecoder decoder = (SwitchingHttpResponseDecoder)p.get("decoder");
            decoder.setSwitch("wsdecoder", shake.getDecoder());
            this.wsHandshakeConnection = true;
            DefaultHttpClientRequest req = new DefaultHttpClientRequest(this.client, "GET", uri, new Handler<HttpClientResponse>(){

                @Override
                public void handle(HttpClientResponse resp) {
                    if (resp.statusCode == 101) {
                        try {
                            shake.onComplete(resp, new AsyncResultHandler<Void>(){

                                @Override
                                public void handle(AsyncResult<Void> fut) {
                                    if (fut.succeeded()) {
                                        p.replace("encoder", "wsencoder", shake.getEncoder(false));
                                        ClientConnection.this.ws = new DefaultWebSocket(ClientConnection.this.vertx, null, ClientConnection.this, null);
                                        wsConnect.handle(ClientConnection.this.ws);
                                    } else {
                                        ClientConnection.this.client.handleException(fut.exception);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            ClientConnection.this.client.handleException(e);
                        }
                    } else {
                        ClientConnection.this.client.handleException(new IOException("Websocket connection attempt returned HTTP status code " + resp.statusCode));
                    }
                }
            }, this.context, this);
            shake.fillInRequest(req, (this.ssl ? "http://" : "https://") + this.hostHeader);
            req.end();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void close() {
        if (!this.wsHandshakeConnection) {
            if (!this.keepAlive) {
                this.internalClose();
            } else {
                this.client.returnConnection(this);
            }
        }
    }

    void internalClose() {
        this.channel.close();
    }

    boolean isClosed() {
        return !this.channel.isOpen();
    }

    void handleInterestedOpsChanged() {
        try {
            if (this.channel.isWritable()) {
                if (this.currentRequest != null) {
                    this.setContext();
                    this.currentRequest.handleDrained();
                } else if (this.ws != null) {
                    this.ws.writable();
                }
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleResponse(HttpResponse resp) {
        DefaultHttpClientResponse nResp;
        DefaultHttpClientRequest req = resp.getStatus().getCode() == 100 ? this.requests.peek() : this.requests.poll();
        if (req == null) {
            throw new IllegalStateException("No response handler");
        }
        this.setContext();
        this.currentResponse = nResp = new DefaultHttpClientResponse(this, resp);
        req.handleResponse(nResp);
    }

    void handleResponseChunk(Buffer buff) {
        this.setContext();
        try {
            this.currentResponse.handleChunk(buff);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleResponseEnd() {
        this.handleResponseEnd(null);
    }

    void handleResponseEnd(HttpChunkTrailer trailer) {
        this.setContext();
        try {
            this.currentResponse.handleEnd(trailer);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
        if (!this.keepAlive) {
            this.close();
        }
    }

    void handleWsFrame(WebSocketFrame frame) {
        if (this.ws != null) {
            this.setContext();
            this.ws.handleFrame(frame);
        }
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
    }

    @Override
    protected Context getContext() {
        return super.getContext();
    }

    @Override
    protected void handleException(Exception e) {
        super.handleException(e);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        } else if (this.currentResponse != null) {
            this.currentResponse.handleException(e);
        }
    }

    @Override
    protected void addFuture(Handler<Void> doneHandler, ChannelFuture future) {
        super.addFuture(doneHandler, future);
    }

    @Override
    ChannelFuture write(Object obj) {
        if (!this.channel.isOpen()) {
            throw new IllegalStateException("Connection is closed");
        }
        return this.channel.write(obj);
    }

    void setCurrentRequest(DefaultHttpClientRequest req) {
        if (this.currentRequest != null) {
            throw new IllegalStateException("Connection is already writing a request");
        }
        this.currentRequest = req;
        this.requests.add(req);
    }

    void endRequest() {
        if (this.currentRequest == null) {
            throw new IllegalStateException("No write in progress");
        }
        this.currentRequest = null;
        if (this.keepAlive) {
            this.close();
        }
    }
}

