/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.ssl.SslHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.SimpleHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.WebSocket;
import org.vertx.java.core.http.WebSocketVersion;
import org.vertx.java.core.http.impl.ClientConnection;
import org.vertx.java.core.http.impl.DefaultHttpClientRequest;
import org.vertx.java.core.http.impl.SwitchingHttpResponseDecoder;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.ConnectionPool;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.EventLoopContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.impl.TCPSSLHelper;
import org.vertx.java.core.net.impl.VertxWorkerPool;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequest.class);
    private final VertxInternal vertx;
    private final EventLoopContext ctx;
    private final TCPSSLHelper tcpHelper = new TCPSSLHelper();
    private ClientBootstrap bootstrap;
    private NioClientSocketChannelFactory channelFactory;
    private Map<Channel, ClientConnection> connectionMap = new ConcurrentHashMap<Channel, ClientConnection>();
    private Handler<Exception> exceptionHandler;
    private int port = 80;
    private String host = "localhost";
    private final ConnectionPool<ClientConnection> pool = new ConnectionPool<ClientConnection>(){

        @Override
        protected void connect(Handler<ClientConnection> connectHandler, Handler<Exception> connectErrorHandler, Context context) {
            DefaultHttpClient.this.internalConnect(connectHandler, connectErrorHandler);
        }
    };
    private boolean keepAlive = true;

    public DefaultHttpClient(VertxInternal vertx) {
        this.vertx = vertx;
        if (vertx.isWorker()) {
            throw new IllegalStateException("Cannot be used in a worker application");
        }
        this.ctx = (EventLoopContext)vertx.getOrAssignContext();
        this.ctx.putCloseHook(this, new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient.this.close();
            }
        });
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.exceptionHandler = handler;
    }

    @Override
    public DefaultHttpClient setMaxPoolSize(int maxConnections) {
        this.pool.setMaxPoolSize(maxConnections);
        return this;
    }

    @Override
    public int getMaxPoolSize() {
        return this.pool.getMaxPoolSize();
    }

    @Override
    public DefaultHttpClient setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public DefaultHttpClient setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public DefaultHttpClient setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public void connectWebsocket(String uri, Handler<WebSocket> wsConnect) {
        this.connectWebsocket(uri, WebSocketVersion.RFC6455, wsConnect);
    }

    @Override
    public void connectWebsocket(final String uri, final WebSocketVersion wsVersion, final Handler<WebSocket> wsConnect) {
        this.getConnection(new Handler<ClientConnection>(){

            @Override
            public void handle(ClientConnection conn) {
                if (!conn.isClosed()) {
                    conn.toWebSocket(uri, wsConnect, wsVersion);
                } else {
                    DefaultHttpClient.this.connectWebsocket(uri, wsVersion, wsConnect);
                }
            }
        }, this.exceptionHandler, this.ctx);
    }

    @Override
    public void getNow(String uri, Handler<HttpClientResponse> responseHandler) {
        this.getNow(uri, null, responseHandler);
    }

    @Override
    public void getNow(String uri, Map<String, ? extends Object> headers, Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest req = this.get(uri, responseHandler);
        if (headers != null) {
            req.headers().putAll(headers);
        }
        req.end();
    }

    @Override
    public HttpClientRequest options(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("OPTIONS", uri, responseHandler);
    }

    @Override
    public HttpClientRequest get(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("GET", uri, responseHandler);
    }

    @Override
    public HttpClientRequest head(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("HEAD", uri, responseHandler);
    }

    @Override
    public HttpClientRequest post(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("POST", uri, responseHandler);
    }

    @Override
    public HttpClientRequest put(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("PUT", uri, responseHandler);
    }

    @Override
    public HttpClientRequest delete(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("DELETE", uri, responseHandler);
    }

    @Override
    public HttpClientRequest trace(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("TRACE", uri, responseHandler);
    }

    @Override
    public HttpClientRequest connect(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("CONNECT", uri, responseHandler);
    }

    @Override
    public HttpClientRequest patch(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("PATCH", uri, responseHandler);
    }

    @Override
    public HttpClientRequest request(String method, String uri, Handler<HttpClientResponse> responseHandler) {
        return new DefaultHttpClientRequest(this, method, uri, responseHandler, this.ctx);
    }

    @Override
    public void close() {
        this.pool.close();
        for (ClientConnection conn : this.connectionMap.values()) {
            conn.internalClose();
        }
    }

    @Override
    public DefaultHttpClient setSSL(boolean ssl) {
        this.tcpHelper.setSSL(ssl);
        return this;
    }

    @Override
    public DefaultHttpClient setVerifyHost(boolean verifyHost) {
        this.tcpHelper.setVerifyHost(verifyHost);
        return this;
    }

    @Override
    public DefaultHttpClient setKeyStorePath(String path) {
        this.tcpHelper.setKeyStorePath(path);
        return this;
    }

    @Override
    public DefaultHttpClient setKeyStorePassword(String pwd) {
        this.tcpHelper.setKeyStorePassword(pwd);
        return this;
    }

    @Override
    public DefaultHttpClient setTrustStorePath(String path) {
        this.tcpHelper.setTrustStorePath(path);
        return this;
    }

    @Override
    public DefaultHttpClient setTrustStorePassword(String pwd) {
        this.tcpHelper.setTrustStorePassword(pwd);
        return this;
    }

    @Override
    public DefaultHttpClient setTrustAll(boolean trustAll) {
        this.tcpHelper.setTrustAll(trustAll);
        return this;
    }

    @Override
    public DefaultHttpClient setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpHelper.setTCPNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public DefaultHttpClient setSendBufferSize(int size) {
        this.tcpHelper.setSendBufferSize(size);
        return this;
    }

    @Override
    public DefaultHttpClient setReceiveBufferSize(int size) {
        this.tcpHelper.setReceiveBufferSize(size);
        return this;
    }

    @Override
    public DefaultHttpClient setTCPKeepAlive(boolean keepAlive) {
        this.tcpHelper.setTCPKeepAlive(keepAlive);
        return this;
    }

    @Override
    public DefaultHttpClient setReuseAddress(boolean reuse) {
        this.tcpHelper.setReuseAddress(reuse);
        return this;
    }

    @Override
    public DefaultHttpClient setSoLinger(boolean linger) {
        this.tcpHelper.setSoLinger(linger);
        return this;
    }

    @Override
    public DefaultHttpClient setTrafficClass(int trafficClass) {
        this.tcpHelper.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public DefaultHttpClient setConnectTimeout(long timeout) {
        this.tcpHelper.setConnectTimeout(timeout);
        return this;
    }

    @Override
    public DefaultHttpClient setBossThreads(int threads) {
        this.tcpHelper.setClientBossThreads(threads);
        return this;
    }

    @Override
    public Boolean isTCPNoDelay() {
        return this.tcpHelper.isTCPNoDelay();
    }

    @Override
    public Integer getSendBufferSize() {
        return this.tcpHelper.getSendBufferSize();
    }

    @Override
    public Integer getReceiveBufferSize() {
        return this.tcpHelper.getReceiveBufferSize();
    }

    @Override
    public Boolean isTCPKeepAlive() {
        return this.tcpHelper.isTCPKeepAlive();
    }

    @Override
    public Boolean isReuseAddress() {
        return this.tcpHelper.isReuseAddress();
    }

    @Override
    public Boolean isSoLinger() {
        return this.tcpHelper.isSoLinger();
    }

    @Override
    public Integer getTrafficClass() {
        return this.tcpHelper.getTrafficClass();
    }

    @Override
    public Long getConnectTimeout() {
        return this.tcpHelper.getConnectTimeout();
    }

    @Override
    public Integer getBossThreads() {
        return this.tcpHelper.getClientBossThreads();
    }

    @Override
    public boolean isSSL() {
        return this.tcpHelper.isSSL();
    }

    @Override
    public boolean isVerifyHost() {
        return this.tcpHelper.isVerifyHost();
    }

    @Override
    public boolean isTrustAll() {
        return this.tcpHelper.isTrustAll();
    }

    @Override
    public String getKeyStorePath() {
        return this.tcpHelper.getKeyStorePath();
    }

    @Override
    public String getKeyStorePassword() {
        return this.tcpHelper.getKeyStorePassword();
    }

    @Override
    public String getTrustStorePath() {
        return this.tcpHelper.getTrustStorePath();
    }

    @Override
    public String getTrustStorePassword() {
        return this.tcpHelper.getTrustStorePassword();
    }

    public void getConnection(Handler<ClientConnection> handler, Handler<Exception> connectionExceptionHandler, Context context) {
        this.pool.getConnection(handler, connectionExceptionHandler, context);
    }

    void returnConnection(ClientConnection conn) {
        this.pool.returnConnection(conn);
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        } else {
            log.error("Unhandled exception", e);
        }
    }

    VertxInternal getVertx() {
        return this.vertx;
    }

    private void internalConnect(final Handler<ClientConnection> connectHandler, final Handler<Exception> connectErrorHandler) {
        if (this.bootstrap == null) {
            VertxWorkerPool pool = new VertxWorkerPool();
            pool.addWorker(this.ctx.getWorker());
            Integer bossThreads = this.tcpHelper.getClientBossThreads();
            int threads = bossThreads == null ? 1 : bossThreads;
            this.channelFactory = new NioClientSocketChannelFactory(this.vertx.getAcceptorPool(), threads, pool, this.vertx.getTimer());
            this.bootstrap = new ClientBootstrap(this.channelFactory);
            this.tcpHelper.checkSSL(this.vertx);
            this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                @Override
                public ChannelPipeline getPipeline() throws Exception {
                    ChannelPipeline pipeline = Channels.pipeline();
                    if (DefaultHttpClient.this.tcpHelper.isSSL()) {
                        SSLEngine engine = DefaultHttpClient.this.tcpHelper.getSSLContext().createSSLEngine(DefaultHttpClient.this.host, DefaultHttpClient.this.port);
                        if (DefaultHttpClient.this.tcpHelper.isVerifyHost()) {
                            SSLParameters sslParameters = engine.getSSLParameters();
                            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                            engine.setSSLParameters(sslParameters);
                        }
                        engine.setUseClientMode(true);
                        pipeline.addLast("ssl", new SslHandler(engine));
                    }
                    pipeline.addLast("encoder", new HttpRequestEncoder());
                    pipeline.addLast("decoder", new SwitchingHttpResponseDecoder());
                    pipeline.addLast("handler", new ClientHandler());
                    return pipeline;
                }
            });
        }
        this.bootstrap.setOptions(this.tcpHelper.generateConnectionOptions(false));
        ChannelFuture future = this.bootstrap.connect(new InetSocketAddress(this.host, this.port));
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                final NioSocketChannel ch = (NioSocketChannel)channelFuture.getChannel();
                if (channelFuture.isSuccess()) {
                    if (DefaultHttpClient.this.tcpHelper.isSSL()) {
                        SslHandler sslHandler = (SslHandler)ch.getPipeline().get("ssl");
                        ChannelFuture fut = sslHandler.handshake();
                        fut.addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                                if (channelFuture.isSuccess()) {
                                    DefaultHttpClient.this.connected(ch, connectHandler);
                                } else {
                                    DefaultHttpClient.this.failed(ch, connectErrorHandler, new SSLHandshakeException("Failed to create SSL connection"));
                                }
                            }
                        });
                    } else {
                        DefaultHttpClient.this.connected(ch, connectHandler);
                    }
                } else {
                    DefaultHttpClient.this.failed(ch, connectErrorHandler, channelFuture.getCause());
                }
            }
        });
    }

    private void connected(final NioSocketChannel ch, final Handler<ClientConnection> connectHandler) {
        this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

            @Override
            public void run() {
                ClientConnection conn = new ClientConnection(DefaultHttpClient.this.vertx, DefaultHttpClient.this, ch, DefaultHttpClient.this.host + ":" + DefaultHttpClient.this.port, DefaultHttpClient.this.tcpHelper.isSSL(), DefaultHttpClient.this.keepAlive, DefaultHttpClient.this.ctx);
                conn.closedHandler(new SimpleHandler(){

                    @Override
                    public void handle() {
                        DefaultHttpClient.this.pool.connectionClosed();
                    }
                });
                DefaultHttpClient.this.connectionMap.put(ch, conn);
                DefaultHttpClient.this.vertx.setContext(DefaultHttpClient.this.ctx);
                connectHandler.handle(conn);
            }
        });
    }

    private void failed(final NioSocketChannel ch, Handler<Exception> connectionExceptionHandler, final Throwable t) {
        final Handler<Exception> exHandler = connectionExceptionHandler == null ? this.exceptionHandler : connectionExceptionHandler;
        this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient.this.pool.connectionClosed();
                ch.close();
            }
        });
        if (t instanceof Exception && exHandler != null) {
            this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                @Override
                public void run() {
                    DefaultHttpClient.this.vertx.setContext(DefaultHttpClient.this.ctx);
                    exHandler.handle((Exception)t);
                }
            });
        } else {
            log.error("Unhandled exception", t);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class ClientHandler
    extends SimpleChannelUpstreamHandler {
        private ClientHandler() {
        }

        @Override
        public void channelClosed(ChannelHandlerContext chctx, ChannelStateEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ClientConnection conn = (ClientConnection)DefaultHttpClient.this.connectionMap.remove(ch);
            if (conn != null) {
                DefaultHttpClient.this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        conn.handleClosed();
                    }
                });
            }
        }

        @Override
        public void channelInterestChanged(ChannelHandlerContext chctx, ChannelStateEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ClientConnection conn = (ClientConnection)DefaultHttpClient.this.connectionMap.get(ch);
            DefaultHttpClient.this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                @Override
                public void run() {
                    conn.handleInterestedOpsChanged();
                }
            });
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext chctx, ExceptionEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ClientConnection conn = (ClientConnection)DefaultHttpClient.this.connectionMap.get(ch);
            final Throwable t = e.getCause();
            if (conn != null && t instanceof Exception) {
                DefaultHttpClient.this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        conn.handleException((Exception)t);
                    }
                });
            }
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Channel ch = e.getChannel();
            ClientConnection conn = (ClientConnection)DefaultHttpClient.this.connectionMap.get(ch);
            Object msg = e.getMessage();
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                conn.handleResponse(response);
                ChannelBuffer content = response.getContent();
                if (content.readable()) {
                    conn.handleResponseChunk(new Buffer(content));
                }
                if (!response.isChunked() && response.getStatus().getCode() != 100) {
                    conn.handleResponseEnd();
                }
            } else if (msg instanceof HttpChunk) {
                HttpChunk chunk = (HttpChunk)msg;
                if (chunk.getContent().readable()) {
                    Buffer buff = new Buffer(chunk.getContent());
                    conn.handleResponseChunk(buff);
                }
                if (chunk.isLast()) {
                    if (chunk instanceof HttpChunkTrailer) {
                        HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                        conn.handleResponseEnd(trailer);
                    } else {
                        conn.handleResponseEnd();
                    }
                }
            } else if (msg instanceof WebSocketFrame) {
                WebSocketFrame frame = (WebSocketFrame)msg;
                conn.handleWsFrame(frame);
            } else {
                throw new IllegalStateException("Invalid object " + e.getMessage());
            }
        }
    }
}

