/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.impl.ClientConnection;
import org.vertx.java.core.http.impl.DefaultHttpClient;
import org.vertx.java.core.http.impl.DefaultHttpClientResponse;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.LowerCaseKeyMap;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultHttpClientRequest
implements HttpClientRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private final DefaultHttpClient client;
    private final HttpRequest request;
    private final Handler<HttpClientResponse> respHandler;
    private Handler<Void> continueHandler;
    private final Context context;
    private final boolean raw;
    private boolean chunked;
    private ClientConnection conn;
    private Handler<Void> drainHandler;
    private Handler<Exception> exceptionHandler;
    private boolean headWritten;
    private boolean completed;
    private LinkedList<PendingChunk> pendingChunks;
    private int pendingMaxSize = -1;
    private boolean connecting;
    private boolean writeHead;
    private long written;
    private long currentTimeoutTimerId = -1L;
    private Map<String, Object> headers;
    private boolean exceptionOccurred;

    DefaultHttpClientRequest(DefaultHttpClient client, String method, String uri, Handler<HttpClientResponse> respHandler, Context context) {
        this(client, method, uri, respHandler, context, false);
    }

    DefaultHttpClientRequest(DefaultHttpClient client, String method, String uri, Handler<HttpClientResponse> respHandler, Context context, ClientConnection conn) {
        this(client, method, uri, respHandler, context, true);
        this.conn = conn;
        conn.setCurrentRequest(this);
    }

    private DefaultHttpClientRequest(DefaultHttpClient client, String method, String uri, Handler<HttpClientResponse> respHandler, Context context, boolean raw) {
        this.client = client;
        this.request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf(method), uri);
        this.chunked = false;
        this.respHandler = respHandler;
        this.context = context;
        this.raw = raw;
    }

    @Override
    public DefaultHttpClientRequest setChunked(boolean chunked) {
        this.check();
        if (this.written > 0L) {
            throw new IllegalStateException("Cannot set chunked after data has been written on request");
        }
        this.chunked = chunked;
        return this;
    }

    @Override
    public Map<String, Object> headers() {
        if (this.headers == null) {
            this.headers = new LowerCaseKeyMap<Object>();
        }
        return this.headers;
    }

    @Override
    public HttpClientRequest putHeader(String name, Object value) {
        this.check();
        this.headers().put(name, value);
        return this;
    }

    @Override
    public void writeBuffer(Buffer chunk) {
        this.check();
        this.write(chunk.getChannelBuffer(), null);
    }

    @Override
    public DefaultHttpClientRequest write(Buffer chunk) {
        this.check();
        return this.write(chunk.getChannelBuffer(), null);
    }

    @Override
    public DefaultHttpClientRequest write(String chunk) {
        this.check();
        return this.write(new Buffer(chunk).getChannelBuffer(), null);
    }

    @Override
    public DefaultHttpClientRequest write(String chunk, String enc) {
        this.check();
        return this.write(new Buffer(chunk, enc).getChannelBuffer(), null);
    }

    @Override
    public DefaultHttpClientRequest write(Buffer chunk, Handler<Void> doneHandler) {
        this.check();
        return this.write(chunk.getChannelBuffer(), doneHandler);
    }

    @Override
    public DefaultHttpClientRequest write(String chunk, Handler<Void> doneHandler) {
        this.checkComplete();
        return this.write(new Buffer(chunk).getChannelBuffer(), doneHandler);
    }

    @Override
    public DefaultHttpClientRequest write(String chunk, String enc, Handler<Void> doneHandler) {
        this.check();
        return this.write(new Buffer(chunk, enc).getChannelBuffer(), doneHandler);
    }

    @Override
    public void setWriteQueueMaxSize(int maxSize) {
        this.check();
        if (this.conn != null) {
            this.conn.setWriteQueueMaxSize(maxSize);
        } else {
            this.pendingMaxSize = maxSize;
        }
    }

    @Override
    public boolean writeQueueFull() {
        this.check();
        if (this.conn != null) {
            return this.conn.writeQueueFull();
        }
        return false;
    }

    @Override
    public void drainHandler(Handler<Void> handler) {
        this.check();
        this.drainHandler = handler;
        if (this.conn != null) {
            this.conn.handleInterestedOpsChanged();
        }
    }

    @Override
    public void exceptionHandler(final Handler<Exception> handler) {
        this.check();
        this.exceptionHandler = new Handler<Exception>(){

            @Override
            public void handle(Exception event) {
                DefaultHttpClientRequest.this.cancelOutstandingTimeoutTimer();
                handler.handle(event);
            }
        };
    }

    @Override
    public void continueHandler(Handler<Void> handler) {
        this.check();
        this.continueHandler = handler;
    }

    @Override
    public DefaultHttpClientRequest sendHead() {
        this.check();
        if (this.conn != null) {
            if (!this.headWritten) {
                this.writeHead();
                this.headWritten = true;
            }
        } else {
            this.connect();
            this.writeHead = true;
        }
        return this;
    }

    @Override
    public void end(String chunk) {
        this.end(new Buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(new Buffer(chunk, enc));
    }

    @Override
    public void end(Buffer chunk) {
        if (!this.chunked && !this.contentLengthSet()) {
            this.headers().put("Content-Length", String.valueOf(chunk.length()));
        }
        this.write(chunk);
        this.end();
    }

    @Override
    public void end() {
        this.check();
        this.completed = true;
        if (this.conn != null) {
            if (!this.headWritten) {
                this.writeHead();
            } else if (this.chunked) {
                this.writeEndChunk();
            }
            this.conn.endRequest();
        } else {
            this.connect();
        }
    }

    @Override
    public HttpClientRequest setTimeout(final long timeoutMs) {
        this.cancelOutstandingTimeoutTimer();
        this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, new Handler<Long>(){

            @Override
            public void handle(Long event) {
                DefaultHttpClientRequest.this.handleException(new TimeoutException("The timeout period of " + timeoutMs + "ms has been exceeded"));
            }
        });
        return this;
    }

    void handleDrained() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        this.exceptionOccurred = true;
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        } else {
            this.cancelOutstandingTimeoutTimer();
            log.error("Unhandled exception", e);
        }
    }

    void handleResponse(DefaultHttpClientResponse resp) {
        if (!this.exceptionOccurred) {
            this.cancelOutstandingTimeoutTimer();
            try {
                if (resp.statusCode == 100) {
                    if (this.continueHandler != null) {
                        this.continueHandler.handle(null);
                    }
                } else {
                    this.respHandler.handle(resp);
                }
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    this.handleException((Exception)t);
                }
                log.error("Unhandled exception", t);
            }
        }
    }

    private void cancelOutstandingTimeoutTimer() {
        if (this.currentTimeoutTimerId != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
        }
    }

    private void connect() {
        if (!this.connecting) {
            this.client.getConnection(new Handler<ClientConnection>(){

                @Override
                public void handle(ClientConnection conn) {
                    if (!conn.isClosed()) {
                        DefaultHttpClientRequest.this.connected(conn);
                    } else {
                        DefaultHttpClientRequest.this.connect();
                    }
                }
            }, this.exceptionHandler, this.context);
            this.connecting = true;
        }
    }

    private void connected(ClientConnection conn) {
        conn.setCurrentRequest(this);
        this.conn = conn;
        if (this.pendingMaxSize != -1) {
            conn.setWriteQueueMaxSize(this.pendingMaxSize);
        }
        if (this.pendingChunks != null || this.writeHead || this.completed) {
            this.writeHead();
            this.headWritten = true;
        }
        if (this.pendingChunks != null) {
            for (PendingChunk chunk : this.pendingChunks) {
                this.sendChunk(chunk.chunk, chunk.doneHandler);
            }
        }
        if (this.completed) {
            if (this.chunked) {
                this.writeEndChunk();
            }
            conn.endRequest();
        }
    }

    private boolean contentLengthSet() {
        if (this.headers != null) {
            return this.headers.containsKey("Content-Length");
        }
        return false;
    }

    private void writeHead() {
        this.request.setChunked(this.chunked);
        if (!this.raw) {
            this.request.setHeader("Host", this.conn.hostHeader);
            if (this.chunked) {
                this.request.setHeader("Transfer-Encoding", "chunked");
            }
        }
        this.writeHeaders();
        this.conn.write(this.request);
    }

    private void writeHeaders() {
        if (this.headers != null) {
            for (Map.Entry<String, Object> header : this.headers.entrySet()) {
                String key = header.getKey();
                this.request.setHeader(key, header.getValue());
            }
        }
    }

    private DefaultHttpClientRequest write(ChannelBuffer buff, Handler<Void> doneHandler) {
        this.written += (long)buff.readableBytes();
        if (!(this.raw || this.chunked || this.contentLengthSet())) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        if (this.conn == null) {
            if (this.pendingChunks == null) {
                this.pendingChunks = new LinkedList();
            }
            this.pendingChunks.add(new PendingChunk(buff, doneHandler));
            this.connect();
        } else {
            if (!this.headWritten) {
                this.writeHead();
                this.headWritten = true;
            }
            this.sendChunk(buff, doneHandler);
        }
        return this;
    }

    private void sendChunk(ChannelBuffer buff, Handler<Void> doneHandler) {
        Object write = this.chunked ? new DefaultHttpChunk(buff) : buff;
        ChannelFuture writeFuture = this.conn.write(write);
        if (doneHandler != null) {
            this.conn.addFuture(doneHandler, writeFuture);
        }
    }

    private void writeEndChunk() {
        this.conn.write(new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER));
    }

    private void check() {
        this.checkComplete();
    }

    private void checkComplete() {
        if (this.completed) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private static class PendingChunk {
        final ChannelBuffer chunk;
        final Handler<Void> doneHandler;

        private PendingChunk(ChannelBuffer chunk, Handler<Void> doneHandler) {
            this.chunk = chunk;
            this.doneHandler = doneHandler;
        }
    }
}

