/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.impl.ClientConnection;
import org.vertx.java.core.http.impl.HeaderUtils;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultHttpClientResponse
extends HttpClientResponse {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpClientResponse.class);
    private final ClientConnection conn;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Exception> exceptionHandler;
    private final HttpResponse response;
    private HttpChunkTrailer trailer;
    private Map<String, String> headers;
    private Map<String, String> trailers;
    private List<String> cookies;

    DefaultHttpClientResponse(ClientConnection conn, HttpResponse response) {
        super(response.getStatus().getCode(), response.getStatus().getReasonPhrase());
        this.conn = conn;
        this.response = response;
    }

    @Override
    public Map<String, String> headers() {
        if (this.headers == null) {
            this.headers = HeaderUtils.simplifyHeaders(this.response.getHeaders());
        }
        return this.headers;
    }

    @Override
    public Map<String, String> trailers() {
        if (this.trailers == null) {
            this.trailers = this.trailer == null ? new HashMap<String, String>() : HeaderUtils.simplifyHeaders(this.trailer.getHeaders());
        }
        return this.trailers;
    }

    @Override
    public List<String> cookies() {
        if (this.cookies == null) {
            this.cookies = new ArrayList<String>();
            this.cookies.addAll(this.response.getHeaders("Set-Cookie"));
            if (this.trailer != null) {
                this.cookies.addAll(this.trailer.getHeaders("Set-Cookie"));
            }
        }
        return this.cookies;
    }

    @Override
    public void dataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
    }

    @Override
    public void endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
    }

    @Override
    public void exceptionHandler(Handler<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void pause() {
        this.conn.pause();
    }

    @Override
    public void resume() {
        this.conn.resume();
    }

    void handleChunk(Buffer data) {
        if (this.dataHandler != null) {
            this.dataHandler.handle(data);
        }
    }

    void handleEnd(HttpChunkTrailer trailer) {
        this.trailer = trailer;
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }
}

