/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.impl.DefaultWebSocket;
import org.vertx.java.core.http.impl.ServerConnection;
import org.vertx.java.core.http.impl.cgbystrom.FlashPolicyHandler;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.Handshake;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.http.impl.ws.hybi00.Handshake00;
import org.vertx.java.core.http.impl.ws.hybi08.Handshake08;
import org.vertx.java.core.http.impl.ws.hybi17.HandshakeRFC6455;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.EventLoopContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.impl.HandlerHolder;
import org.vertx.java.core.net.impl.HandlerManager;
import org.vertx.java.core.net.impl.ServerID;
import org.vertx.java.core.net.impl.TCPSSLHelper;
import org.vertx.java.core.net.impl.VertxWorkerPool;

public class DefaultHttpServer
implements HttpServer {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpServer.class);
    private final VertxInternal vertx;
    private final TCPSSLHelper tcpHelper = new TCPSSLHelper();
    private final EventLoopContext ctx;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<ServerWebSocket> wsHandler;
    private Map<Channel, ServerConnection> connectionMap = new ConcurrentHashMap<Channel, ServerConnection>();
    private ChannelGroup serverChannelGroup;
    private boolean listening;
    private String serverOrigin;
    private ServerID id;
    private DefaultHttpServer actualServer;
    private VertxWorkerPool availableWorkers = new VertxWorkerPool();
    private HandlerManager<HttpServerRequest> reqHandlerManager = new HandlerManager(this.availableWorkers);
    private HandlerManager<ServerWebSocket> wsHandlerManager = new HandlerManager(this.availableWorkers);

    public DefaultHttpServer(VertxInternal vertx) {
        this.vertx = vertx;
        if (vertx.isWorker()) {
            throw new IllegalStateException("Cannot be used in a worker application");
        }
        this.ctx = (EventLoopContext)vertx.getOrAssignContext();
        this.ctx.putCloseHook(this, new Runnable(){

            @Override
            public void run() {
                DefaultHttpServer.this.close();
            }
        });
        this.tcpHelper.setReuseAddress(true);
    }

    @Override
    public HttpServer requestHandler(Handler<HttpServerRequest> requestHandler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.requestHandler = requestHandler;
        return this;
    }

    @Override
    public Handler<HttpServerRequest> requestHandler() {
        return this.requestHandler;
    }

    @Override
    public HttpServer websocketHandler(Handler<ServerWebSocket> wsHandler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.wsHandler = wsHandler;
        return this;
    }

    @Override
    public Handler<ServerWebSocket> websocketHandler() {
        return this.wsHandler;
    }

    @Override
    public HttpServer listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServer listen(int port, String host) {
        if (this.requestHandler == null && this.wsHandler == null) {
            throw new IllegalStateException("Set request or websocket handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        Map<ServerID, DefaultHttpServer> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            this.id = new ServerID(port, host);
            this.serverOrigin = (this.isSSL() ? "https" : "http") + "://" + host + ":" + port;
            DefaultHttpServer shared = this.vertx.sharedHttpServers().get(this.id);
            if (shared == null) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels");
                NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory(this.vertx.getAcceptorPool(), this.availableWorkers);
                ServerBootstrap bootstrap = new ServerBootstrap(factory);
                bootstrap.setOptions(this.tcpHelper.generateConnectionOptions(true));
                this.tcpHelper.checkSSL(this.vertx);
                bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                    @Override
                    public ChannelPipeline getPipeline() {
                        ChannelPipeline pipeline = Channels.pipeline();
                        if (DefaultHttpServer.this.tcpHelper.isSSL()) {
                            SSLEngine engine = DefaultHttpServer.this.tcpHelper.getSSLContext().createSSLEngine();
                            engine.setUseClientMode(false);
                            switch (DefaultHttpServer.this.tcpHelper.getClientAuth()) {
                                case REQUEST: {
                                    engine.setWantClientAuth(true);
                                    break;
                                }
                                case REQUIRED: {
                                    engine.setNeedClientAuth(true);
                                    break;
                                }
                                case NONE: {
                                    engine.setNeedClientAuth(false);
                                }
                            }
                            pipeline.addLast("ssl", new SslHandler(engine));
                        }
                        pipeline.addLast("flashpolicy", new FlashPolicyHandler());
                        pipeline.addLast("decoder", new HttpRequestDecoder());
                        pipeline.addLast("encoder", new HttpResponseEncoder());
                        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
                        pipeline.addLast("handler", new ServerHandler());
                        return pipeline;
                    }
                });
                try {
                    Channel serverChannel = bootstrap.bind(new InetSocketAddress(InetAddress.getByName(host), port));
                    this.serverChannelGroup.add(serverChannel);
                }
                catch (UnknownHostException e) {
                    log.error("Failed to bind", e);
                }
                this.vertx.sharedHttpServers().put(this.id, this);
                this.actualServer = this;
            } else {
                this.actualServer = shared;
            }
            if (this.requestHandler != null) {
                this.actualServer.reqHandlerManager.addHandler(this.requestHandler, this.ctx);
            }
            if (this.wsHandler != null) {
                this.actualServer.wsHandlerManager.addHandler(this.wsHandler, this.ctx);
            }
        }
        this.listening = true;
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<Void> done) {
        if (!this.listening) {
            if (done != null) {
                this.executeCloseDone(this.ctx, done);
            }
            return;
        }
        this.listening = false;
        Map<ServerID, DefaultHttpServer> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            if (this.actualServer != null) {
                if (this.requestHandler != null) {
                    this.actualServer.reqHandlerManager.removeHandler(this.requestHandler, this.ctx);
                }
                if (this.wsHandler != null) {
                    this.actualServer.wsHandlerManager.removeHandler(this.wsHandler, this.ctx);
                }
                if (this.actualServer.reqHandlerManager.hasHandlers() || this.actualServer.wsHandlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(this.ctx, done);
                    }
                } else {
                    this.actualServer.actualClose(this.ctx, done);
                }
            }
        }
        this.requestHandler = null;
        this.wsHandler = null;
    }

    @Override
    public HttpServer setSSL(boolean ssl) {
        this.tcpHelper.setSSL(ssl);
        return this;
    }

    @Override
    public HttpServer setKeyStorePath(String path) {
        this.tcpHelper.setKeyStorePath(path);
        return this;
    }

    @Override
    public HttpServer setKeyStorePassword(String pwd) {
        this.tcpHelper.setKeyStorePassword(pwd);
        return this;
    }

    @Override
    public HttpServer setTrustStorePath(String path) {
        this.tcpHelper.setTrustStorePath(path);
        return this;
    }

    @Override
    public HttpServer setTrustStorePassword(String pwd) {
        this.tcpHelper.setTrustStorePassword(pwd);
        return this;
    }

    @Override
    public HttpServer setClientAuthRequired(boolean required) {
        this.tcpHelper.setClientAuthRequired(required);
        return this;
    }

    @Override
    public HttpServer setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpHelper.setTCPNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public HttpServer setSendBufferSize(int size) {
        this.tcpHelper.setSendBufferSize(size);
        return this;
    }

    @Override
    public HttpServer setReceiveBufferSize(int size) {
        this.tcpHelper.setReceiveBufferSize(size);
        return this;
    }

    @Override
    public HttpServer setTCPKeepAlive(boolean keepAlive) {
        this.tcpHelper.setTCPKeepAlive(keepAlive);
        return this;
    }

    @Override
    public HttpServer setReuseAddress(boolean reuse) {
        this.tcpHelper.setReuseAddress(reuse);
        return this;
    }

    @Override
    public HttpServer setSoLinger(boolean linger) {
        this.tcpHelper.setSoLinger(linger);
        return this;
    }

    @Override
    public HttpServer setTrafficClass(int trafficClass) {
        this.tcpHelper.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public HttpServer setAcceptBacklog(int backlog) {
        this.tcpHelper.setAcceptBacklog(backlog);
        return this;
    }

    @Override
    public Boolean isTCPNoDelay() {
        return this.tcpHelper.isTCPNoDelay();
    }

    @Override
    public Integer getSendBufferSize() {
        return this.tcpHelper.getSendBufferSize();
    }

    @Override
    public Integer getReceiveBufferSize() {
        return this.tcpHelper.getReceiveBufferSize();
    }

    @Override
    public Boolean isTCPKeepAlive() {
        return this.tcpHelper.isTCPKeepAlive();
    }

    @Override
    public Boolean isReuseAddress() {
        return this.tcpHelper.isReuseAddress();
    }

    @Override
    public Boolean isSoLinger() {
        return this.tcpHelper.isSoLinger();
    }

    @Override
    public Integer getTrafficClass() {
        return this.tcpHelper.getTrafficClass();
    }

    @Override
    public Integer getAcceptBacklog() {
        return this.tcpHelper.getAcceptBacklog();
    }

    @Override
    public boolean isSSL() {
        return this.tcpHelper.isSSL();
    }

    @Override
    public String getKeyStorePath() {
        return this.tcpHelper.getKeyStorePath();
    }

    @Override
    public String getKeyStorePassword() {
        return this.tcpHelper.getKeyStorePassword();
    }

    @Override
    public String getTrustStorePath() {
        return this.tcpHelper.getTrustStorePath();
    }

    @Override
    public String getTrustStorePassword() {
        return this.tcpHelper.getTrustStorePassword();
    }

    private void actualClose(Context closeContext, Handler<Void> done) {
        if (this.id != null) {
            this.vertx.sharedHttpServers().remove(this.id);
        }
        for (ServerConnection conn : this.connectionMap.values()) {
            conn.internalClose();
        }
        this.vertx.setContext(closeContext);
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener(new ChannelGroupFutureListener(){

            @Override
            public void operationComplete(ChannelGroupFuture channelGroupFuture) throws Exception {
                latch.countDown();
            }
        });
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.executeCloseDone(closeContext, done);
    }

    private void executeCloseDone(Context closeContext, final Handler<Void> done) {
        if (done != null) {
            closeContext.execute(new Runnable(){

                @Override
                public void run() {
                    done.handle(null);
                }
            });
        }
    }

    public class ServerHandler
    extends SimpleChannelUpstreamHandler {
        private void sendError(String err, HttpResponseStatus status, Channel ch) {
            DefaultHttpResponse resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            resp.setChunked(false);
            if (status.getCode() == HttpResponseStatus.METHOD_NOT_ALLOWED.getCode()) {
                resp.setHeader("allow", "GET");
            }
            if (err != null) {
                ChannelBuffer buff = ChannelBuffers.copiedBuffer(err.getBytes(Charset.forName("UTF-8")));
                resp.setHeader("Content-Length", err.length());
                resp.setContent(buff);
            } else {
                resp.setHeader("Content-Length", "0");
            }
            ch.write(resp);
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            final NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            Object msg = e.getMessage();
            ServerConnection conn = (ServerConnection)DefaultHttpServer.this.connectionMap.get(ch);
            if (msg instanceof HttpRequest) {
                final HttpRequest request = (HttpRequest)msg;
                if (log.isTraceEnabled()) {
                    log.trace("Server received request: " + request.getUri());
                }
                if (HttpHeaders.is100ContinueExpected(request)) {
                    ch.write(new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                }
                if ("WebSocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
                    HandlerHolder wsHandler;
                    Handshake shake;
                    String connectionHeader = request.getHeader("Connection");
                    if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
                        this.sendError("\"Connection\" must be \"Upgrade\".", HttpResponseStatus.BAD_REQUEST, ch);
                        return;
                    }
                    if (request.getMethod() != HttpMethod.GET) {
                        this.sendError(null, HttpResponseStatus.METHOD_NOT_ALLOWED, ch);
                        return;
                    }
                    if (HandshakeRFC6455.matches(request)) {
                        shake = new HandshakeRFC6455();
                    } else if (Handshake08.matches(request)) {
                        shake = new Handshake08();
                    } else if (Handshake00.matches(request)) {
                        shake = new Handshake00();
                    } else {
                        log.error("Unrecognised websockets handshake");
                        ch.write(new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND));
                        return;
                    }
                    HandlerHolder firstHandler = null;
                    while ((wsHandler = DefaultHttpServer.this.wsHandlerManager.chooseHandler(ch.getWorker())) != null && firstHandler != wsHandler) {
                        URI theURI;
                        try {
                            theURI = new URI(request.getUri());
                        }
                        catch (URISyntaxException e2) {
                            throw new IllegalArgumentException("Invalid uri " + request.getUri());
                        }
                        final ServerConnection wsConn = new ServerConnection(DefaultHttpServer.this.vertx, ch, wsHandler.context);
                        wsConn.wsHandler(wsHandler.handler);
                        Runnable connectRunnable = new Runnable(){

                            @Override
                            public void run() {
                                DefaultHttpServer.this.connectionMap.put(ch, wsConn);
                                try {
                                    HttpResponse resp = shake.generateResponse(request, DefaultHttpServer.this.serverOrigin);
                                    ChannelPipeline p = ch.getPipeline();
                                    p.replace("decoder", "wsdecoder", shake.getDecoder());
                                    ch.write(resp);
                                    p.replace("encoder", "wsencoder", shake.getEncoder(true));
                                }
                                catch (Exception e) {
                                    log.error("Failed to generate shake response", e);
                                }
                            }
                        };
                        DefaultWebSocket ws = new DefaultWebSocket(DefaultHttpServer.this.vertx, theURI.getPath(), wsConn, connectRunnable);
                        wsConn.handleWebsocketConnect(ws);
                        if (ws.rejected) {
                            if (firstHandler != null) continue;
                            firstHandler = wsHandler;
                            continue;
                        }
                        ws.connectNow();
                        return;
                    }
                    ch.write(new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND));
                } else if (conn == null) {
                    HandlerHolder reqHandler = DefaultHttpServer.this.reqHandlerManager.chooseHandler(ch.getWorker());
                    if (reqHandler != null) {
                        conn = new ServerConnection(DefaultHttpServer.this.vertx, ch, reqHandler.context);
                        conn.requestHandler(reqHandler.handler);
                        DefaultHttpServer.this.connectionMap.put(ch, conn);
                        conn.handleMessage(msg);
                    }
                } else {
                    conn.handleMessage(msg);
                }
            } else if (msg instanceof WebSocketFrame) {
                WebSocketFrame wsFrame = (WebSocketFrame)msg;
                switch (wsFrame.getType()) {
                    case BINARY: 
                    case TEXT: {
                        if (conn == null) break;
                        conn.handleMessage(msg);
                        break;
                    }
                    case CLOSE: {
                        ch.write(new DefaultWebSocketFrame(WebSocketFrame.FrameType.CLOSE));
                    }
                }
            } else if (msg instanceof HttpChunk) {
                if (conn != null) {
                    conn.handleMessage(msg);
                }
            } else {
                throw new IllegalStateException("Invalid message " + msg);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ServerConnection conn = (ServerConnection)DefaultHttpServer.this.connectionMap.get(ch);
            final Throwable t = e.getCause();
            ch.close();
            if (conn != null && t instanceof Exception) {
                conn.getContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        conn.handleException((Exception)t);
                    }
                });
            }
        }

        @Override
        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        }

        @Override
        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ServerConnection conn = (ServerConnection)DefaultHttpServer.this.connectionMap.remove(ch);
            if (conn != null) {
                conn.getContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        conn.handleClosed();
                    }
                });
            }
        }

        @Override
        public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ServerConnection conn = (ServerConnection)DefaultHttpServer.this.connectionMap.get(ch);
            ChannelState state = e.getState();
            if (state == ChannelState.INTEREST_OPS) {
                conn.getContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        conn.handleInterestedOpsChanged();
                    }
                });
            }
        }
    }
}

