/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.impl.HeaderUtils;
import org.vertx.java.core.http.impl.ServerConnection;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultHttpServerRequest
extends HttpServerRequest {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpServerRequest.class);
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Exception> exceptionHandler;
    private final ServerConnection conn;
    private final HttpRequest request;
    private Map<String, String> params;
    private Map<String, String> headers;

    DefaultHttpServerRequest(ServerConnection conn, String method, String uri, String path, String query, HttpServerResponse response, HttpRequest request) {
        super(method, uri, path, query, response);
        this.conn = conn;
        this.request = request;
    }

    @Override
    public Map<String, String> headers() {
        if (this.headers == null) {
            this.headers = HeaderUtils.simplifyHeaders(this.request.getHeaders());
        }
        return this.headers;
    }

    @Override
    public Map<String, String> params() {
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri);
            Map<String, List<String>> prms = queryStringDecoder.getParameters();
            if (prms.isEmpty()) {
                this.params = new HashMap<String, String>();
            } else {
                this.params = new HashMap<String, String>(prms.size());
                for (Map.Entry<String, List<String>> entry : prms.entrySet()) {
                    this.params.put(entry.getKey(), entry.getValue().get(0));
                }
            }
        }
        return this.params;
    }

    @Override
    public void dataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.exceptionHandler = handler;
    }

    @Override
    public void pause() {
        this.conn.pause();
    }

    @Override
    public void resume() {
        this.conn.resume();
    }

    @Override
    public void endHandler(Handler<Void> handler) {
        this.endHandler = handler;
    }

    void handleData(Buffer data) {
        if (this.dataHandler != null) {
            this.dataHandler.handle(data);
        }
    }

    void handleEnd() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }
}

