/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.io.File;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.impl.MimeMapping;
import org.vertx.java.core.http.impl.ServerConnection;
import org.vertx.java.core.impl.LowerCaseKeyMap;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultHttpServerResponse
extends HttpServerResponse {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpServerResponse.class);
    private final ServerConnection conn;
    private final HttpResponse response;
    private final HttpVersion version;
    private final boolean keepAlive;
    private boolean headWritten;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Exception> exceptionHandler;
    private Handler<Void> closeHandler;
    private boolean chunked;
    private boolean closed;
    private ChannelFuture channelFuture;
    private Map<String, Object> headers;
    private Map<String, Object> trailers;
    private final VertxInternal vertx;

    DefaultHttpServerResponse(VertxInternal vertx, ServerConnection conn, HttpVersion version, boolean keepAlive) {
        this.vertx = vertx;
        this.conn = conn;
        this.response = new DefaultHttpResponse(version, HttpResponseStatus.OK);
        this.version = version;
        this.keepAlive = keepAlive;
    }

    @Override
    public Map<String, Object> headers() {
        if (this.headers == null) {
            this.headers = new LowerCaseKeyMap<Object>();
        }
        return this.headers;
    }

    @Override
    public Map<String, Object> trailers() {
        if (this.trailers == null) {
            this.trailers = new LowerCaseKeyMap<Object>();
        }
        return this.trailers;
    }

    @Override
    public DefaultHttpServerResponse setChunked(boolean chunked) {
        this.checkWritten();
        if (this.version != HttpVersion.HTTP_1_0) {
            this.chunked = chunked;
        }
        return this;
    }

    @Override
    public DefaultHttpServerResponse putHeader(String key, Object value) {
        this.checkWritten();
        this.headers().put(key, value);
        return this;
    }

    @Override
    public DefaultHttpServerResponse putTrailer(String key, Object value) {
        this.checkWritten();
        this.trailers().put(key, value);
        return this;
    }

    @Override
    public void setWriteQueueMaxSize(int size) {
        this.checkWritten();
        this.conn.setWriteQueueMaxSize(size);
    }

    @Override
    public boolean writeQueueFull() {
        this.checkWritten();
        return this.conn.writeQueueFull();
    }

    @Override
    public void drainHandler(Handler<Void> handler) {
        this.checkWritten();
        this.drainHandler = handler;
        this.conn.handleInterestedOpsChanged();
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.checkWritten();
        this.exceptionHandler = handler;
    }

    @Override
    public void closeHandler(Handler<Void> handler) {
        this.checkWritten();
        this.closeHandler = handler;
    }

    @Override
    public void writeBuffer(Buffer chunk) {
        this.write(chunk.getChannelBuffer(), null);
    }

    @Override
    public DefaultHttpServerResponse write(Buffer chunk) {
        return this.write(chunk.getChannelBuffer(), null);
    }

    @Override
    public DefaultHttpServerResponse write(String chunk, String enc) {
        return this.write(new Buffer(chunk, enc).getChannelBuffer(), null);
    }

    @Override
    public DefaultHttpServerResponse write(String chunk) {
        return this.write(new Buffer(chunk).getChannelBuffer(), null);
    }

    @Override
    public DefaultHttpServerResponse write(Buffer chunk, Handler<Void> doneHandler) {
        return this.write(chunk.getChannelBuffer(), doneHandler);
    }

    @Override
    public DefaultHttpServerResponse write(String chunk, String enc, Handler<Void> doneHandler) {
        return this.write(new Buffer(chunk, enc).getChannelBuffer(), doneHandler);
    }

    @Override
    public DefaultHttpServerResponse write(String chunk, Handler<Void> doneHandler) {
        return this.write(new Buffer(chunk).getChannelBuffer(), doneHandler);
    }

    @Override
    public void end(String chunk) {
        this.end(new Buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(new Buffer(chunk, enc));
    }

    @Override
    public void end(Buffer chunk) {
        if (!this.chunked && !this.contentLengthSet()) {
            this.headers().put("Content-Length", String.valueOf(chunk.length()));
        }
        this.write(chunk);
        this.end();
    }

    private void closeConnAfterWrite() {
        if (this.channelFuture != null) {
            this.channelFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    DefaultHttpServerResponse.this.conn.close();
                }
            });
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.headWritten) {
                this.closeConnAfterWrite();
            } else {
                this.conn.close();
            }
            this.closed = true;
        }
    }

    @Override
    public void end() {
        this.checkWritten();
        this.writeHead();
        if (this.chunked) {
            if (this.trailers == null) {
                DefaultHttpChunk nettyChunk = new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER);
                this.channelFuture = this.conn.write(nettyChunk);
            } else {
                DefaultHttpChunkTrailer trlrs = new DefaultHttpChunkTrailer();
                for (Map.Entry<String, Object> trailer : this.trailers.entrySet()) {
                    Object value = trailer.getValue();
                    if (value instanceof Iterable) {
                        trlrs.setHeader(trailer.getKey(), (Iterable)value);
                        continue;
                    }
                    trlrs.setHeader(trailer.getKey(), value);
                }
                this.channelFuture = this.conn.write(trlrs);
            }
        }
        if (!this.keepAlive) {
            this.closeConnAfterWrite();
        }
        this.written = true;
        this.conn.responseComplete();
    }

    private boolean contentLengthSet() {
        if (this.headers != null) {
            return this.headers.containsKey("Content-Length");
        }
        return false;
    }

    private boolean contentTypeSet() {
        if (this.headers != null) {
            return this.headers.containsKey("Content-Type");
        }
        return false;
    }

    @Override
    public DefaultHttpServerResponse sendFile(String filename) {
        if (this.headWritten) {
            throw new IllegalStateException("Head already written");
        }
        this.checkWritten();
        File file = new File(PathAdjuster.adjust(this.vertx, filename));
        if (!file.exists()) {
            this.sendNotFound();
        } else {
            String ext;
            String contentType;
            int li;
            this.writeHeaders();
            if (!this.contentLengthSet()) {
                this.response.setHeader("Content-Length", String.valueOf(file.length()));
            }
            if (!this.contentTypeSet() && (li = filename.lastIndexOf(46)) != -1 && li != filename.length() - 1 && (contentType = MimeMapping.getMimeTypeForExtension(ext = filename.substring(li + 1, filename.length()))) != null) {
                this.response.setHeader("Content-Type", contentType);
            }
            this.conn.write(this.response);
            this.channelFuture = this.conn.sendFile(file);
            this.written = true;
            this.headWritten = true;
            if (!this.keepAlive) {
                this.closeConnAfterWrite();
            }
            this.conn.responseComplete();
        }
        return this;
    }

    private void sendNotFound() {
        this.statusCode = HttpResponseStatus.NOT_FOUND.getCode();
        this.end("<html><body>Resource not found</body><html>");
    }

    void handleDrained() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }

    void handleClosed() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }

    private void checkWritten() {
        if (this.written) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    private void writeHead() {
        if (!this.headWritten) {
            HttpResponseStatus status = this.statusMessage == null ? HttpResponseStatus.valueOf(this.statusCode) : new HttpResponseStatus(this.statusCode, this.statusMessage);
            this.response.setStatus(status);
            if (this.version == HttpVersion.HTTP_1_0 && this.keepAlive) {
                this.response.setHeader("Connection", "Keep-Alive");
            }
            this.writeHeaders();
            if (this.chunked) {
                this.response.setHeader("Transfer-Encoding", "chunked");
            } else if (this.version != HttpVersion.HTTP_1_0 && !this.contentLengthSet()) {
                this.response.setHeader("Content-Length", "0");
            }
            this.channelFuture = this.conn.write(this.response);
            this.headWritten = true;
        }
    }

    private void writeHeaders() {
        if (this.headers != null) {
            for (Map.Entry<String, Object> header : this.headers.entrySet()) {
                String key = header.getKey();
                Object value = header.getValue();
                if (value instanceof Iterable) {
                    this.response.setHeader(key, (Iterable)value);
                    continue;
                }
                this.response.setHeader(key, value);
            }
        }
    }

    private DefaultHttpServerResponse write(ChannelBuffer chunk, Handler<Void> doneHandler) {
        this.checkWritten();
        this.writeHead();
        if (this.version != HttpVersion.HTTP_1_0 && !this.chunked && !this.contentLengthSet()) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        Object msg = this.chunked ? new DefaultHttpChunk(chunk) : chunk;
        this.channelFuture = this.conn.write(msg);
        if (doneHandler != null) {
            this.conn.addFuture(doneHandler, this.channelFuture);
        }
        return this;
    }
}

