/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.util.UUID;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.impl.AbstractConnection;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.VertxInternal;

public class DefaultWebSocket
extends ServerWebSocket {
    private final VertxInternal vertx;
    private final AbstractConnection conn;
    private Handler<Buffer> dataHandler;
    private Handler<Void> drainHandler;
    private Handler<Exception> exceptionHandler;
    private Handler<Void> closedHandler;
    private Handler<Void> endHandler;
    private Handler<Message<Buffer>> binaryHandler;
    private Handler<Message<String>> textHandler;
    private final Runnable connectRunnable;
    protected boolean closed;
    boolean rejected;
    private boolean connected;

    protected DefaultWebSocket(VertxInternal vertx, String path, AbstractConnection conn, Runnable connectRunnable) {
        super(path, UUID.randomUUID().toString(), UUID.randomUUID().toString());
        this.vertx = vertx;
        this.conn = conn;
        this.binaryHandler = new Handler<Message<Buffer>>(){

            @Override
            public void handle(Message<Buffer> msg) {
                DefaultWebSocket.this.writeBinaryFrame((Buffer)msg.body);
            }
        };
        vertx.eventBus().registerLocalHandler(this.binaryHandlerID, this.binaryHandler);
        this.textHandler = new Handler<Message<String>>(){

            @Override
            public void handle(Message<String> msg) {
                DefaultWebSocket.this.writeTextFrame((String)msg.body);
            }
        };
        vertx.eventBus().registerLocalHandler(this.textHandlerID, this.textHandler);
        this.connectRunnable = connectRunnable;
    }

    @Override
    public void reject() {
        this.checkClosed();
        if (this.connectRunnable == null) {
            throw new IllegalStateException("Cannot reject websocket on the client side");
        }
        if (this.connected) {
            throw new IllegalStateException("Cannot reject websocket, it has already been written to");
        }
        this.rejected = true;
    }

    @Override
    public void writeBinaryFrame(Buffer data) {
        DefaultWebSocketFrame frame = new DefaultWebSocketFrame(WebSocketFrame.FrameType.BINARY, data.getChannelBuffer());
        this.writeFrame(frame);
    }

    @Override
    public void writeTextFrame(String str) {
        DefaultWebSocketFrame frame = new DefaultWebSocketFrame(str);
        this.writeFrame(frame);
    }

    @Override
    public void dataHandler(Handler<Buffer> handler) {
        this.checkClosed();
        this.dataHandler = handler;
    }

    @Override
    public void endHandler(Handler<Void> handler) {
        this.checkClosed();
        this.endHandler = handler;
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.checkClosed();
        this.exceptionHandler = handler;
    }

    @Override
    public void closedHandler(Handler<Void> handler) {
        this.checkClosed();
        this.closedHandler = handler;
    }

    @Override
    public void pause() {
        this.checkClosed();
        this.conn.pause();
    }

    @Override
    public void resume() {
        this.checkClosed();
        this.conn.resume();
    }

    @Override
    public void setWriteQueueMaxSize(int maxSize) {
        this.checkClosed();
        this.conn.setWriteQueueMaxSize(maxSize);
    }

    @Override
    public boolean writeQueueFull() {
        this.checkClosed();
        return this.conn.writeQueueFull();
    }

    @Override
    public void writeBuffer(Buffer data) {
        this.writeBinaryFrame(data);
    }

    @Override
    public void drainHandler(Handler<Void> handler) {
        this.checkClosed();
        this.drainHandler = handler;
    }

    @Override
    public void close() {
        this.checkClosed();
        if (this.connectRunnable != null) {
            if (this.rejected) {
                throw new IllegalStateException("Cannot close websocket, it has been rejected");
            }
            if (!this.connected && !this.closed) {
                this.connect();
            }
        }
        this.conn.close();
        this.cleanupHandlers();
    }

    private void cleanupHandlers() {
        if (!this.closed) {
            this.vertx.eventBus().unregisterHandler(this.binaryHandlerID, this.binaryHandler);
            this.vertx.eventBus().unregisterHandler(this.textHandlerID, this.textHandler);
            this.closed = true;
        }
    }

    protected void writeFrame(WebSocketFrame frame) {
        if (this.connectRunnable != null) {
            if (this.rejected) {
                throw new IllegalStateException("Cannot write to websocket, it has been rejected");
            }
            if (!this.connected && !this.closed) {
                this.connect();
            }
        }
        this.checkClosed();
        this.conn.write(frame);
    }

    private void connect() {
        this.connectRunnable.run();
        this.connected = true;
    }

    void connectNow() {
        if (!this.connected && !this.rejected) {
            this.connect();
        }
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("WebSocket is closed");
        }
    }

    void handleFrame(WebSocketFrame frame) {
        if (this.dataHandler != null) {
            Buffer buff = new Buffer(frame.getBinaryData());
            this.dataHandler.handle(buff);
        }
    }

    void writable() {
        if (this.drainHandler != null) {
            Handler<Void> dh = this.drainHandler;
            this.drainHandler = null;
            dh.handle(null);
        }
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }

    void handleClosed() {
        this.cleanupHandlers();
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        if (this.closedHandler != null) {
            this.closedHandler.handle(null);
        }
    }
}

