/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.Queue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.vertx.java.core.Handler;
import org.vertx.java.core.SimpleHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.impl.AbstractConnection;
import org.vertx.java.core.http.impl.DefaultHttpServerRequest;
import org.vertx.java.core.http.impl.DefaultHttpServerResponse;
import org.vertx.java.core.http.impl.DefaultWebSocket;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class ServerConnection
extends AbstractConnection {
    private static final Logger log = LoggerFactory.getLogger(ServerConnection.class);
    private static final int CHANNEL_PAUSE_QUEUE_SIZE = 5;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<ServerWebSocket> wsHandler;
    private DefaultHttpServerRequest currentRequest;
    private DefaultHttpServerResponse pendingResponse;
    private DefaultWebSocket ws;
    private boolean channelPaused;
    private boolean paused;
    private boolean sentCheck;
    private final Queue<Object> pending = new LinkedList<Object>();

    ServerConnection(VertxInternal vertx, Channel channel, Context context) {
        super(vertx, channel, context);
    }

    @Override
    public void pause() {
        if (!this.paused) {
            this.paused = true;
        }
    }

    @Override
    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.checkNextTick();
        }
    }

    void handleMessage(Object msg) {
        if (this.paused || msg instanceof HttpRequest && this.pendingResponse != null || !this.pending.isEmpty()) {
            this.pending.add(msg);
            if (this.pending.size() == 5) {
                super.pause();
                this.channelPaused = true;
            }
        } else {
            this.processMessage(msg);
        }
    }

    void responseComplete() {
        this.pendingResponse = null;
        this.checkNextTick();
    }

    void requestHandler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
    }

    void wsHandler(Handler<ServerWebSocket> handler) {
        this.wsHandler = handler;
    }

    void internalClose() {
        this.channel.close();
    }

    private void handleRequest(DefaultHttpServerRequest req, DefaultHttpServerResponse resp) {
        this.setContext();
        try {
            this.currentRequest = req;
            this.pendingResponse = resp;
            if (this.requestHandler != null) {
                this.requestHandler.handle(req);
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleChunk(Buffer chunk) {
        try {
            this.setContext();
            this.currentRequest.handleData(chunk);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleEnd() {
        try {
            this.setContext();
            this.currentRequest.handleEnd();
            this.currentRequest = null;
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleInterestedOpsChanged() {
        try {
            if (this.channel.isWritable()) {
                this.setContext();
                if (this.pendingResponse != null) {
                    this.pendingResponse.handleDrained();
                } else if (this.ws != null) {
                    this.ws.writable();
                }
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleWebsocketConnect(DefaultWebSocket ws) {
        try {
            if (this.wsHandler != null) {
                this.setContext();
                this.wsHandler.handle(ws);
                this.ws = ws;
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleWsFrame(WebSocketFrame frame) {
        try {
            if (this.ws != null) {
                this.setContext();
                this.ws.handleFrame(frame);
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
        if (this.pendingResponse != null) {
            this.pendingResponse.handleClosed();
        }
    }

    @Override
    protected Context getContext() {
        return super.getContext();
    }

    @Override
    protected void handleException(Exception e) {
        super.handleException(e);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        }
        if (this.pendingResponse != null) {
            this.pendingResponse.handleException(e);
        }
        if (this.ws != null) {
            this.ws.handleException(e);
        }
    }

    @Override
    protected void addFuture(Handler<Void> doneHandler, ChannelFuture future) {
        super.addFuture(doneHandler, future);
    }

    @Override
    protected boolean isSSL() {
        return super.isSSL();
    }

    @Override
    protected ChannelFuture sendFile(File file) {
        return super.sendFile(file);
    }

    private void processMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            URI theURI;
            HttpRequest request = (HttpRequest)msg;
            String method = request.getMethod().toString();
            try {
                theURI = new URI(request.getUri());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid uri " + request.getUri());
            }
            String uri = request.getUri();
            String path = theURI.getPath();
            String query = theURI.getQuery();
            HttpVersion ver = request.getProtocolVersion();
            boolean keepAlive = ver == HttpVersion.HTTP_1_1 || ver == HttpVersion.HTTP_1_0 && "Keep-Alive".equalsIgnoreCase(request.getHeader("Connection"));
            DefaultHttpServerResponse resp = new DefaultHttpServerResponse(this.vertx, this, request.getProtocolVersion(), keepAlive);
            DefaultHttpServerRequest req = new DefaultHttpServerRequest(this, method, uri, path, query, resp, request);
            this.handleRequest(req, resp);
            ChannelBuffer requestBody = request.getContent();
            if (requestBody.readable()) {
                if (!this.paused) {
                    this.handleChunk(new Buffer(requestBody));
                } else {
                    this.pending.add(new DefaultHttpChunk(requestBody));
                }
            }
            if (!request.isChunked()) {
                if (!this.paused) {
                    this.handleEnd();
                } else {
                    this.pending.add(new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER));
                }
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            if (chunk.getContent().readable()) {
                Buffer buff = new Buffer(chunk.getContent());
                this.handleChunk(buff);
            }
            if (chunk.isLast()) {
                if (!this.paused) {
                    this.handleEnd();
                } else {
                    this.pending.add(new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER));
                }
            }
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            this.handleWsFrame(frame);
        }
        this.checkNextTick();
    }

    private void checkNextTick() {
        if (!(this.sentCheck || this.pending.isEmpty() || this.paused || this.pendingResponse != null && !(this.pending.peek() instanceof HttpChunk))) {
            this.sentCheck = true;
            this.vertx.runOnLoop(new SimpleHandler(){

                @Override
                public void handle() {
                    ServerConnection.this.sentCheck = false;
                    if (!ServerConnection.this.paused) {
                        Object msg = ServerConnection.this.pending.poll();
                        if (msg != null) {
                            ServerConnection.this.processMessage(msg);
                        }
                        if (ServerConnection.this.channelPaused && ServerConnection.this.pending.isEmpty()) {
                            ServerConnection.super.resume();
                            ServerConnection.this.channelPaused = false;
                        }
                    }
                }
            });
        }
    }
}

