/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpMessageDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class SwitchingHttpResponseDecoder
extends HttpResponseDecoder {
    private static final Logger log = LoggerFactory.getLogger(SwitchingHttpResponseDecoder.class);
    private volatile String name;
    private volatile ChannelHandler switchTo;

    public void setSwitch(String name, ChannelHandler switchTo) {
        this.name = name;
        this.switchTo = switchTo;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel ch, ChannelBuffer buf, HttpMessageDecoder.State state) throws Exception {
        Object firstMessage = super.decode(ctx, ch, buf, state);
        if (firstMessage == null) {
            return null;
        }
        if (this.switchTo != null) {
            ctx.getPipeline().addBefore("handler", this.name, this.switchTo);
            ctx.getPipeline().remove(this);
            this.switchTo = null;
            if (buf.readable()) {
                if (firstMessage != null) {
                    return new Object[]{firstMessage, buf.readBytes(super.actualReadableBytes())};
                }
                return new Object[]{buf.readBytes(super.actualReadableBytes())};
            }
            return firstMessage;
        }
        return firstMessage;
    }
}

