/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.cgbystrom;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.util.CharsetUtil;

public class FlashPolicyHandler
extends FrameDecoder {
    private static final String XML = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>";
    private ChannelBuffer policyResponse = ChannelBuffers.copiedBuffer((CharSequence)"<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>", CharsetUtil.UTF_8);

    public FlashPolicyHandler() {
    }

    public FlashPolicyHandler(ChannelBuffer policyResponse) {
        this.policyResponse = policyResponse;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        boolean isFlashPolicyRequest;
        if (buffer.readableBytes() < 2) {
            return null;
        }
        short magic1 = buffer.getUnsignedByte(buffer.readerIndex());
        short magic2 = buffer.getUnsignedByte(buffer.readerIndex() + 1);
        boolean bl = isFlashPolicyRequest = magic1 == 60 && magic2 == 112;
        if (isFlashPolicyRequest) {
            buffer.skipBytes(buffer.readableBytes());
            this.removeAllPipelineHandlers(channel.getPipeline());
            channel.write(this.policyResponse).addListener(ChannelFutureListener.CLOSE);
            return null;
        }
        ctx.getPipeline().remove(this);
        return buffer.readBytes(buffer.readableBytes());
    }

    private void removeAllPipelineHandlers(ChannelPipeline pipeline) {
        while (pipeline.getFirst() != null) {
            pipeline.removeFirst();
        }
    }
}

