/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;

public class DefaultWebSocketFrame
implements WebSocketFrame {
    private WebSocketFrame.FrameType type;
    private ChannelBuffer binaryData;

    public DefaultWebSocketFrame() {
        this(null, ChannelBuffers.EMPTY_BUFFER);
    }

    public DefaultWebSocketFrame(WebSocketFrame.FrameType frameType) {
        this(frameType, ChannelBuffers.EMPTY_BUFFER);
    }

    public DefaultWebSocketFrame(String textData) {
        this(WebSocketFrame.FrameType.TEXT, ChannelBuffers.copiedBuffer((CharSequence)textData, CharsetUtil.UTF_8));
    }

    public DefaultWebSocketFrame(WebSocketFrame.FrameType type, ChannelBuffer binaryData) {
        this.type = type;
        this.binaryData = binaryData;
    }

    @Override
    public WebSocketFrame.FrameType getType() {
        return this.type;
    }

    @Override
    public boolean isText() {
        return this.type == WebSocketFrame.FrameType.TEXT;
    }

    @Override
    public boolean isBinary() {
        return this.type == WebSocketFrame.FrameType.BINARY;
    }

    @Override
    public ChannelBuffer getBinaryData() {
        return this.binaryData;
    }

    @Override
    public String getTextData() {
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    @Override
    public void setBinaryData(ChannelBuffer binaryData) {
        this.binaryData = binaryData;
    }

    @Override
    public void setTextData(String textData) {
        this.binaryData = ChannelBuffers.copiedBuffer((CharSequence)textData, CharsetUtil.UTF_8);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(type: " + (Object)((Object)this.getType()) + ", " + "data: " + this.getBinaryData() + ')';
    }
}

