/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws.hybi00;

import java.security.NoSuchAlgorithmException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.SimpleHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.impl.ws.Handshake;
import org.vertx.java.core.http.impl.ws.hybi00.WebSocketChallenge00;
import org.vertx.java.core.http.impl.ws.hybi00.WebSocketFrameDecoder00;
import org.vertx.java.core.http.impl.ws.hybi00.WebSocketFrameEncoder00;
import org.vertx.java.core.http.impl.ws.hybi08.Handshake08;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class Handshake00
implements Handshake {
    private static Logger log = LoggerFactory.getLogger(Handshake08.class);
    private final WebSocketChallenge00 challenge = new WebSocketChallenge00();

    protected String getWebSocketLocation(HttpRequest request, String serverOrigin) {
        String scheme = serverOrigin.substring(0, 5).toLowerCase().equals("https") ? "wss://" : "ws://";
        return scheme + request.getHeader("Host") + request.getUri();
    }

    public static boolean matches(HttpRequest request) {
        return request.containsHeader("Sec-WebSocket-Key1") && request.containsHeader("Sec-WebSocket-Key2");
    }

    @Override
    public void fillInRequest(HttpClientRequest req, String hostHeader) throws Exception {
        req.headers().put("Connection", "Upgrade");
        req.headers().put("Upgrade", "WebSocket");
        req.headers().put("Host", hostHeader);
        req.headers().put("Sec-WebSocket-Key1", this.challenge.getKey1String());
        req.headers().put("Sec-WebSocket-Key2", this.challenge.getKey2String());
        Buffer buff = new Buffer(6);
        buff.appendBytes(this.challenge.getKey3());
        buff.appendByte((byte)13);
        buff.appendByte((byte)10);
        req.write(buff);
    }

    @Override
    public HttpResponse generateResponse(HttpRequest request, String serverOrigin) throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, "WebSocket Protocol Handshake"));
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Upgrade", "WebSocket");
        String origin = request.getHeader("Origin");
        if (origin == null) {
            origin = serverOrigin;
        }
        response.addHeader("Sec-WebSocket-Origin", origin);
        response.addHeader("Sec-WebSocket-Location", this.getWebSocketLocation(request, serverOrigin));
        String protocol = request.getHeader("Sec-WebSocket-Protocol");
        if (protocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", protocol);
        }
        String key1 = request.getHeader("Sec-WebSocket-Key1");
        String key2 = request.getHeader("Sec-WebSocket-Key2");
        byte[] key3 = new byte[8];
        request.getContent().readBytes(key3);
        byte[] solution = WebSocketChallenge00.solve(key1, key2, key3);
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer(solution.length + 2);
        buffer.writeBytes(solution);
        response.addHeader("Content-Length", buffer.readableBytes());
        response.setContent(buffer);
        response.setChunked(false);
        return response;
    }

    @Override
    public void onComplete(HttpClientResponse response, final AsyncResultHandler<Void> doneHandler) {
        final Buffer buff = new Buffer(16);
        response.dataHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer data) {
                buff.appendBuffer(data);
            }
        });
        response.endHandler(new SimpleHandler(){

            @Override
            public void handle() {
                AsyncResult<Object> res;
                byte[] bytes = buff.getBytes();
                try {
                    res = Handshake00.this.challenge.verify(bytes) ? new AsyncResult<Void>((Void)null) : new AsyncResult(new Exception("Invalid websocket handshake response"));
                }
                catch (Exception e) {
                    res = new AsyncResult(e);
                }
                doneHandler.handle(res);
            }
        });
    }

    @Override
    public ChannelHandler getEncoder(boolean server) {
        return new WebSocketFrameEncoder00();
    }

    @Override
    public ChannelHandler getDecoder() {
        return new WebSocketFrameDecoder00();
    }
}

