/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws.hybi00;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.http.impl.ws.hybi00.WebSocketFrameDecoder00;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class WebSocketFrameEncoder00
extends OneToOneEncoder {
    private static final Logger log = LoggerFactory.getLogger(WebSocketFrameDecoder00.class);

    @Override
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            WebSocketFrame.FrameType frameType = frame.getType();
            switch (frameType) {
                case CLOSE: {
                    ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(2);
                    encoded.writeByte(255);
                    encoded.writeByte(0);
                    return encoded;
                }
                case TEXT: {
                    ChannelBuffer data = frame.getBinaryData();
                    ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), data.readableBytes() + 2);
                    encoded.writeByte(0);
                    encoded.writeBytes(data, data.readableBytes());
                    encoded.writeByte(-1);
                    return encoded;
                }
                case BINARY: {
                    ChannelBuffer data = frame.getBinaryData();
                    int dataLen = data.readableBytes();
                    ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), dataLen + 5);
                    encoded.writeByte(-128);
                    encoded.writeByte((byte)(dataLen >>> 28 & 0x7F | 0x80));
                    encoded.writeByte((byte)(dataLen >>> 14 & 0x7F | 0x80));
                    encoded.writeByte((byte)(dataLen >>> 7 & 0x7F | 0x80));
                    encoded.writeByte((byte)(dataLen & 0x7F));
                    encoded.writeBytes(data, dataLen);
                    return encoded;
                }
            }
        }
        return msg;
    }
}

