/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws.hybi08;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.vertx.java.core.http.impl.ws.Base64;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class WebSocketChallenge08 {
    private static Logger log = LoggerFactory.getLogger(WebSocketChallenge08.class);
    public static final String GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final String SHA1 = "SHA1";
    private byte[] rawNonce;

    public WebSocketChallenge08() throws NoSuchAlgorithmException {
        this.generateNonce();
    }

    protected void generateNonce() {
        this.rawNonce = new byte[16];
        SecureRandom random = new SecureRandom();
        ((Random)random).nextBytes(this.rawNonce);
    }

    public String getNonceBase64() {
        return Base64.encodeBytes(this.rawNonce).trim();
    }

    public static String solve(String nonceBase64) throws NoSuchAlgorithmException {
        String concat = nonceBase64 + GUID;
        MessageDigest digest = MessageDigest.getInstance(SHA1);
        digest.update(concat.getBytes());
        byte[] hashed = digest.digest();
        return Base64.encodeBytes(hashed).trim();
    }

    public boolean verify(String solution) throws NoSuchAlgorithmException {
        if (solution == null) {
            return false;
        }
        String localSolution = WebSocketChallenge08.solve(this.getNonceBase64());
        return localSolution.equals(solution);
    }
}

