/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws.hybi08;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class WebSocketFrameDecoder08
extends ReplayingDecoder<VoidEnum> {
    public static final int DEFAULT_MAX_FRAME_SIZE = 131072;
    private final int maxFrameSize;
    private static final Logger log = LoggerFactory.getLogger(WebSocketFrameDecoder08.class);

    WebSocketFrameDecoder08() {
        this(131072);
    }

    WebSocketFrameDecoder08(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        short finOpcode = buffer.readUnsignedByte();
        boolean fin = (finOpcode & 0x80) != 0;
        int opcode = finOpcode & 0xF;
        byte lengthMask = buffer.readByte();
        boolean masked = (lengthMask & 0x80) != 0;
        long length = lengthMask & 0x7F;
        if (length == 126L) {
            length = buffer.readUnsignedShort();
        } else if (length == 127L) {
            length = buffer.readLong();
        }
        if (length > (long)this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        byte[] mask = null;
        if (masked) {
            mask = new byte[4];
            buffer.readBytes(mask);
        }
        byte[] body = new byte[(int)length];
        buffer.readBytes(body);
        if (masked) {
            for (int i = 0; i < body.length; ++i) {
                body[i] = (byte)(body[i] ^ mask[i % 4]);
            }
        }
        ChannelBuffer data = ChannelBuffers.wrappedBuffer(body);
        WebSocketFrame.FrameType frameType = this.decodeFrameType(opcode);
        return new DefaultWebSocketFrame(frameType, data);
    }

    protected WebSocketFrame.FrameType decodeFrameType(int opcode) {
        switch (opcode) {
            case 0: {
                return WebSocketFrame.FrameType.CONTINUATION;
            }
            case 1: {
                return WebSocketFrame.FrameType.TEXT;
            }
            case 2: {
                return WebSocketFrame.FrameType.BINARY;
            }
            case 8: {
                return WebSocketFrame.FrameType.CLOSE;
            }
            case 9: {
                return WebSocketFrame.FrameType.PING;
            }
            case 10: {
                return WebSocketFrame.FrameType.PONG;
            }
        }
        return null;
    }
}

