/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws.hybi17;

import java.security.NoSuchAlgorithmException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.impl.ws.hybi08.Handshake08;
import org.vertx.java.core.http.impl.ws.hybi08.WebSocketChallenge08;

public class HandshakeRFC6455
extends Handshake08 {
    public static boolean matches(HttpRequest request) {
        String sVers = request.getHeader("Sec-WebSocket-Version");
        if (sVers != null) {
            Integer ver = Integer.parseInt(sVers);
            return request.containsHeader("Sec-WebSocket-Key") && ver == 13;
        }
        return false;
    }

    @Override
    public void fillInRequest(HttpClientRequest req, String hostHeader) throws Exception {
        req.headers().put("Sec-WebSocket-Version", "13");
        req.headers().put("Connection", "Upgrade");
        req.headers().put("Upgrade", "WebSocket");
        req.headers().put("Host", hostHeader);
        req.headers().put("Sec-WebSocket-Key", this.challenge.getNonceBase64());
    }

    @Override
    public HttpResponse generateResponse(HttpRequest request, String serverOrigin) throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, "Switching Protocols"));
        response.addHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        String origin = request.getHeader("Origin");
        if (origin != null) {
            response.addHeader("Sec-WebSocket-Origin", origin);
        }
        response.addHeader("Sec-WebSocket-Location", this.getWebSocketLocation(request, serverOrigin));
        String protocol = request.getHeader("Sec-WebSocket-Protocol");
        if (protocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", protocol);
        }
        String key = request.getHeader("Sec-WebSocket-Key");
        String solution = WebSocketChallenge08.solve(key);
        response.addHeader("Sec-WebSocket-Accept", solution);
        response.setChunked(false);
        return response;
    }
}

