/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.VertxInternal;

public abstract class BlockingAction<T> {
    protected Context context;
    private final VertxInternal vertx;
    private final AsyncResultHandler handler;

    public BlockingAction(VertxInternal vertx, AsyncResultHandler handler) {
        this.vertx = vertx;
        this.handler = handler;
    }

    public void run() {
        this.context = this.vertx.getOrAssignContext();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                AsyncResult res;
                try {
                    Object result = BlockingAction.this.action();
                    res = new AsyncResult(result);
                }
                catch (Exception e) {
                    res = new AsyncResult(e);
                }
                if (BlockingAction.this.handler != null) {
                    final AsyncResult theRes = res;
                    BlockingAction.this.context.execute(new Runnable(){

                        @Override
                        public void run() {
                            BlockingAction.this.handler.handle(theRes);
                        }
                    });
                }
            }
        };
        this.context.executeOnWorker(runner);
    }

    public abstract T action() throws Exception;
}

