/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import java.util.LinkedList;
import java.util.Queue;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public abstract class ConnectionPool<T> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPool.class);
    private final Queue<T> available = new LinkedList<T>();
    private int maxPoolSize = 1;
    private int connectionCount;
    private final Queue<Waiter> waiters = new LinkedList<Waiter>();

    public void setMaxPoolSize(int maxConnections) {
        this.maxPoolSize = maxConnections;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized void report() {
        log.trace("available: " + this.available.size() + " connection count: " + this.connectionCount + " waiters: " + this.waiters.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnection(Handler<T> handler, Handler<Exception> connectExceptionHandler, Context context) {
        T conn;
        boolean connect = false;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            conn = this.available.poll();
            if (conn != null) {
            } else if (this.connectionCount < this.maxPoolSize) {
                connect = true;
                ++this.connectionCount;
            } else {
                this.waiters.add(new Waiter(handler, connectExceptionHandler, context));
            }
        }
        if (conn != null) {
            handler.handle(conn);
        } else if (connect) {
            this.connect(handler, connectExceptionHandler, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed() {
        Waiter waiter;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            --this.connectionCount;
            if (this.connectionCount < this.maxPoolSize) {
                waiter = this.waiters.poll();
                if (waiter != null) {
                    ++this.connectionCount;
                }
            } else {
                waiter = null;
            }
        }
        if (waiter != null) {
            this.connect(waiter.handler, waiter.connectionExceptionHandler, waiter.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(final T conn) {
        Waiter waiter;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            waiter = this.waiters.poll();
            if (waiter == null) {
                this.available.add(conn);
            }
        }
        if (waiter != null) {
            final Waiter w = waiter;
            w.context.execute(new Runnable(){

                @Override
                public void run() {
                    w.handler.handle(conn);
                }
            });
        }
    }

    public void close() {
        this.available.clear();
        this.waiters.clear();
    }

    protected abstract void connect(Handler<T> var1, Handler<Exception> var2, Context var3);

    private class Waiter {
        final Handler<T> handler;
        final Handler<Exception> connectionExceptionHandler;
        final Context context;

        private Waiter(Handler<T> handler, Handler<Exception> connectionExceptionHandler, Context context) {
            this.handler = handler;
            this.connectionExceptionHandler = connectionExceptionHandler;
            this.context = context;
        }
    }
}

