/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.vertx.java.core.impl.DeploymentHandle;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public abstract class Context {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    private final VertxInternal vertx;
    private DeploymentHandle deploymentContext;
    private Path pathAdjustment;
    private Map<Object, Runnable> closeHooks;
    private final Executor bgExec;
    private final ClassLoader tccl;

    protected Context(VertxInternal vertx, Executor bgExec) {
        this.vertx = vertx;
        this.bgExec = bgExec;
        this.tccl = Thread.currentThread().getContextClassLoader();
    }

    public void setTCCL() {
        Thread.currentThread().setContextClassLoader(this.tccl);
    }

    public void setDeploymentHandle(DeploymentHandle deploymentHandle) {
        this.deploymentContext = deploymentHandle;
    }

    public DeploymentHandle getDeploymentHandle() {
        return this.deploymentContext;
    }

    public Path getPathAdjustment() {
        return this.pathAdjustment;
    }

    public void setPathAdjustment(Path pathAdjustment) {
        this.pathAdjustment = pathAdjustment;
    }

    public void reportException(Throwable t) {
        if (this.deploymentContext != null) {
            this.deploymentContext.reportException(t);
        } else {
            t.printStackTrace();
            log.error("context Unhandled exception", t);
        }
    }

    public Runnable getCloseHook(Object key) {
        return this.closeHooks == null ? null : this.closeHooks.get(key);
    }

    public void putCloseHook(Object key, Runnable hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new HashMap<Object, Runnable>();
        }
        this.closeHooks.put(key, hook);
    }

    public void runCloseHooks() {
        if (this.closeHooks != null) {
            for (Runnable hook : this.closeHooks.values()) {
                try {
                    hook.run();
                }
                catch (Throwable t) {
                    this.reportException(t);
                }
            }
        }
    }

    public abstract void execute(Runnable var1);

    public void executeOnWorker(final Runnable task) {
        this.bgExec.execute(new Runnable(){

            @Override
            public void run() {
                Context.this.wrapTask(task).run();
            }
        });
    }

    protected Runnable wrapTask(final Runnable task) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String threadName = Thread.currentThread().getName();
                try {
                    Context.this.vertx.setContext(Context.this);
                    task.run();
                }
                catch (Throwable t) {
                    Context.this.reportException(t);
                }
                finally {
                    Thread.currentThread().setName(threadName);
                }
            }
        };
    }
}

