/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.impl.DefaultEventBus;
import org.vertx.java.core.file.FileSystem;
import org.vertx.java.core.file.impl.DefaultFileSystem;
import org.vertx.java.core.file.impl.WindowsFileSystem;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.impl.DefaultHttpClient;
import org.vertx.java.core.http.impl.DefaultHttpServer;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.EventLoopContext;
import org.vertx.java.core.impl.OrderedExecutorFactory;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.impl.VertxThreadFactory;
import org.vertx.java.core.impl.Windows;
import org.vertx.java.core.impl.WorkerContext;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.net.impl.DefaultNetClient;
import org.vertx.java.core.net.impl.DefaultNetServer;
import org.vertx.java.core.net.impl.ServerID;
import org.vertx.java.core.shareddata.SharedData;
import org.vertx.java.core.sockjs.SockJSServer;
import org.vertx.java.core.sockjs.impl.DefaultSockJSServer;

public class DefaultVertx
extends VertxInternal {
    private static final Logger log = LoggerFactory.getLogger(DefaultVertx.class);
    private static final int DEFAULT_WORKER_POOL_SIZE = 20;
    private final FileSystem fileSystem = this.getFileSystem();
    private final EventBus eventBus;
    private final SharedData sharedData = new SharedData();
    private int backgroundPoolSize;
    private int corePoolSize = Runtime.getRuntime().availableProcessors();
    private ExecutorService backgroundPool;
    private OrderedExecutorFactory orderedFact;
    private NioWorkerPool workerPool;
    private ExecutorService acceptorPool;
    private Map<ServerID, DefaultHttpServer> sharedHttpServers = new HashMap<ServerID, DefaultHttpServer>();
    private Map<ServerID, DefaultNetServer> sharedNetServers = new HashMap<ServerID, DefaultNetServer>();
    private final ThreadLocal<Context> contextTL = new ThreadLocal();
    private HashedWheelTimer timer = new HashedWheelTimer(new VertxThreadFactory("vert.x-timer-thread"), 1L, TimeUnit.MILLISECONDS, 8192);
    private final AtomicLong timeoutCounter;
    private final Map<Long, TimeoutHolder> timeouts;

    public DefaultVertx() {
        this.timer.start();
        this.timeoutCounter = new AtomicLong(0L);
        this.timeouts = new ConcurrentHashMap<Long, TimeoutHolder>();
        this.configure();
        this.eventBus = new DefaultEventBus(this);
    }

    public DefaultVertx(String hostname) {
        this.timer.start();
        this.timeoutCounter = new AtomicLong(0L);
        this.timeouts = new ConcurrentHashMap<Long, TimeoutHolder>();
        this.configure();
        this.eventBus = new DefaultEventBus(this, hostname);
    }

    public DefaultVertx(int port, String hostname) {
        this.timer.start();
        this.timeoutCounter = new AtomicLong(0L);
        this.timeouts = new ConcurrentHashMap<Long, TimeoutHolder>();
        this.configure();
        this.eventBus = new DefaultEventBus(this, port, hostname);
    }

    private void configure() {
        this.backgroundPoolSize = Integer.getInteger("vertx.backgroundPoolSize", 20);
    }

    protected FileSystem getFileSystem() {
        return Windows.isWindows() ? new WindowsFileSystem(this) : new DefaultFileSystem(this);
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public NetServer createNetServer() {
        return new DefaultNetServer(this);
    }

    @Override
    public NetClient createNetClient() {
        return new DefaultNetClient(this);
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public SharedData sharedData() {
        return this.sharedData;
    }

    @Override
    public HttpServer createHttpServer() {
        return new DefaultHttpServer(this);
    }

    @Override
    public HttpClient createHttpClient() {
        return new DefaultHttpClient(this);
    }

    @Override
    public SockJSServer createSockJSServer(HttpServer httpServer) {
        return new DefaultSockJSServer(this, httpServer);
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public Context startOnEventLoop(Runnable runnable) {
        Context context = this.createEventLoopContext();
        context.execute(runnable);
        return context;
    }

    @Override
    public Context startInBackground(Runnable runnable) {
        Context context = this.createWorkerContext();
        context.execute(runnable);
        return context;
    }

    @Override
    public boolean isEventLoop() {
        Context context = this.getContext();
        if (context != null) {
            return context instanceof EventLoopContext;
        }
        return false;
    }

    @Override
    public boolean isWorker() {
        Context context = this.getContext();
        if (context != null) {
            return context instanceof WorkerContext;
        }
        return false;
    }

    @Override
    public long setPeriodic(long delay, Handler<Long> handler) {
        return this.setTimeout(delay, true, handler);
    }

    @Override
    public long setTimer(long delay, Handler<Long> handler) {
        return this.setTimeout(delay, false, handler);
    }

    @Override
    public void runOnLoop(final Handler<Void> handler) {
        Context context = this.getOrAssignContext();
        context.execute(new Runnable(){

            @Override
            public void run() {
                handler.handle(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getBackgroundPool() {
        ExecutorService result = this.backgroundPool;
        if (result == null) {
            DefaultVertx defaultVertx = this;
            synchronized (defaultVertx) {
                result = this.backgroundPool;
                if (result == null) {
                    this.backgroundPool = result = Executors.newFixedThreadPool(this.backgroundPoolSize, new VertxThreadFactory("vert.x-worker-thread-"));
                    this.orderedFact = new OrderedExecutorFactory(this.backgroundPool);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioWorkerPool getWorkerPool() {
        NioWorkerPool result = this.workerPool;
        if (result == null) {
            DefaultVertx defaultVertx = this;
            synchronized (defaultVertx) {
                result = this.workerPool;
                if (result == null) {
                    ExecutorService corePool = Executors.newFixedThreadPool(this.corePoolSize, new VertxThreadFactory("vert.x-core-thread-"));
                    this.workerPool = result = new NioWorkerPool(corePool, this.corePoolSize);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getAcceptorPool() {
        ExecutorService result = this.acceptorPool;
        if (result == null) {
            DefaultVertx defaultVertx = this;
            synchronized (defaultVertx) {
                result = this.acceptorPool;
                if (result == null) {
                    this.acceptorPool = result = Executors.newCachedThreadPool(new VertxThreadFactory("vert.x-acceptor-thread-"));
                }
            }
        }
        return result;
    }

    @Override
    public Context getOrAssignContext() {
        Context ctx = this.getContext();
        if (ctx == null) {
            ctx = this.createEventLoopContext();
        }
        return ctx;
    }

    @Override
    public void reportException(Throwable t) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.reportException(t);
        } else {
            log.error(" default vertx Unhandled exception ", t);
        }
    }

    @Override
    public Map<ServerID, DefaultHttpServer> sharedHttpServers() {
        return this.sharedHttpServers;
    }

    @Override
    public Map<ServerID, DefaultNetServer> sharedNetServers() {
        return this.sharedNetServers;
    }

    private long setTimeout(final long delay, boolean periodic, Handler<Long> handler) {
        long timerID;
        final Context context = this.getOrAssignContext();
        InternalTimerHandler myHandler = periodic ? new InternalTimerHandler(handler){

            @Override
            public void run() {
                super.run();
                DefaultVertx.this.scheduleTimeout(this.timerID, context, this, delay);
            }
        } : new InternalTimerHandler(handler){

            @Override
            public void run() {
                super.run();
                DefaultVertx.this.timeouts.remove(this.timerID);
            }
        };
        myHandler.timerID = timerID = this.scheduleTimeout(-1L, context, myHandler, delay);
        return timerID;
    }

    @Override
    public boolean cancelTimer(long id) {
        return this.cancelTimeout(id);
    }

    public Context createEventLoopContext() {
        this.getBackgroundPool();
        NioWorker worker = (NioWorker)this.getWorkerPool().nextWorker();
        return new EventLoopContext(this, this.orderedFact.getExecutor(), worker);
    }

    private boolean cancelTimeout(long id) {
        TimeoutHolder holder = this.timeouts.remove(id);
        if (holder != null) {
            holder.timeout.cancel();
            return true;
        }
        return false;
    }

    private long scheduleTimeout(long id, final Context context, final Runnable task, long delay) {
        TimerTask ttask = new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                context.execute(task);
            }
        };
        if (id != -1L && this.timeouts.get(id) == null) {
            return -1L;
        }
        Timeout timeout = this.timer.newTimeout(ttask, delay, TimeUnit.MILLISECONDS);
        id = id != -1L ? id : this.timeoutCounter.getAndIncrement();
        this.timeouts.put(id, new TimeoutHolder(timeout, context));
        return id;
    }

    private Context createWorkerContext() {
        this.getBackgroundPool();
        return new WorkerContext(this, this.orderedFact.getExecutor());
    }

    @Override
    public void setContext(Context context) {
        this.contextTL.set(context);
        if (context != null) {
            context.setTCCL();
        }
    }

    @Override
    public Context getContext() {
        return this.contextTL.get();
    }

    @Override
    public void stop() {
        if (this.sharedHttpServers != null) {
            for (HttpServer httpServer : this.sharedHttpServers.values()) {
                httpServer.close();
            }
            this.sharedHttpServers = null;
        }
        if (this.sharedNetServers != null) {
            for (NetServer netServer : this.sharedNetServers.values()) {
                netServer.close();
            }
            this.sharedNetServers = null;
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.eventBus != null) {
            this.eventBus.close(null);
        }
        if (this.backgroundPool != null) {
            this.backgroundPool.shutdown();
        }
        if (this.acceptorPool != null) {
            this.acceptorPool.shutdown();
        }
        try {
            if (this.backgroundPool != null) {
                this.backgroundPool.awaitTermination(20L, TimeUnit.SECONDS);
                this.backgroundPool = null;
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            if (this.acceptorPool != null) {
                this.acceptorPool.awaitTermination(20L, TimeUnit.SECONDS);
                this.acceptorPool = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.workerPool != null) {
            this.workerPool.releaseExternalResources();
            this.workerPool = null;
        }
        this.setContext(null);
    }

    private static class TimeoutHolder {
        final Timeout timeout;

        TimeoutHolder(Timeout timeout, Context context) {
            this.timeout = timeout;
        }
    }

    private static class InternalTimerHandler
    implements Runnable {
        final Handler<Long> handler;
        long timerID;

        InternalTimerHandler(Handler<Long> runnable) {
            this.handler = runnable;
        }

        @Override
        public void run() {
            this.handler.handle(this.timerID);
        }
    }
}

