/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.json.impl;

import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.vertx.java.core.json.DecodeException;
import org.vertx.java.core.json.EncodeException;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class Json {
    private static final Logger log = LoggerFactory.getLogger(Json.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectMapper prettyMapper = new ObjectMapper();

    public static String encode(Object obj) throws EncodeException {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static String encodePrettily(Object obj) throws EncodeException {
        try {
            return prettyMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static Object decodeValue(String str, Class<?> clazz) throws DecodeException {
        try {
            return mapper.readValue(str, clazz);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage());
        }
    }

    static {
        prettyMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
    }
}

