/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.vertx.java.core.Handler;
import org.vertx.java.core.SimpleHandler;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public abstract class ConnectionBase {
    private static final Logger log = LoggerFactory.getLogger(ConnectionBase.class);
    protected final VertxInternal vertx;
    protected final Channel channel;
    protected final Context context;
    protected Handler<Exception> exceptionHandler;
    protected Handler<Void> closedHandler;

    protected ConnectionBase(VertxInternal vertx, Channel channel, Context context) {
        this.vertx = vertx;
        this.channel = channel;
        this.context = context;
    }

    public void pause() {
        this.channel.setReadable(false);
    }

    public void resume() {
        this.channel.setReadable(true);
    }

    public void setWriteQueueMaxSize(int size) {
        NioSocketChannelConfig conf = (NioSocketChannelConfig)this.channel.getConfig();
        conf.setWriteBufferLowWaterMark(size / 2);
        conf.setWriteBufferHighWaterMark(size);
    }

    public boolean writeQueueFull() {
        return !this.channel.isWritable();
    }

    public void close() {
        this.channel.close();
    }

    public void exceptionHandler(Handler<Exception> handler) {
        this.exceptionHandler = handler;
    }

    public void closedHandler(Handler<Void> handler) {
        this.closedHandler = handler;
    }

    protected Context getContext() {
        return this.context;
    }

    protected void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.setContext();
            try {
                this.exceptionHandler.handle(e);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    protected void handleClosed() {
        if (this.closedHandler != null) {
            this.setContext();
            try {
                this.closedHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    protected void addFuture(final Handler<Void> doneHandler, ChannelFuture future) {
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(final ChannelFuture channelFuture) throws Exception {
                ConnectionBase.this.setContext();
                ConnectionBase.this.vertx.runOnLoop(new SimpleHandler(){

                    @Override
                    public void handle() {
                        if (channelFuture.isSuccess()) {
                            doneHandler.handle(null);
                        } else {
                            Throwable err = channelFuture.getCause();
                            if (ConnectionBase.this.exceptionHandler != null && err instanceof Exception) {
                                ConnectionBase.this.exceptionHandler.handle((Exception)err);
                            } else {
                                log.error("Unhandled exception", err);
                            }
                        }
                    }
                });
            }
        });
    }

    protected void setContext() {
        this.vertx.setContext(this.context);
    }

    protected void handleHandlerException(Throwable t) {
        this.vertx.reportException(t);
    }

    protected boolean isSSL() {
        return this.channel.getPipeline().get(SslHandler.class) != null;
    }

    protected ChannelFuture sendFile(File file) {
        try {
            ChannelFuture writeFuture;
            final RandomAccessFile raf = new RandomAccessFile(file, "r");
            long fileLength = file.length();
            if (this.isSSL()) {
                writeFuture = this.channel.write(new ChunkedFile(raf, 0L, fileLength, 8192));
            } else {
                DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
                writeFuture = this.channel.write(region);
            }
            writeFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    raf.close();
                }
            });
            return writeFuture;
        }
        catch (IOException e) {
            this.handleException(e);
            return null;
        }
    }
}

