/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.impl.EventLoopContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.TCPSSLHelper;
import org.vertx.java.core.net.impl.VertxWorkerPool;

public class DefaultNetClient
implements NetClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultNetClient.class);
    private final VertxInternal vertx;
    private final EventLoopContext ctx;
    private final TCPSSLHelper tcpHelper = new TCPSSLHelper();
    private ClientBootstrap bootstrap;
    private NioClientSocketChannelFactory channelFactory;
    private Map<Channel, DefaultNetSocket> socketMap = new ConcurrentHashMap<Channel, DefaultNetSocket>();
    private Handler<Exception> exceptionHandler;
    private int reconnectAttempts;
    private long reconnectInterval = 1000L;

    public DefaultNetClient(VertxInternal vertx) {
        this.vertx = vertx;
        if (vertx.isWorker()) {
            throw new IllegalStateException("Cannot be used in a worker application");
        }
        this.ctx = (EventLoopContext)vertx.getOrAssignContext();
        this.ctx.putCloseHook(this, new Runnable(){

            @Override
            public void run() {
                DefaultNetClient.this.close();
            }
        });
    }

    @Override
    public NetClient connect(int port, String host, Handler<NetSocket> connectHandler) {
        this.connect(port, host, connectHandler, this.reconnectAttempts);
        return this;
    }

    @Override
    public NetClient connect(int port, Handler<NetSocket> connectCallback) {
        this.connect(port, "localhost", connectCallback);
        return this;
    }

    @Override
    public void close() {
        for (NetSocket netSocket : this.socketMap.values()) {
            netSocket.close();
        }
    }

    @Override
    public NetClient setReconnectAttempts(int attempts) {
        if (attempts < -1) {
            throw new IllegalArgumentException("reconnect attempts must be >= -1");
        }
        this.reconnectAttempts = attempts;
        return this;
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public NetClient setReconnectInterval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("reconnect interval nust be >= 1");
        }
        this.reconnectInterval = interval;
        return this;
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.exceptionHandler = handler;
    }

    @Override
    public Boolean isTCPNoDelay() {
        return this.tcpHelper.isTCPNoDelay();
    }

    @Override
    public Integer getSendBufferSize() {
        return this.tcpHelper.getSendBufferSize();
    }

    @Override
    public Integer getReceiveBufferSize() {
        return this.tcpHelper.getReceiveBufferSize();
    }

    @Override
    public Boolean isTCPKeepAlive() {
        return this.tcpHelper.isTCPKeepAlive();
    }

    @Override
    public Boolean isReuseAddress() {
        return this.tcpHelper.isReuseAddress();
    }

    @Override
    public Boolean isSoLinger() {
        return this.tcpHelper.isSoLinger();
    }

    @Override
    public Integer getTrafficClass() {
        return this.tcpHelper.getTrafficClass();
    }

    @Override
    public Long getConnectTimeout() {
        return this.tcpHelper.getConnectTimeout();
    }

    @Override
    public Integer getBossThreads() {
        return this.tcpHelper.getClientBossThreads();
    }

    @Override
    public NetClient setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpHelper.setTCPNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetClient setSendBufferSize(int size) {
        this.tcpHelper.setSendBufferSize(size);
        return this;
    }

    @Override
    public NetClient setReceiveBufferSize(int size) {
        this.tcpHelper.setReceiveBufferSize(size);
        return this;
    }

    @Override
    public NetClient setTCPKeepAlive(boolean keepAlive) {
        this.tcpHelper.setTCPKeepAlive(keepAlive);
        return this;
    }

    @Override
    public NetClient setReuseAddress(boolean reuse) {
        this.tcpHelper.setReuseAddress(reuse);
        return this;
    }

    @Override
    public NetClient setSoLinger(boolean linger) {
        this.tcpHelper.setSoLinger(linger);
        return this;
    }

    @Override
    public NetClient setTrafficClass(int trafficClass) {
        this.tcpHelper.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetClient setConnectTimeout(long timeout) {
        this.tcpHelper.setConnectTimeout(timeout);
        return this;
    }

    @Override
    public NetClient setBossThreads(int threads) {
        this.tcpHelper.setClientBossThreads(threads);
        return this;
    }

    @Override
    public boolean isSSL() {
        return this.tcpHelper.isSSL();
    }

    @Override
    public String getKeyStorePath() {
        return this.tcpHelper.getKeyStorePath();
    }

    @Override
    public String getKeyStorePassword() {
        return this.tcpHelper.getKeyStorePassword();
    }

    @Override
    public String getTrustStorePath() {
        return this.tcpHelper.getTrustStorePath();
    }

    @Override
    public String getTrustStorePassword() {
        return this.tcpHelper.getTrustStorePassword();
    }

    public TCPSSLHelper.ClientAuth getClientAuth() {
        return this.tcpHelper.getClientAuth();
    }

    public SSLContext getSSLContext() {
        return this.tcpHelper.getSSLContext();
    }

    @Override
    public boolean isTrustAll() {
        return this.tcpHelper.isTrustAll();
    }

    @Override
    public NetClient setSSL(boolean ssl) {
        this.tcpHelper.setSSL(ssl);
        return this;
    }

    @Override
    public NetClient setKeyStorePath(String path) {
        this.tcpHelper.setKeyStorePath(path);
        return this;
    }

    @Override
    public NetClient setKeyStorePassword(String pwd) {
        this.tcpHelper.setKeyStorePassword(pwd);
        return this;
    }

    @Override
    public NetClient setTrustStorePath(String path) {
        this.tcpHelper.setTrustStorePath(path);
        return this;
    }

    @Override
    public NetClient setTrustStorePassword(String pwd) {
        this.tcpHelper.setTrustStorePassword(pwd);
        return this;
    }

    @Override
    public NetClient setTrustAll(boolean trustAll) {
        this.tcpHelper.setTrustAll(trustAll);
        return this;
    }

    private void connect(final int port, final String host, final Handler<NetSocket> connectHandler, final int remainingAttempts) {
        if (this.bootstrap == null) {
            VertxWorkerPool pool = new VertxWorkerPool();
            pool.addWorker(this.ctx.getWorker());
            Integer bossThreads = this.tcpHelper.getClientBossThreads();
            int threads = bossThreads == null ? 1 : bossThreads;
            this.channelFactory = new NioClientSocketChannelFactory(this.vertx.getAcceptorPool(), threads, pool, this.vertx.getTimer());
            this.bootstrap = new ClientBootstrap(this.channelFactory);
            this.tcpHelper.checkSSL(this.vertx);
            this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                @Override
                public ChannelPipeline getPipeline() throws Exception {
                    ChannelPipeline pipeline = Channels.pipeline();
                    if (DefaultNetClient.this.tcpHelper.isSSL()) {
                        SSLEngine engine = DefaultNetClient.this.tcpHelper.getSSLContext().createSSLEngine();
                        engine.setUseClientMode(true);
                        pipeline.addLast("ssl", new SslHandler(engine));
                    }
                    pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
                    pipeline.addLast("handler", new ClientHandler());
                    return pipeline;
                }
            });
        }
        this.bootstrap.setOptions(this.tcpHelper.generateConnectionOptions(false));
        ChannelFuture future = this.bootstrap.connect(new InetSocketAddress(host, port));
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                final NioSocketChannel ch = (NioSocketChannel)channelFuture.getChannel();
                if (channelFuture.isSuccess()) {
                    if (DefaultNetClient.this.tcpHelper.isSSL()) {
                        SslHandler sslHandler = (SslHandler)ch.getPipeline().get("ssl");
                        ChannelFuture fut = sslHandler.handshake();
                        fut.addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                                if (channelFuture.isSuccess()) {
                                    DefaultNetClient.this.connected(ch, connectHandler);
                                } else {
                                    DefaultNetClient.this.failed(ch, new SSLHandshakeException("Failed to create SSL connection"));
                                }
                            }
                        });
                    } else {
                        DefaultNetClient.this.connected(ch, connectHandler);
                    }
                } else if (remainingAttempts > 0 || remainingAttempts == -1) {
                    DefaultNetClient.this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                        @Override
                        public void run() {
                            DefaultNetClient.this.vertx.setContext(DefaultNetClient.this.ctx);
                            log.debug("Failed to create connection. Will retry in " + DefaultNetClient.this.reconnectInterval + " milliseconds");
                            DefaultNetClient.this.vertx.setTimer(DefaultNetClient.this.reconnectInterval, new Handler<Long>(){

                                @Override
                                public void handle(Long timerID) {
                                    DefaultNetClient.this.connect(port, host, connectHandler, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1);
                                }
                            });
                        }
                    });
                } else {
                    DefaultNetClient.this.failed(ch, channelFuture.getCause());
                }
            }
        });
    }

    private void connected(final NioSocketChannel ch, final Handler<NetSocket> connectHandler) {
        this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

            @Override
            public void run() {
                DefaultNetClient.this.vertx.setContext(DefaultNetClient.this.ctx);
                DefaultNetSocket sock = new DefaultNetSocket(DefaultNetClient.this.vertx, ch, DefaultNetClient.this.ctx);
                DefaultNetClient.this.socketMap.put(ch, sock);
                connectHandler.handle(sock);
            }
        });
    }

    private void failed(NioSocketChannel ch, final Throwable t) {
        ch.close();
        if (t instanceof Exception && this.exceptionHandler != null) {
            this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                @Override
                public void run() {
                    DefaultNetClient.this.vertx.setContext(DefaultNetClient.this.ctx);
                    DefaultNetClient.this.exceptionHandler.handle((Exception)t);
                }
            });
        } else {
            log.error("Unhandled exception", t);
        }
    }

    private class ClientHandler
    extends SimpleChannelUpstreamHandler {
        private ClientHandler() {
        }

        @Override
        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        }

        @Override
        public void channelClosed(ChannelHandlerContext chctx, ChannelStateEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final DefaultNetSocket sock = (DefaultNetSocket)DefaultNetClient.this.socketMap.remove(ch);
            if (sock != null) {
                DefaultNetClient.this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleClosed();
                    }
                });
            }
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            DefaultNetSocket sock = (DefaultNetSocket)DefaultNetClient.this.socketMap.get(ctx.getChannel());
            if (sock != null) {
                ChannelBuffer cb = (ChannelBuffer)e.getMessage();
                sock.handleDataReceived(new Buffer(cb));
            }
        }

        @Override
        public void channelInterestChanged(ChannelHandlerContext chctx, ChannelStateEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final DefaultNetSocket sock = (DefaultNetSocket)DefaultNetClient.this.socketMap.get(ch);
            ChannelState state = e.getState();
            if (state == ChannelState.INTEREST_OPS) {
                DefaultNetClient.this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleInterestedOpsChanged();
                    }
                });
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext chctx, ExceptionEvent e) {
            final NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final NetSocket sock = (NetSocket)DefaultNetClient.this.socketMap.remove(ch);
            final Throwable t = e.getCause();
            if (sock != null && t instanceof Exception) {
                DefaultNetClient.this.tcpHelper.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleException((Exception)t);
                        ch.close();
                    }
                });
            }
        }
    }
}

