/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.EventLoopContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.HandlerHolder;
import org.vertx.java.core.net.impl.HandlerManager;
import org.vertx.java.core.net.impl.ServerID;
import org.vertx.java.core.net.impl.TCPSSLHelper;
import org.vertx.java.core.net.impl.VertxWorkerPool;

public class DefaultNetServer
implements NetServer {
    private static final Logger log = LoggerFactory.getLogger(DefaultNetServer.class);
    private final VertxInternal vertx;
    private final EventLoopContext ctx;
    private final TCPSSLHelper tcpHelper = new TCPSSLHelper();
    private final Map<Channel, DefaultNetSocket> socketMap = new ConcurrentHashMap<Channel, DefaultNetSocket>();
    private Handler<NetSocket> connectHandler;
    private ChannelGroup serverChannelGroup;
    private boolean listening;
    private ServerID id;
    private DefaultNetServer actualServer;
    private final VertxWorkerPool availableWorkers = new VertxWorkerPool();
    private final HandlerManager<NetSocket> handlerManager = new HandlerManager(this.availableWorkers);
    private static final AtomicInteger cnt = new AtomicInteger();

    public DefaultNetServer(VertxInternal vertx) {
        this.vertx = vertx;
        if (vertx.isWorker()) {
            throw new IllegalStateException("Cannot be used in a worker application.");
        }
        this.ctx = (EventLoopContext)vertx.getOrAssignContext();
        this.ctx.putCloseHook(this, new Runnable(){

            @Override
            public void run() {
                DefaultNetServer.this.close();
            }
        });
        this.tcpHelper.setReuseAddress(true);
    }

    @Override
    public NetServer connectHandler(Handler<NetSocket> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public NetServer listen(int port) {
        this.listen(port, "0.0.0.0");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetServer listen(int port, String host) {
        if (this.connectHandler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        Map<ServerID, DefaultNetServer> map = this.vertx.sharedNetServers();
        synchronized (map) {
            this.id = new ServerID(port, host);
            DefaultNetServer shared = this.vertx.sharedNetServers().get(this.id);
            if (shared == null) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels");
                NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory(this.vertx.getAcceptorPool(), this.availableWorkers);
                ServerBootstrap bootstrap = new ServerBootstrap(factory);
                this.tcpHelper.checkSSL(this.vertx);
                bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                    @Override
                    public ChannelPipeline getPipeline() {
                        ChannelPipeline pipeline = Channels.pipeline();
                        if (DefaultNetServer.this.tcpHelper.isSSL()) {
                            SSLEngine engine = DefaultNetServer.this.tcpHelper.getSSLContext().createSSLEngine();
                            engine.setUseClientMode(false);
                            switch (DefaultNetServer.this.tcpHelper.getClientAuth()) {
                                case REQUEST: {
                                    engine.setWantClientAuth(true);
                                    break;
                                }
                                case REQUIRED: {
                                    engine.setNeedClientAuth(true);
                                    break;
                                }
                                case NONE: {
                                    engine.setNeedClientAuth(false);
                                }
                            }
                            pipeline.addLast("ssl", new SslHandler(engine));
                        }
                        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
                        pipeline.addLast("handler", new ServerHandler());
                        return pipeline;
                    }
                });
                bootstrap.setOptions(this.tcpHelper.generateConnectionOptions(true));
                try {
                    Channel serverChannel = bootstrap.bind(new InetSocketAddress(InetAddress.getByName(host), port));
                    this.serverChannelGroup.add(serverChannel);
                    log.trace("Net server listening on " + host + ":" + port);
                }
                catch (UnknownHostException e) {
                    log.error("Failed to bind", e);
                }
                this.vertx.sharedNetServers().put(this.id, this);
                this.actualServer = this;
            } else {
                this.checkConfigs(this.actualServer, this);
                this.actualServer = shared;
            }
            this.actualServer.handlerManager.addHandler(this.connectHandler, this.ctx);
        }
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<Void> done) {
        if (!this.listening) {
            if (done != null) {
                this.executeCloseDone(this.ctx, done);
            }
            return;
        }
        this.listening = false;
        Map<ServerID, DefaultNetServer> map = this.vertx.sharedNetServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.handlerManager.removeHandler(this.connectHandler, this.ctx);
                if (this.actualServer.handlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(this.ctx, done);
                    }
                } else {
                    this.actualServer.actualClose(this.ctx, done);
                }
            }
        }
    }

    private void actualClose(Context closeContext, Handler<Void> done) {
        if (this.id != null) {
            this.vertx.sharedNetServers().remove(this.id);
        }
        for (DefaultNetSocket sock : this.socketMap.values()) {
            sock.internalClose();
        }
        this.vertx.setContext(closeContext);
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener(new ChannelGroupFutureListener(){

            @Override
            public void operationComplete(ChannelGroupFuture channelGroupFuture) throws Exception {
                latch.countDown();
            }
        });
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.executeCloseDone(closeContext, done);
    }

    private void checkConfigs(DefaultNetServer currentServer, DefaultNetServer newServer) {
    }

    private void executeCloseDone(Context closeContext, final Handler<Void> done) {
        if (done != null) {
            closeContext.execute(new Runnable(){

                @Override
                public void run() {
                    done.handle(null);
                }
            });
        }
    }

    @Override
    public Boolean isTCPNoDelay() {
        return this.tcpHelper.isTCPNoDelay();
    }

    @Override
    public Integer getSendBufferSize() {
        return this.tcpHelper.getSendBufferSize();
    }

    @Override
    public Integer getReceiveBufferSize() {
        return this.tcpHelper.getReceiveBufferSize();
    }

    @Override
    public Boolean isTCPKeepAlive() {
        return this.tcpHelper.isTCPKeepAlive();
    }

    @Override
    public Boolean isReuseAddress() {
        return this.tcpHelper.isReuseAddress();
    }

    @Override
    public Boolean isSoLinger() {
        return this.tcpHelper.isSoLinger();
    }

    @Override
    public Integer getTrafficClass() {
        return this.tcpHelper.getTrafficClass();
    }

    @Override
    public Integer getAcceptBacklog() {
        return this.tcpHelper.getAcceptBacklog();
    }

    @Override
    public NetServer setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpHelper.setTCPNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetServer setSendBufferSize(int size) {
        this.tcpHelper.setSendBufferSize(size);
        return this;
    }

    @Override
    public NetServer setReceiveBufferSize(int size) {
        this.tcpHelper.setReceiveBufferSize(size);
        return this;
    }

    @Override
    public NetServer setTCPKeepAlive(boolean keepAlive) {
        this.tcpHelper.setTCPKeepAlive(keepAlive);
        return this;
    }

    @Override
    public NetServer setReuseAddress(boolean reuse) {
        this.tcpHelper.setReuseAddress(reuse);
        return this;
    }

    @Override
    public NetServer setSoLinger(boolean linger) {
        this.tcpHelper.setSoLinger(linger);
        return this;
    }

    @Override
    public NetServer setTrafficClass(int trafficClass) {
        this.tcpHelper.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetServer setAcceptBacklog(int backlog) {
        this.tcpHelper.setAcceptBacklog(backlog);
        return this;
    }

    @Override
    public boolean isSSL() {
        return this.tcpHelper.isSSL();
    }

    @Override
    public String getKeyStorePath() {
        return this.tcpHelper.getKeyStorePath();
    }

    @Override
    public String getKeyStorePassword() {
        return this.tcpHelper.getKeyStorePassword();
    }

    @Override
    public String getTrustStorePath() {
        return this.tcpHelper.getTrustStorePath();
    }

    @Override
    public String getTrustStorePassword() {
        return this.tcpHelper.getTrustStorePassword();
    }

    public TCPSSLHelper.ClientAuth getClientAuth() {
        return this.tcpHelper.getClientAuth();
    }

    public SSLContext getSSLContext() {
        return this.tcpHelper.getSSLContext();
    }

    @Override
    public NetServer setSSL(boolean ssl) {
        this.tcpHelper.setSSL(ssl);
        return this;
    }

    @Override
    public NetServer setKeyStorePath(String path) {
        this.tcpHelper.setKeyStorePath(path);
        return this;
    }

    @Override
    public NetServer setKeyStorePassword(String pwd) {
        this.tcpHelper.setKeyStorePassword(pwd);
        return this;
    }

    @Override
    public NetServer setTrustStorePath(String path) {
        this.tcpHelper.setTrustStorePath(path);
        return this;
    }

    @Override
    public NetServer setTrustStorePassword(String pwd) {
        this.tcpHelper.setTrustStorePassword(pwd);
        return this;
    }

    @Override
    public NetServer setClientAuthRequired(boolean required) {
        this.tcpHelper.setClientAuthRequired(required);
        return this;
    }

    private class ServerHandler
    extends SimpleChannelHandler {
        private ServerHandler() {
        }

        @Override
        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
            final NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            NioWorker worker = ch.getWorker();
            final HandlerHolder<NetSocket> handler = DefaultNetServer.this.handlerManager.chooseHandler(worker);
            if (handler == null) {
                return;
            }
            if (DefaultNetServer.this.tcpHelper.isSSL()) {
                SslHandler sslHandler = (SslHandler)ch.getPipeline().get("ssl");
                ChannelFuture fut = sslHandler.handshake();
                fut.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (channelFuture.isSuccess()) {
                            ServerHandler.this.connected(ch, handler);
                        } else {
                            log.error("Client from origin " + ch.getRemoteAddress() + " failed to connect over ssl");
                        }
                    }
                });
            } else {
                this.connected(ch, handler);
            }
        }

        private void connected(final NioSocketChannel ch, final HandlerHolder<NetSocket> handler) {
            handler.context.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultNetSocket sock = new DefaultNetSocket(DefaultNetServer.this.vertx, ch, handler.context);
                    DefaultNetServer.this.socketMap.put(ch, sock);
                    handler.handler.handle(sock);
                }
            });
        }

        @Override
        public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final DefaultNetSocket sock = (DefaultNetSocket)DefaultNetServer.this.socketMap.get(ch);
            ChannelState state = e.getState();
            if (state == ChannelState.INTEREST_OPS) {
                sock.getContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        sock.handleInterestedOpsChanged();
                    }
                });
            }
        }

        @Override
        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final DefaultNetSocket sock = (DefaultNetSocket)DefaultNetServer.this.socketMap.remove(ch);
            if (sock != null) {
                sock.getContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        sock.handleClosed();
                    }
                });
            }
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            Channel ch = e.getChannel();
            DefaultNetSocket sock = (DefaultNetSocket)DefaultNetServer.this.socketMap.get(ch);
            if (sock != null) {
                ChannelBuffer buff = (ChannelBuffer)e.getMessage();
                sock.handleDataReceived(new Buffer(buff.slice()));
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final NetSocket sock = (NetSocket)DefaultNetServer.this.socketMap.remove(ch);
            ch.close();
            final Throwable t = e.getCause();
            log.error("Exception on netserver", t);
            if (sock != null && t instanceof Exception) {
                sock.getContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        sock.handleException((Exception)t);
                    }
                });
            }
        }
    }
}

