/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import java.io.File;
import java.nio.charset.Charset;
import java.util.UUID;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.util.CharsetUtil;
import org.vertx.java.core.Handler;
import org.vertx.java.core.SimpleHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetSocket;

public class DefaultNetSocket
extends NetSocket {
    private static final Logger log = LoggerFactory.getLogger(DefaultNetSocket.class);
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Void> drainHandler;
    private Handler<Message<Buffer>> writeHandler = new Handler<Message<Buffer>>(){

        @Override
        public void handle(Message<Buffer> msg) {
            DefaultNetSocket.this.writeBuffer((Buffer)msg.body);
        }
    };

    public DefaultNetSocket(VertxInternal vertx, Channel channel, Context context) {
        super(vertx, channel, UUID.randomUUID().toString(), context);
        vertx.eventBus().registerLocalHandler(this.writeHandlerID, this.writeHandler);
    }

    @Override
    public void writeBuffer(Buffer data) {
        this.doWrite(data.getChannelBuffer());
    }

    @Override
    public NetSocket write(Buffer data) {
        this.doWrite(data.getChannelBuffer());
        return this;
    }

    @Override
    public NetSocket write(String str) {
        this.doWrite(ChannelBuffers.copiedBuffer((CharSequence)str, CharsetUtil.UTF_8));
        return this;
    }

    @Override
    public NetSocket write(String str, String enc) {
        if (enc == null) {
            this.write(str);
        } else {
            this.doWrite(ChannelBuffers.copiedBuffer((CharSequence)str, Charset.forName(enc)));
        }
        return this;
    }

    @Override
    public NetSocket write(Buffer data, Handler<Void> doneHandler) {
        this.addFuture(doneHandler, this.doWrite(data.getChannelBuffer()));
        return this;
    }

    @Override
    public NetSocket write(String str, Handler<Void> doneHandler) {
        this.addFuture(doneHandler, this.doWrite(ChannelBuffers.copiedBuffer((CharSequence)str, CharsetUtil.UTF_8)));
        return this;
    }

    @Override
    public NetSocket write(String str, String enc, Handler<Void> doneHandler) {
        if (enc == null) {
            this.write(str, enc);
        } else {
            this.addFuture(doneHandler, this.doWrite(ChannelBuffers.copiedBuffer((CharSequence)str, Charset.forName(enc))));
        }
        return this;
    }

    @Override
    public void dataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
    }

    @Override
    public void endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
    }

    @Override
    public void drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        this.vertx.runOnLoop(new SimpleHandler(){

            @Override
            public void handle() {
                DefaultNetSocket.this.callDrainHandler();
            }
        });
    }

    @Override
    public void sendFile(String filename) {
        File f = new File(PathAdjuster.adjust(this.vertx, filename));
        super.sendFile(f);
    }

    @Override
    protected Context getContext() {
        return super.getContext();
    }

    @Override
    protected void handleClosed() {
        this.setContext();
        if (this.endHandler != null) {
            try {
                this.endHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
        super.handleClosed();
        if (this.vertx.eventBus() != null) {
            this.vertx.eventBus().unregisterHandler(this.writeHandlerID, this.writeHandler);
        }
    }

    void handleInterestedOpsChanged() {
        this.setContext();
        this.callDrainHandler();
    }

    void handleDataReceived(Buffer data) {
        if (this.dataHandler != null) {
            this.setContext();
            try {
                this.dataHandler.handle(data);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    void internalClose() {
        this.channel.close();
    }

    private ChannelFuture doWrite(ChannelBuffer buff) {
        return this.channel.write(buff);
    }

    private void callDrainHandler() {
        if (this.drainHandler != null && this.channel.isWritable()) {
            try {
                this.drainHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }
}

