/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class TCPSSLHelper {
    private static final Logger log = LoggerFactory.getLogger(TCPSSLHelper.class);
    private boolean ssl;
    private boolean verifyHost = true;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean trustAll;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private Boolean tcpNoDelay = true;
    private Integer tcpSendBufferSize;
    private Integer tcpReceiveBufferSize;
    private Boolean tcpKeepAlive = true;
    private Boolean reuseAddress;
    private Boolean soLinger;
    private Integer trafficClass;
    private Integer acceptBackLog;
    private Long connectTimeout;
    private Integer clientBossThreads;
    private SSLContext sslContext;

    public void checkSSL(VertxInternal vertx) {
        if (this.ssl) {
            this.sslContext = this.createContext(vertx, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword, this.trustAll);
        }
    }

    public void runOnCorrectThread(NioSocketChannel nch, Runnable runnable) {
        nch.getWorker().executeInIoThread(runnable, false);
    }

    public Map<String, Object> generateConnectionOptions(boolean server) {
        String prefix;
        HashMap<String, Object> options = new HashMap<String, Object>();
        String string = prefix = server ? "child." : "";
        if (this.tcpNoDelay != null) {
            options.put(prefix + "tcpNoDelay", this.tcpNoDelay);
        }
        if (this.tcpSendBufferSize != null) {
            options.put(prefix + "sendBufferSize", this.tcpSendBufferSize);
        }
        if (this.tcpReceiveBufferSize != null) {
            options.put(prefix + "receiveBufferSize", this.tcpReceiveBufferSize);
            options.put(prefix + "receiveBufferSizePredictor", new FixedReceiveBufferSizePredictor(1024));
        }
        if (this.soLinger != null) {
            options.put(prefix + "soLinger", this.soLinger);
        }
        if (this.trafficClass != null) {
            options.put(prefix + "trafficClass", this.trafficClass);
        }
        if (server) {
            if (this.reuseAddress != null) {
                options.put("reuseAddress", this.reuseAddress);
            }
            if (this.acceptBackLog != null) {
                options.put("backlog", this.acceptBackLog);
            }
        }
        if (!server && this.connectTimeout != null) {
            options.put("connectTimeoutMillis", this.connectTimeout);
        }
        return options;
    }

    public Boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public Integer getSendBufferSize() {
        return this.tcpSendBufferSize;
    }

    public Integer getReceiveBufferSize() {
        return this.tcpReceiveBufferSize;
    }

    public Boolean isTCPKeepAlive() {
        return this.tcpKeepAlive;
    }

    public Boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public Boolean isSoLinger() {
        return this.soLinger;
    }

    public Integer getTrafficClass() {
        return this.trafficClass;
    }

    public Integer getClientBossThreads() {
        return this.clientBossThreads;
    }

    public void setTCPNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setSendBufferSize(Integer size) {
        if (size < 1) {
            throw new IllegalArgumentException("TCP send buffer size must be >= 1");
        }
        this.tcpSendBufferSize = size;
    }

    public void setReceiveBufferSize(Integer size) {
        if (size < 1) {
            throw new IllegalArgumentException("TCP receive buffer size must be >= 1");
        }
        this.tcpReceiveBufferSize = size;
    }

    public void setTCPKeepAlive(Boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
    }

    public void setReuseAddress(Boolean reuse) {
        this.reuseAddress = reuse;
    }

    public void setSoLinger(Boolean linger) {
        this.soLinger = linger;
    }

    public void setTrafficClass(Integer trafficClass) {
        this.trafficClass = trafficClass;
    }

    public void setClientBossThreads(Integer clientBossThreads) {
        if (clientBossThreads < 1) {
            throw new IllegalArgumentException("clientBossThreads must be >= 1");
        }
        this.clientBossThreads = clientBossThreads;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public void setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    public void setKeyStorePath(String path) {
        this.keyStorePath = path;
    }

    public void setKeyStorePassword(String pwd) {
        this.keyStorePassword = pwd;
    }

    public void setTrustStorePath(String path) {
        this.trustStorePath = path;
    }

    public void setTrustStorePassword(String pwd) {
        this.trustStorePassword = pwd;
    }

    public void setClientAuthRequired(boolean required) {
        this.clientAuth = required ? ClientAuth.REQUIRED : ClientAuth.NONE;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public Integer getAcceptBacklog() {
        return this.acceptBackLog;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        if (connectTimeout < 0L) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = connectTimeout;
    }

    public void setAcceptBacklog(Integer acceptBackLog) {
        if (acceptBackLog < 0) {
            throw new IllegalArgumentException("acceptBackLog must be >= 0");
        }
        this.acceptBackLog = acceptBackLog;
    }

    public SSLContext createContext(VertxInternal vertx, String ksPath, String ksPassword, String tsPath, String tsPassword, boolean trustAll) {
        try {
            KeyManager[] keyMgrs;
            SSLContext context = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = keyMgrs = ksPath == null ? null : this.getKeyMgrs(vertx, ksPath, ksPassword);
            TrustManager[] trustMgrs = trustAll ? new TrustManager[]{this.createTrustAllTrustManager()} : (tsPath == null ? null : this.getTrustMgrs(vertx, tsPath, tsPassword));
            context.init(keyMgrs, trustMgrs, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            log.error("Failed to create context", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private TrustManager[] getTrustMgrs(VertxInternal vertx, String tsPath, String tsPassword) throws Exception {
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ts = this.loadStore(vertx, tsPath, tsPassword);
        fact.init(ts);
        return fact.getTrustManagers();
    }

    private KeyManager[] getKeyMgrs(VertxInternal vertx, String ksPath, String ksPassword) throws Exception {
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = this.loadStore(vertx, ksPath, ksPassword);
        fact.init(ks, ksPassword != null ? ksPassword.toCharArray() : null);
        return fact.getKeyManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadStore(VertxInternal vertx, String path, String ksPassword) throws Exception {
        String ksPath = PathAdjuster.adjust(vertx, path);
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream in = null;
        try {
            in = new FileInputStream(new File(ksPath));
            ks.load(in, ksPassword != null ? ksPassword.toCharArray() : null);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        return ks;
    }

    public static enum ClientAuth {
        NONE,
        REQUEST,
        REQUIRED;

    }
}

