/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class VertxWorkerPool
implements WorkerPool<NioWorker> {
    private static final Logger log = LoggerFactory.getLogger(VertxWorkerPool.class);
    private int pos;
    private List<WorkerHolder> workers = new ArrayList<WorkerHolder>();

    @Override
    public synchronized NioWorker nextWorker() {
        if (this.workers.isEmpty()) {
            return null;
        }
        NioWorker worker = this.workers.get((int)this.pos).worker;
        ++this.pos;
        this.checkPos();
        return worker;
    }

    public synchronized void addWorker(NioWorker worker) {
        WorkerHolder holder = this.findHolder(worker);
        if (holder == null) {
            this.workers.add(new WorkerHolder(worker));
        } else {
            ++holder.count;
        }
    }

    private WorkerHolder findHolder(NioWorker worker) {
        WorkerHolder wh = new WorkerHolder(worker);
        for (WorkerHolder holder : this.workers) {
            if (!holder.equals(wh)) continue;
            return holder;
        }
        return null;
    }

    public synchronized void removeWorker(NioWorker worker) {
        WorkerHolder holder = this.findHolder(worker);
        if (holder != null) {
            --holder.count;
            if (holder.count == 0) {
                this.workers.remove(holder);
            }
        } else {
            throw new IllegalStateException("Can't find worker to remove");
        }
        this.checkPos();
    }

    public synchronized int workerCount() {
        return this.workers.size();
    }

    private void checkPos() {
        if (this.pos == this.workers.size()) {
            this.pos = 0;
        }
    }

    private static class WorkerHolder {
        int count = 1;
        final NioWorker worker;

        WorkerHolder(NioWorker worker) {
            this.worker = worker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkerHolder that = (WorkerHolder)o;
            return !(this.worker != null ? !this.worker.equals(that.worker) : that.worker != null);
        }

        public int hashCode() {
            return this.worker != null ? this.worker.hashCode() : 0;
        }
    }
}

