/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.SimpleHandler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;

public class EventBusBridge
implements Handler<SockJSSocket> {
    private static final Logger log = LoggerFactory.getLogger(EventBusBridge.class);
    private static final String DEFAULT_AUTH_ADDRESS = "vertx.basicauthmanager.authorise";
    private static final long DEFAULT_AUTH_TIMEOUT = 300000L;
    private static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private final Map<String, Auth> authCache = new HashMap<String, Auth>();
    private final Map<SockJSSocket, Set<String>> sockAuths = new HashMap<SockJSSocket, Set<String>>();
    private final List<JsonObject> inboundPermitted;
    private final List<JsonObject> outboundPermitted;
    private final long authTimeout;
    private final String authAddress;
    private final Vertx vertx;
    private final EventBus eb;
    private Set<String> acceptedReplyAddresses = new HashSet<String>();
    private Map<String, Pattern> compiledREs = new HashMap<String, Pattern>();

    private List<JsonObject> convertArray(JsonArray permitted) {
        ArrayList<JsonObject> l = new ArrayList<JsonObject>();
        for (Object elem : permitted) {
            if (!(elem instanceof JsonObject)) {
                throw new IllegalArgumentException("Permitted must only contain JsonObject");
            }
            l.add((JsonObject)elem);
        }
        return l;
    }

    public EventBusBridge(Vertx vertx, JsonArray inboundPermitted, JsonArray outboundPermitted) {
        this(vertx, inboundPermitted, outboundPermitted, 300000L, null);
    }

    public EventBusBridge(Vertx vertx, JsonArray inboundPermitted, JsonArray outboundPermitted, long authTimeout) {
        this(vertx, inboundPermitted, outboundPermitted, authTimeout, null);
    }

    public EventBusBridge(Vertx vertx, JsonArray inboundPermitted, JsonArray outboundPermitted, long authTimeout, String authAddress) {
        this.vertx = vertx;
        this.eb = vertx.eventBus();
        this.inboundPermitted = this.convertArray(inboundPermitted);
        this.outboundPermitted = this.convertArray(outboundPermitted);
        if (authTimeout < 0L) {
            throw new IllegalArgumentException("authTimeout < 0");
        }
        this.authTimeout = authTimeout;
        if (authAddress == null) {
            authAddress = DEFAULT_AUTH_ADDRESS;
        }
        this.authAddress = authAddress;
    }

    private void handleSocketClosed(SockJSSocket sock, Map<String, Handler<Message<JsonObject>>> handlers) {
        for (Map.Entry<String, Handler<Message<JsonObject>>> entry : handlers.entrySet()) {
            this.handleUnregister(sock, entry.getKey());
            this.eb.unregisterHandler(entry.getKey(), entry.getValue());
        }
        Set<String> auths = this.sockAuths.remove(sock);
        if (auths != null) {
            for (String sessionID : auths) {
                Auth auth = this.authCache.remove(sessionID);
                if (auth == null) continue;
                auth.cancel();
            }
        }
        this.handleSocketClosed(sock);
    }

    private void handleSocketData(SockJSSocket sock, Buffer data, Map<String, Handler<Message<JsonObject>>> handlers) {
        JsonObject msg = new JsonObject(data.toString());
        String type = this.getMandatoryString(msg, "type");
        String address = this.getMandatoryString(msg, "address");
        switch (type) {
            case "send": {
                this.internalHandleSendOrPub(sock, true, msg, address);
                break;
            }
            case "publish": {
                this.internalHandleSendOrPub(sock, false, msg, address);
                break;
            }
            case "register": {
                this.internalHandleRegister(sock, address, handlers);
                break;
            }
            case "unregister": {
                this.internalHandleUnregister(sock, address, handlers);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + type);
            }
        }
    }

    private void internalHandleSendOrPub(SockJSSocket sock, boolean send, JsonObject msg, String address) {
        if (this.handleSendOrPub(sock, send, msg, address)) {
            JsonObject body = this.getMandatoryObject(msg, "body");
            String replyAddress = msg.getString("replyAddress");
            this.doSendOrPub(send, sock, address, body, replyAddress);
        }
    }

    private void internalHandleRegister(final SockJSSocket sock, final String address, Map<String, Handler<Message<JsonObject>>> handlers) {
        if (this.handleRegister(sock, address)) {
            Handler<Message<JsonObject>> handler = new Handler<Message<JsonObject>>(){

                @Override
                public void handle(Message<JsonObject> msg) {
                    Match curMatch = EventBusBridge.this.checkMatches(false, address, (JsonObject)msg.body);
                    if (curMatch.doesMatch) {
                        if (curMatch.requiresAuth && EventBusBridge.this.sockAuths.get(sock) == null) {
                            log.debug("Outbound message for address " + address + " rejected because auth is required and socket is not authed");
                        } else {
                            EventBusBridge.this.checkAddAccceptedReplyAddress(msg.replyAddress);
                            EventBusBridge.this.deliverMessage(sock, address, msg);
                        }
                    } else {
                        log.debug("Outbound message for address " + address + " rejected because there is no inbound match");
                    }
                }
            };
            handlers.put(address, handler);
            this.eb.registerHandler(address, (Handler<? extends Message>)handler);
        }
    }

    private void internalHandleUnregister(SockJSSocket sock, String address, Map<String, Handler<Message<JsonObject>>> handlers) {
        Handler<Message<JsonObject>> handler;
        if (this.handleUnregister(sock, address) && (handler = handlers.remove(address)) != null) {
            this.eb.unregisterHandler(address, handler);
        }
    }

    @Override
    public void handle(final SockJSSocket sock) {
        final HashMap handlers = new HashMap();
        sock.endHandler(new SimpleHandler(){

            @Override
            public void handle() {
                EventBusBridge.this.handleSocketClosed(sock, handlers);
            }
        });
        sock.dataHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer data) {
                EventBusBridge.this.handleSocketData(sock, data, handlers);
            }
        });
    }

    private void checkAddAccceptedReplyAddress(final String replyAddress) {
        if (replyAddress != null) {
            this.acceptedReplyAddresses.add(replyAddress);
            this.vertx.setTimer(30000L, new Handler<Long>(){

                @Override
                public void handle(Long id) {
                    EventBusBridge.this.acceptedReplyAddresses.remove(replyAddress);
                }
            });
        }
    }

    private String getMandatoryString(JsonObject json, String field) {
        String value = json.getString(field);
        if (value == null) {
            throw new IllegalStateException(field + " must be specified for message");
        }
        return value;
    }

    private JsonObject getMandatoryObject(JsonObject json, String field) {
        JsonObject value = json.getObject(field);
        if (value == null) {
            throw new IllegalStateException(field + " must be specified for message");
        }
        return value;
    }

    private void deliverMessage(SockJSSocket sock, String address, Message<JsonObject> jsonMessage) {
        JsonObject envelope = new JsonObject().putString("address", address).putObject("body", (JsonObject)jsonMessage.body);
        if (jsonMessage.replyAddress != null) {
            envelope.putString("replyAddress", jsonMessage.replyAddress);
        }
        sock.writeBuffer(new Buffer(envelope.encode()));
    }

    private void doSendOrPub(final boolean send, final SockJSSocket sock, final String address, final JsonObject jsonObject, final String replyAddress) {
        if (log.isDebugEnabled()) {
            log.debug("Received msg from client in bridge. address:" + address + " message:" + jsonObject.encode());
        }
        Match curMatch = this.checkMatches(true, address, jsonObject);
        if (curMatch.doesMatch) {
            if (curMatch.requiresAuth) {
                final String sessionID = jsonObject.getString("sessionID");
                if (sessionID != null) {
                    this.authorise(jsonObject, sessionID, new AsyncResultHandler<Boolean>(){

                        @Override
                        public void handle(AsyncResult<Boolean> res) {
                            if (res.succeeded()) {
                                if (((Boolean)res.result).booleanValue()) {
                                    EventBusBridge.this.cacheAuthorisation(sessionID, sock);
                                    EventBusBridge.this.checkAndSend(send, address, jsonObject, sock, replyAddress);
                                } else {
                                    log.debug("Inbound message for address " + address + " rejected because sessionID is not authorised");
                                }
                            } else {
                                log.error("Error in performing authorisation", res.exception);
                            }
                        }
                    });
                } else {
                    log.debug("Inbound message for address " + address + " rejected because it requires auth and sessionID is missing");
                }
            } else {
                this.checkAndSend(send, address, jsonObject, sock, replyAddress);
            }
        } else {
            log.debug("Inbound message for address " + address + " rejected because there is no match");
        }
    }

    private void checkAndSend(boolean send, String address, JsonObject jsonObject, final SockJSSocket sock, final String replyAddress) {
        Handler<Message<JsonObject>> replyHandler = replyAddress != null ? new Handler<Message<JsonObject>>(){

            @Override
            public void handle(Message<JsonObject> message) {
                EventBusBridge.this.checkAddAccceptedReplyAddress(message.replyAddress);
                EventBusBridge.this.deliverMessage(sock, replyAddress, message);
            }
        } : null;
        if (log.isDebugEnabled()) {
            log.debug("Forwarding message to address " + address + " on event bus");
        }
        if (send) {
            this.eb.send(address, jsonObject, replyHandler);
        } else {
            this.eb.publish(address, jsonObject);
        }
    }

    private void authorise(JsonObject message, String sessionID, final AsyncResultHandler<Boolean> handler) {
        if (this.authCache.containsKey(sessionID)) {
            handler.handle(new AsyncResult<Boolean>(true));
        } else {
            this.eb.send(this.authAddress, message, new Handler<Message<JsonObject>>(){

                @Override
                public void handle(Message<JsonObject> reply) {
                    boolean authed = ((JsonObject)reply.body).getString("status").equals("ok");
                    handler.handle(new AsyncResult<Boolean>(authed));
                }
            });
        }
    }

    private Match checkMatches(boolean inbound, String address, JsonObject message) {
        if (inbound && this.acceptedReplyAddresses.remove(address)) {
            return new Match(true, false);
        }
        List<JsonObject> matches = inbound ? this.inboundPermitted : this.outboundPermitted;
        for (JsonObject matchHolder : matches) {
            String matchAddress = matchHolder.getString("address");
            String matchRegex = matchAddress == null ? matchHolder.getString("address_re") : null;
            boolean addressOK = matchAddress == null ? (matchRegex == null ? true : this.regexMatches(matchRegex, address)) : matchAddress.equals(address);
            if (!addressOK) continue;
            boolean matched = true;
            JsonObject match = matchHolder.getObject("match");
            if (match != null) {
                for (String fieldName : match.getFieldNames()) {
                    if (match.getField(fieldName).equals(message.getField(fieldName))) continue;
                    matched = false;
                    break;
                }
            }
            if (!matched) continue;
            Boolean b = matchHolder.getBoolean("requires_auth");
            return new Match(true, b != null && b != false);
        }
        return new Match(false, false);
    }

    private boolean regexMatches(String matchRegex, String address) {
        Pattern pattern = this.compiledREs.get(matchRegex);
        if (pattern == null) {
            pattern = Pattern.compile(matchRegex);
            this.compiledREs.put(matchRegex, pattern);
        }
        Matcher m = pattern.matcher(address);
        return m.matches();
    }

    private void cacheAuthorisation(String sessionID, SockJSSocket sock) {
        this.authCache.put(sessionID, new Auth(sessionID, sock));
        Set<String> sesss = this.sockAuths.get(sock);
        if (sesss == null) {
            sesss = new HashSet<String>();
            this.sockAuths.put(sock, sesss);
        }
        sesss.add(sessionID);
    }

    private void uncacheAuthorisation(String sessionID, SockJSSocket sock) {
        this.authCache.remove(sessionID);
        Set<String> sess = this.sockAuths.get(sock);
        if (sess != null) {
            sess.remove(sessionID);
            if (sess.isEmpty()) {
                this.sockAuths.remove(sock);
            }
        }
    }

    protected void handleSocketClosed(SockJSSocket sock) {
    }

    protected boolean handleSendOrPub(SockJSSocket sock, boolean send, JsonObject msg, String address) {
        return true;
    }

    protected boolean handleRegister(SockJSSocket sock, String address) {
        return true;
    }

    protected boolean handleUnregister(SockJSSocket sock, String address) {
        return true;
    }

    private class Auth {
        private final long timerID;

        Auth(final String sessionID, final SockJSSocket sock) {
            this.timerID = EventBusBridge.this.vertx.setTimer(EventBusBridge.this.authTimeout, new Handler<Long>(){

                @Override
                public void handle(Long id) {
                    EventBusBridge.this.uncacheAuthorisation(sessionID, sock);
                }
            });
        }

        void cancel() {
            EventBusBridge.this.vertx.cancelTimer(this.timerID);
        }
    }

    private class Match {
        public final boolean doesMatch;
        public final boolean requiresAuth;

        Match(boolean doesMatch, boolean requiresAuth) {
            this.doesMatch = doesMatch;
            this.requiresAuth = requiresAuth;
        }
    }
}

