/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public abstract class SockJSSocket
implements ReadStream,
WriteStream {
    private final Handler<Message<Buffer>> writeHandler;
    protected final Vertx vertx;
    public final String writeHandlerID;
    public static AtomicInteger cnt = new AtomicInteger();

    protected SockJSSocket(Vertx vertx) {
        this.vertx = vertx;
        this.writeHandler = new Handler<Message<Buffer>>(){

            @Override
            public void handle(Message<Buffer> buff) {
                SockJSSocket.this.writeBuffer((Buffer)buff.body);
            }
        };
        this.writeHandlerID = UUID.randomUUID().toString();
        vertx.eventBus().registerLocalHandler(this.writeHandlerID, this.writeHandler);
        cnt.incrementAndGet();
    }

    public void close() {
        this.vertx.eventBus().unregisterHandler(this.writeHandlerID, this.writeHandler);
    }

    protected void finalize() throws Throwable {
        cnt.decrementAndGet();
        super.finalize();
    }
}

