/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.util.Map;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.BaseTransport;
import org.vertx.java.core.sockjs.impl.Session;

class HtmlFileTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(HtmlFileTransport.class);
    private static final String HTML_FILE_TEMPLATE;

    HtmlFileTransport(VertxInternal vertx, RouteMatcher rm, String basePath, Map<String, Session> sessions, final JsonObject config, final Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, config);
        String htmlFileRE = basePath + "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/" + "htmlfile";
        rm.getWithRegEx(htmlFileRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                String callback;
                if (log.isTraceEnabled()) {
                    log.trace("HtmlFile, get: " + req.uri);
                }
                if ((callback = req.params().get("callback")) == null && (callback = req.params().get("c")) == null) {
                    req.response.statusCode = 500;
                    req.response.end("\"callback\" parameter required\n");
                    return;
                }
                String sessionID = req.params().get("param0");
                Session session = HtmlFileTransport.this.getSession(config.getLong("session_timeout"), config.getLong("heartbeat_period"), sessionID, sockHandler);
                session.register(new HtmlFileListener(config.getInteger("max_bytes_streaming"), req, callback, session));
            }
        });
    }

    static {
        String str = "<!doctype html>\n<html><head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n</head><body><h2>Don't panic!</h2>\n  <script>\n    document.domain = document.domain;\n    var c = parent.{{ callback }};\n    c.start();\n    function p(d) {c.message(d);};\n    window.onload = function() {c.stop();};\n  </script>";
        String str2 = str.replace("{{ callback }}", "");
        StringBuilder sb = new StringBuilder(str);
        int extra = 1024 - str2.length();
        for (int i = 0; i < extra; ++i) {
            sb.append(' ');
        }
        sb.append("\r\n");
        HTML_FILE_TEMPLATE = sb.toString();
    }

    private class HtmlFileListener
    extends BaseTransport.BaseListener {
        final int maxBytesStreaming;
        final HttpServerRequest req;
        final String callback;
        final Session session;
        boolean headersWritten;
        int bytesSent;
        boolean closed;

        HtmlFileListener(int maxBytesStreaming, HttpServerRequest req, String callback, Session session) {
            this.maxBytesStreaming = maxBytesStreaming;
            this.req = req;
            this.callback = callback;
            this.session = session;
            this.addCloseHandler(req.response, session);
        }

        @Override
        public void sendFrame(String body) {
            if (log.isTraceEnabled()) {
                log.trace("HtmlFile, sending frame");
            }
            if (!this.headersWritten) {
                String htmlFile = HTML_FILE_TEMPLATE.replace("{{ callback }}", this.callback);
                this.req.response.headers().put("Content-Type", "text/html; charset=UTF-8");
                this.req.response.headers().put("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
                this.req.response.setChunked(true);
                BaseTransport.setJSESSIONID(HtmlFileTransport.this.config, this.req);
                this.req.response.write(htmlFile);
                this.headersWritten = true;
            }
            body = HtmlFileTransport.this.escapeForJavaScript(body);
            StringBuilder sb = new StringBuilder();
            sb.append("<script>\np(\"");
            sb.append(body);
            sb.append("\");\n</script>\r\n");
            Buffer buff = new Buffer(sb.toString());
            this.req.response.write(buff);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                if (log.isTraceEnabled()) {
                    log.trace("More than maxBytes sent so closing connection");
                }
                this.close();
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener(false);
                    this.req.response.end();
                    this.req.response.close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

