/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.http.WebSocket;
import org.vertx.java.core.http.impl.WebSocketMatcher;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.WebSocketTransport;

class RawWebSocketTransport {
    private static final Logger log = LoggerFactory.getLogger(WebSocketTransport.class);

    RawWebSocketTransport(final Vertx vertx, WebSocketMatcher wsMatcher, RouteMatcher rm, String basePath, final Handler<SockJSSocket> sockHandler) {
        String wsRE = basePath + "/websocket";
        wsMatcher.addRegEx(wsRE, new Handler<WebSocketMatcher.Match>(){

            @Override
            public void handle(WebSocketMatcher.Match match) {
                RawWSSockJSSocket sock = new RawWSSockJSSocket(vertx, match.ws);
                sockHandler.handle(sock);
            }
        });
        rm.getWithRegEx(wsRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest request) {
                request.response.statusCode = 400;
                request.response.end("Can \"Upgrade\" only to \"WebSocket\".");
            }
        });
        rm.allWithRegEx(wsRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest request) {
                request.response.headers().put("Allow", "GET");
                request.response.statusCode = 405;
                request.response.end();
            }
        });
    }

    private class RawWSSockJSSocket
    extends SockJSSocket {
        private WebSocket ws;

        RawWSSockJSSocket(Vertx vertx, WebSocket ws) {
            super(vertx);
            this.ws = ws;
        }

        @Override
        public void dataHandler(Handler<Buffer> handler) {
            this.ws.dataHandler(handler);
        }

        @Override
        public void pause() {
            this.ws.pause();
        }

        @Override
        public void resume() {
            this.ws.resume();
        }

        @Override
        public void writeBuffer(Buffer data) {
            this.ws.writeBuffer(data);
        }

        @Override
        public void setWriteQueueMaxSize(int maxQueueSize) {
            this.ws.setWriteQueueMaxSize(maxQueueSize);
        }

        @Override
        public boolean writeQueueFull() {
            return this.ws.writeQueueFull();
        }

        @Override
        public void drainHandler(Handler<Void> handler) {
            this.ws.drainHandler(handler);
        }

        @Override
        public void exceptionHandler(Handler<Exception> handler) {
            this.ws.exceptionHandler(handler);
        }

        @Override
        public void endHandler(Handler<Void> endHandler) {
            this.ws.endHandler(endHandler);
        }

        @Override
        public void close() {
            super.close();
            this.ws.close();
        }
    }
}

