/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.deploy.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.SimpleHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.impl.BlockingAction;
import org.vertx.java.core.impl.Context;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.DecodeException;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.deploy.Container;
import org.vertx.java.deploy.Verticle;
import org.vertx.java.deploy.impl.CountingCompletionHandler;
import org.vertx.java.deploy.impl.Deployment;
import org.vertx.java.deploy.impl.ModuleReloader;
import org.vertx.java.deploy.impl.ParentLastURLClassLoader;
import org.vertx.java.deploy.impl.Redeployer;
import org.vertx.java.deploy.impl.VerticleFactory;
import org.vertx.java.deploy.impl.VerticleHolder;
import org.vertx.java.deploy.impl.VertxLocator;

public class VerticleManager
implements ModuleReloader {
    private static final Logger log = LoggerFactory.getLogger(VerticleManager.class);
    private static final String REPO_URI_ROOT = "/vertx-mods/mods/";
    private static final String DEFAULT_REPO_HOST = "vert-x.github.com";
    private static final int BUFFER_SIZE = 4096;
    private static final String HTTP_PROXY_HOST_PROP_NAME = "http.proxyHost";
    private static final String HTTP_PROXY_PORT_PROP_NAME = "http.proxyPort";
    private static final String COLON = ":";
    private final VertxInternal vertx;
    private final Map<String, Deployment> deployments = new ConcurrentHashMap<String, Deployment>();
    private final File modRoot;
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private Map<String, String> factoryNames = new HashMap<String, String>();
    private final String repoHost;
    private final int repoPort;
    private final String proxyHost;
    private final int proxyPort;
    private final Redeployer redeployer;

    public VerticleManager(VertxInternal vertx) {
        this(vertx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerticleManager(VertxInternal vertx, String repo) {
        this.vertx = vertx;
        if (repo != null) {
            if (repo.contains(COLON)) {
                this.repoHost = repo.substring(0, repo.indexOf(COLON));
                this.repoPort = Integer.parseInt(repo.substring(repo.indexOf(COLON) + 1));
            } else {
                this.repoHost = repo;
                this.repoPort = 80;
            }
        } else {
            this.repoHost = DEFAULT_REPO_HOST;
            this.repoPort = 80;
        }
        this.proxyHost = System.getProperty(HTTP_PROXY_HOST_PROP_NAME);
        String tmpPort = System.getProperty(HTTP_PROXY_PORT_PROP_NAME);
        this.proxyPort = tmpPort != null ? Integer.parseInt(tmpPort) : 80;
        VertxLocator.vertx = vertx;
        VertxLocator.container = new Container(this);
        String modDir = System.getProperty("vertx.mods");
        this.modRoot = modDir != null && !modDir.trim().equals("") ? new File(modDir) : new File("mods");
        this.redeployer = new Redeployer(vertx, this.modRoot, this);
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("langs.properties");
            if (is == null) {
                log.warn("No language mappings found!");
            } else {
                Properties props = new Properties();
                props.load(new BufferedInputStream(is));
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String propName = (String)en.nextElement();
                    this.factoryNames.put(propName, props.getProperty(propName));
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to load langs.properties: " + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public void block() {
        while (true) {
            try {
                this.stopLatch.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void unblock() {
        this.stopLatch.countDown();
    }

    public JsonObject getConfig() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.config;
    }

    public String getDeploymentName() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.name;
    }

    public URL[] getDeploymentURLs() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.urls;
    }

    public File getDeploymentModDir() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.modDir;
    }

    public Logger getLogger() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.logger;
    }

    public void deployVerticle(final boolean worker, final String main, final JsonObject config, final URL[] urls, final int instances, final File currentModDir, final String includes, final Handler<String> doneHandler) {
        BlockingAction<Void> deployModuleAction = new BlockingAction<Void>(this.vertx, null){

            @Override
            public Void action() throws Exception {
                VerticleManager.this.doDeployVerticle(worker, main, config, urls, instances, currentModDir, includes, VerticleManager.this.wrapDoneHandler(doneHandler));
                return null;
            }
        };
        deployModuleAction.run();
    }

    private Handler<String> wrapDoneHandler(final Handler<String> doneHandler) {
        if (doneHandler == null) {
            return null;
        }
        final Context context = this.vertx.getContext();
        return new Handler<String>(){

            @Override
            public void handle(final String deploymentID) {
                if (context == null) {
                    doneHandler.handle(deploymentID);
                } else {
                    context.execute(new Runnable(){

                        @Override
                        public void run() {
                            doneHandler.handle(deploymentID);
                        }
                    });
                }
            }
        };
    }

    private void doDeployVerticle(boolean worker, String main, JsonObject config, URL[] urls, int instances, File currentModDir, String includes, Handler<String> doneHandler) {
        URL[] theURLs;
        this.checkWorkerContext();
        if (includes != null) {
            String[] includedMods = this.parseIncludes(includes, null);
            List<URL> includedURLs = new ArrayList<URL>(Arrays.asList(urls));
            for (String includedMod : includedMods) {
                JsonObject conf;
                File modDir = new File(this.modRoot, includedMod);
                while ((conf = this.loadModuleConfig(includedMod, modDir)) == null) {
                    if (this.doInstallMod(includedMod)) continue;
                    this.callDoneHandler(doneHandler, null);
                }
                HashMap<String, String> includedJars = new HashMap<String, String>();
                HashSet<String> includedModules = new HashSet<String>();
                includedURLs = this.processIncludes(main, includedURLs, includedMod, modDir, conf, includedJars, includedModules);
            }
            theURLs = includedURLs.toArray(new URL[includedURLs.size()]);
        } else {
            theURLs = urls;
        }
        this.doDeploy(null, false, worker, main, null, config, theURLs, instances, currentModDir, doneHandler);
    }

    public synchronized void undeployAll(Handler<Void> doneHandler) {
        final CountingCompletionHandler count = new CountingCompletionHandler(this.vertx.getOrAssignContext());
        if (!this.deployments.isEmpty()) {
            while (!this.deployments.isEmpty()) {
                String name = this.deployments.keySet().iterator().next();
                count.incRequired();
                this.undeploy(name, new SimpleHandler(){

                    @Override
                    public void handle() {
                        count.complete();
                    }
                });
            }
        }
        count.setHandler(doneHandler);
    }

    public synchronized Map<String, Integer> listInstances() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry<String, Deployment> entry : this.deployments.entrySet()) {
            map.put(entry.getKey(), entry.getValue().verticles.size());
        }
        return map;
    }

    public void deployMod(final String modName, final JsonObject config, final int instances, final File currentModDir, final Handler<String> doneHandler) {
        BlockingAction<Void> deployModuleAction = new BlockingAction<Void>(this.vertx, null){

            @Override
            public Void action() throws Exception {
                VerticleManager.this.doDeployMod(false, null, modName, config, instances, currentModDir, VerticleManager.this.wrapDoneHandler(doneHandler));
                return null;
            }
        };
        deployModuleAction.run();
    }

    public void installMod(final String moduleName) {
        final CountDownLatch latch = new CountDownLatch(1);
        AsyncResultHandler<Void> handler = new AsyncResultHandler<Void>(){

            @Override
            public void handle(AsyncResult<Void> res) {
                if (res.succeeded()) {
                    latch.countDown();
                } else {
                    res.exception.printStackTrace();
                }
            }
        };
        BlockingAction<Void> deployModuleAction = new BlockingAction<Void>(this.vertx, (AsyncResultHandler)handler){

            @Override
            public Void action() throws Exception {
                VerticleManager.this.doInstallMod(moduleName);
                return null;
            }
        };
        deployModuleAction.run();
        while (true) {
            try {
                if (!latch.await(30L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Timed out waiting to install module");
                }
            }
            catch (InterruptedException ignore) {
                continue;
            }
            break;
        }
    }

    public void uninstallMod(String moduleName) {
        log.info("Uninstalling module " + moduleName + " from directory " + this.modRoot);
        File modDir = new File(this.modRoot, moduleName);
        if (!modDir.exists()) {
            log.error("Cannot find module to uninstall");
        } else {
            try {
                this.vertx.fileSystem().deleteSync(modDir.getAbsolutePath(), true);
                log.info("Module " + moduleName + " successfully uninstalled");
            }
            catch (Exception e) {
                log.error("Failed to delete directory: " + e.getMessage());
            }
        }
    }

    private void checkWorkerContext() {
        Thread t = Thread.currentThread();
        if (!t.getName().startsWith("vert.x-worker-thread")) {
            throw new IllegalStateException("Not a worker thread");
        }
    }

    private void doDeployMod(final boolean redeploy, String depName, String modName, JsonObject config, int instances, File currentModDir, final Handler<String> doneHandler) {
        this.checkWorkerContext();
        File modDir = new File(this.modRoot, modName);
        JsonObject conf = this.loadModuleConfig(modName, modDir);
        if (conf != null) {
            Boolean preserveCwd;
            String main = conf.getString("main");
            if (main == null) {
                log.error("Runnable module " + modName + " mod.json must contain a \"main\" field");
                this.callDoneHandler(doneHandler, null);
                return;
            }
            Boolean worker = conf.getBoolean("worker");
            if (worker == null) {
                worker = Boolean.FALSE;
            }
            if ((preserveCwd = conf.getBoolean("preserve-cwd")) == null) {
                preserveCwd = Boolean.FALSE;
            }
            File modDirToUse = preserveCwd != false ? currentModDir : modDir;
            List<URL> urls = this.processIncludes(modName, new ArrayList<URL>(), modName, modDir, conf, new HashMap<String, String>(), new HashSet<String>());
            if (urls == null) {
                this.callDoneHandler(doneHandler, null);
                return;
            }
            Boolean ar = conf.getBoolean("auto-redeploy");
            final boolean autoRedeploy = ar == null ? false : ar;
            this.doDeploy(depName, autoRedeploy, worker, main, modName, config, urls.toArray(new URL[urls.size()]), instances, modDirToUse, new Handler<String>(){

                @Override
                public void handle(String deploymentID) {
                    if (deploymentID != null && !redeploy && autoRedeploy) {
                        VerticleManager.this.redeployer.moduleDeployed((Deployment)VerticleManager.this.deployments.get(deploymentID));
                    }
                    VerticleManager.this.callDoneHandler(doneHandler, deploymentID);
                }
            });
        } else if (this.doInstallMod(modName)) {
            this.doDeployMod(redeploy, depName, modName, config, instances, currentModDir, doneHandler);
        } else {
            this.callDoneHandler(doneHandler, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadModuleConfig(String modName, File modDir) {
        this.checkWorkerContext();
        if (!modDir.exists()) return null;
        try (Scanner scanner = new Scanner(new File(modDir, "mod.json")).useDelimiter("\\A");){
            JsonObject json;
            String conf;
            try {
                conf = scanner.next();
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("Module " + modName + " contains an empty mod.json file");
            }
            try {
                json = new JsonObject(conf);
            }
            catch (DecodeException e) {
                throw new IllegalStateException("Module " + modName + " mod.json contains invalid json");
            }
            JsonObject jsonObject = json;
            return jsonObject;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Module " + modName + " does not contain a mod.json file");
        }
    }

    private List<URL> processIncludes(String runModule, List<URL> urls, String modName, File modDir, JsonObject conf, Map<String, String> includedJars, Set<String> includedModules) {
        this.checkWorkerContext();
        try {
            urls.add(modDir.toURI().toURL());
            File libDir = new File(modDir, "lib");
            if (libDir.exists()) {
                File[] jars = libDir.listFiles();
                for (File jar : jars) {
                    URL jarURL = jar.toURI().toURL();
                    String sjarURL = jarURL.toString();
                    String jarName = sjarURL.substring(sjarURL.lastIndexOf("/") + 1);
                    String prevMod = includedJars.get(jarName);
                    if (prevMod != null) {
                        log.warn("Warning! jar file " + jarName + " is contained in module " + prevMod + " and also in module " + modName + " which are both included (perhaps indirectly) by module " + runModule);
                    }
                    includedJars.put(jarName, modName);
                    urls.add(jarURL);
                }
            }
        }
        catch (MalformedURLException e) {
            log.error("malformed url", e);
            return null;
        }
        includedModules.add(modName);
        String sincludes = conf.getString("includes");
        if (sincludes != null) {
            String[] sarr = this.parseIncludes(sincludes, modName);
            block3: for (String include : sarr) {
                if (includedModules.contains(include)) continue;
                File newmodDir = new File(this.modRoot, include);
                do {
                    JsonObject newconf;
                    if ((newconf = this.loadModuleConfig(include, newmodDir)) == null) continue;
                    if ((urls = this.processIncludes(runModule, urls, include, newmodDir, newconf, includedJars, includedModules)) != null) continue block3;
                    return null;
                } while (this.doInstallMod(include));
                return null;
            }
        }
        return urls;
    }

    private String[] parseIncludes(String sincludes, String modName) {
        if ("".equals(sincludes = sincludes.trim())) {
            log.error("Empty include string " + (modName != null ? " in module " : ""));
            return null;
        }
        String[] arr = sincludes.split(",");
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = arr[i].trim();
            }
        }
        return arr;
    }

    private boolean doInstallMod(final String moduleName) {
        this.checkWorkerContext();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference mod = new AtomicReference();
        HttpClient client = this.vertx.createHttpClient();
        if (this.proxyHost != null) {
            client.setHost(this.proxyHost);
            if (this.proxyPort != 80) {
                client.setPort(this.proxyPort);
            } else {
                client.setPort(80);
            }
        } else {
            client.setHost(this.repoHost);
            client.setPort(this.repoPort);
        }
        client.exceptionHandler(new Handler<Exception>(){

            @Override
            public void handle(Exception e) {
                log.error("Unable to connect to repository");
                latch.countDown();
            }
        });
        String uri = REPO_URI_ROOT + moduleName + "/mod.zip";
        String msg = "Attempting to install module " + moduleName + " from http://" + this.repoHost + COLON + this.repoPort + uri;
        if (this.proxyHost != null) {
            msg = msg + " Using proxy host " + this.proxyHost + COLON + this.proxyPort;
        }
        log.info(msg);
        if (this.proxyHost != null) {
            uri = new StringBuffer("http://").append(DEFAULT_REPO_HOST).append(uri).toString();
        }
        HttpClientRequest req = client.get(uri, new Handler<HttpClientResponse>(){

            @Override
            public void handle(HttpClientResponse resp) {
                if (resp.statusCode == 200) {
                    log.info("Downloading module...");
                    resp.bodyHandler(new Handler<Buffer>(){

                        @Override
                        public void handle(Buffer buffer) {
                            mod.set(buffer);
                            latch.countDown();
                        }
                    });
                } else if (resp.statusCode == 404) {
                    log.error("Can't find module " + moduleName + " in repository");
                    latch.countDown();
                } else {
                    log.error("Failed to download module: " + resp.statusCode);
                    latch.countDown();
                }
            }
        });
        if (this.proxyHost != null) {
            req.putHeader("host", this.proxyHost);
        } else {
            req.putHeader("host", this.repoHost);
        }
        req.putHeader("user-agent", "Vert.x Module Installer");
        req.end();
        while (true) {
            try {
                if (!latch.await(30L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Timed out waiting to download module");
                }
            }
            catch (InterruptedException ignore) {
                continue;
            }
            break;
        }
        Buffer modZipped = (Buffer)mod.get();
        if (modZipped != null) {
            return this.unzipModule(moduleName, modZipped);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unzipModule(String modName, Buffer data) {
        this.checkWorkerContext();
        String string = modName.intern();
        synchronized (string) {
            if (!this.modRoot.exists() && !this.modRoot.mkdir()) {
                log.error("Failed to create directory " + this.modRoot);
                return false;
            }
            log.info("Installing module into directory '" + this.modRoot + "'");
            File fdest = new File(this.modRoot, modName);
            if (fdest.exists()) {
                return true;
            }
            try {
                ZipEntry entry;
                ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
                while ((entry = zis.getNextEntry()) != null) {
                    if (!entry.getName().startsWith(modName)) {
                        log.error("Module must contain zipped directory with same name as module");
                        fdest.delete();
                        return false;
                    }
                    if (entry.isDirectory()) {
                        new File(this.modRoot, entry.getName()).mkdir();
                        continue;
                    }
                    byte[] buff = new byte[4096];
                    FilterOutputStream dest = null;
                    try {
                        int count;
                        FileOutputStream fos = new FileOutputStream(new File(this.modRoot, entry.getName()));
                        dest = new BufferedOutputStream(fos, 4096);
                        while ((count = zis.read(buff, 0, 4096)) != -1) {
                            ((BufferedOutputStream)dest).write(buff, 0, count);
                        }
                        ((BufferedOutputStream)dest).flush();
                    }
                    finally {
                        if (dest == null) continue;
                        dest.close();
                    }
                }
                zis.close();
            }
            catch (IOException e) {
                log.error("Failed to unzip module", e);
                return false;
            }
            log.info("Module " + modName + " successfully installed");
            return true;
        }
    }

    private void setPathAdjustment(File modDir) {
        Path cwd = Paths.get(".", new String[0]).toAbsolutePath().getParent();
        Path pmodDir = Paths.get(modDir.getAbsolutePath(), new String[0]);
        Path relative = cwd.relativize(pmodDir);
        this.vertx.getContext().setPathAdjustment(relative);
    }

    private void callDoneHandler(Handler<String> doneHandler, String deploymentID) {
        if (doneHandler != null) {
            doneHandler.handle(deploymentID);
        }
    }

    private void doDeploy(String depName, boolean autoRedeploy, boolean worker, final String main, String modName, JsonObject config, URL[] urls, int instances, final File modDir, final Handler<String> doneHandler) {
        this.checkWorkerContext();
        CountDownLatch latch = new CountDownLatch(1);
        final String deploymentName = depName != null ? depName : "deployment-" + UUID.randomUUID().toString();
        log.debug("Deploying name : " + deploymentName + " main: " + main + " instances: " + instances);
        int dotIndex = main.lastIndexOf(46);
        String extension = dotIndex > -1 ? main.substring(dotIndex + 1) : null;
        String factoryName = null;
        if (extension != null) {
            factoryName = this.factoryNames.get(extension);
        }
        if (factoryName == null && (factoryName = this.factoryNames.get("default")) == null) {
            throw new IllegalArgumentException("No language mapping found and no default specified in langs.properties");
        }
        final int instCount = instances;
        class AggHandler {
            AtomicInteger count = new AtomicInteger(0);
            boolean failed;

            AggHandler() {
            }

            void done(boolean res) {
                if (!res) {
                    this.failed = true;
                }
                if (this.count.incrementAndGet() == instCount) {
                    String deploymentID = this.failed ? null : deploymentName;
                    VerticleManager.this.callDoneHandler(doneHandler, deploymentID);
                }
            }
        }
        final AggHandler aggHandler = new AggHandler();
        String parentDeploymentName = this.getDeploymentName();
        final Deployment deployment = new Deployment(deploymentName, modName, instances, config == null ? new JsonObject() : config.copy(), urls, modDir, parentDeploymentName, autoRedeploy);
        this.deployments.put(deploymentName, deployment);
        if (parentDeploymentName != null) {
            Deployment parent = this.deployments.get(parentDeploymentName);
            parent.childDeployments.add(deploymentName);
        }
        ParentLastURLClassLoader sharedLoader = worker ? new ParentLastURLClassLoader(urls, this.getClass().getClassLoader()) : null;
        for (int i = 0; i < instances; ++i) {
            VerticleFactory verticleFactory;
            Class<?> clazz;
            final ParentLastURLClassLoader cl = sharedLoader != null ? sharedLoader : new ParentLastURLClassLoader(urls, this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(cl);
            try {
                clazz = cl.loadClass(factoryName);
            }
            catch (ClassNotFoundException e) {
                log.error("Cannot find class " + factoryName + " to load");
                this.callDoneHandler(doneHandler, null);
                return;
            }
            try {
                verticleFactory = (VerticleFactory)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("Failed to instantiate VerticleFactory: " + e.getMessage());
                this.callDoneHandler(doneHandler, null);
                return;
            }
            verticleFactory.init(this);
            Runnable runner = new Runnable(){
                {
                }

                @Override
                public void run() {
                    Verticle verticle = null;
                    boolean error = true;
                    try {
                        verticle = verticleFactory.createVerticle(main, cl);
                        error = false;
                    }
                    catch (ClassNotFoundException e) {
                        log.error("Cannot find verticle " + main);
                    }
                    catch (Throwable t) {
                        log.error("Failed to create verticle", t);
                    }
                    if (error) {
                        VerticleManager.this.doUndeploy(deploymentName, new SimpleHandler(){

                            @Override
                            public void handle() {
                                aggHandler.done(false);
                            }
                        });
                        return;
                    }
                    verticle.setVertx(VerticleManager.this.vertx);
                    verticle.setContainer(new Container(VerticleManager.this));
                    try {
                        VerticleManager.this.addVerticle(deployment, verticle, verticleFactory);
                        if (modDir != null) {
                            VerticleManager.this.setPathAdjustment(modDir);
                        }
                        verticle.start();
                        aggHandler.done(true);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        VerticleManager.this.vertx.reportException(t);
                        VerticleManager.this.doUndeploy(deploymentName, new SimpleHandler(){

                            @Override
                            public void handle() {
                                aggHandler.done(false);
                            }
                        });
                    }
                }
            };
            if (worker) {
                this.vertx.startInBackground(runner);
                continue;
            }
            this.vertx.startOnEventLoop(runner);
        }
    }

    private void addVerticle(Deployment deployment, Verticle verticle, VerticleFactory factory) {
        String loggerName = "org.vertx.deployments." + deployment.name + "-" + deployment.verticles.size();
        Logger logger = LoggerFactory.getLogger(loggerName);
        Context context = this.vertx.getContext();
        VerticleHolder holder = new VerticleHolder(deployment, context, verticle, loggerName, logger, deployment.config, factory);
        deployment.verticles.add(holder);
        context.setDeploymentHandle(holder);
    }

    private VerticleHolder getVerticleHolder() {
        Context context = this.vertx.getContext();
        if (context != null) {
            VerticleHolder holder = (VerticleHolder)context.getDeploymentHandle();
            return holder;
        }
        return null;
    }

    private void doUndeploy(String name, Handler<Void> doneHandler) {
        CountingCompletionHandler count = new CountingCompletionHandler(this.vertx.getOrAssignContext());
        this.doUndeploy(name, count);
        if (doneHandler != null) {
            count.setHandler(doneHandler);
        }
    }

    private void doUndeploy(String name, final CountingCompletionHandler count) {
        Deployment parent;
        Deployment deployment = this.deployments.remove(name);
        for (String childDeployment : deployment.childDeployments) {
            this.doUndeploy(childDeployment, count);
        }
        if (!deployment.verticles.isEmpty()) {
            for (final VerticleHolder holder : deployment.verticles) {
                count.incRequired();
                holder.context.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            holder.verticle.stop();
                        }
                        catch (Throwable t) {
                            VerticleManager.this.vertx.reportException(t);
                        }
                        LoggerFactory.removeLogger(holder.loggerName);
                        holder.context.runCloseHooks();
                        count.complete();
                    }
                });
            }
        }
        if (deployment.parentDeploymentName != null && (parent = this.deployments.get(deployment.parentDeploymentName)) != null) {
            parent.childDeployments.remove(name);
        }
    }

    @Override
    public void reloadModules(Set<Deployment> deps) {
        for (final Deployment deployment : deps) {
            if (this.deployments.containsKey(deployment.name)) {
                this.doUndeploy(deployment.name, new SimpleHandler(){

                    @Override
                    public void handle() {
                        VerticleManager.this.redeploy(deployment);
                    }
                });
                continue;
            }
            this.redeploy(deployment);
        }
    }

    public synchronized void undeploy(String name, final Handler<Void> doneHandler) {
        final Deployment dep = this.deployments.get(name);
        if (dep == null) {
            throw new IllegalArgumentException("There is no deployment with name " + name);
        }
        SimpleHandler wrappedHandler = new SimpleHandler(){

            @Override
            public void handle() {
                if (dep.modName != null && dep.autoRedeploy) {
                    VerticleManager.this.redeployer.moduleUndeployed(dep);
                }
                if (doneHandler != null) {
                    doneHandler.handle(null);
                }
            }
        };
        this.doUndeploy(name, wrappedHandler);
    }

    private void redeploy(final Deployment deployment) {
        AsyncResultHandler<String> handler = new AsyncResultHandler<String>(){

            @Override
            public void handle(AsyncResult<String> res) {
                if (!res.succeeded()) {
                    res.exception.printStackTrace();
                }
            }
        };
        BlockingAction<Void> redeployAction = new BlockingAction<Void>(this.vertx, (AsyncResultHandler)handler){

            @Override
            public Void action() throws Exception {
                VerticleManager.this.doDeployMod(true, deployment.name, deployment.modName, deployment.config, deployment.instances, null, null);
                return null;
            }
        };
        redeployAction.run();
    }

    public void stop() {
        this.redeployer.close();
    }
}

