/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.http.HttpServerRequest;

public class AtmosphereUtils {
    private static Logger logger = LoggerFactory.getLogger(AtmosphereUtils.class);

    public static final AtmosphereRequest request(HttpServerRequest request) throws Throwable {
        String u;
        String base = AtmosphereUtils.getBaseUri(request);
        URI requestUri = new URI(base.substring(0, base.length() - 1) + request.uri);
        String ct = "text/plain";
        if (request.headers().get("Content-Type") != null) {
            ct = (String)request.headers().get("Content-Type");
        }
        String method = request.method;
        URI uri = null;
        try {
            uri = URI.create(request.uri);
        }
        catch (IllegalArgumentException e) {
            logger.trace("", (Throwable)e);
        }
        String queryString = uri.getQuery();
        HashMap<String, String[]> qs = new HashMap<String, String[]>();
        if (queryString != null) {
            AtmosphereUtils.parseQueryString(qs, queryString);
        }
        int last = (u = requestUri.toURL().toString()).indexOf("?") == -1 ? u.length() : u.indexOf("?");
        String url = u.substring(0, last);
        int l = requestUri.getAuthority().length() + requestUri.getScheme().length() + 3;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        StringBuilder b = new StringBuilder();
        int port = uri == null ? 0 : uri.getPort();
        String uriString = uri.getPath();
        String host = uri.getHost();
        AtmosphereRequest.Builder requestBuilder = new AtmosphereRequest.Builder();
        AtmosphereRequest r = requestBuilder.requestURI(url.substring(l)).requestURL(u).pathInfo(url.substring(l)).headers(AtmosphereUtils.getHeaders(request)).method(method).requestURL(request.uri).contentType(ct).destroyable(false).attributes(attributes).servletPath("").remotePort(port).remoteAddr(uriString).remoteHost(host).body(b.toString()).queryStrings(qs).build();
        return r;
    }

    public static void parseQueryString(Map<String, String[]> qs, String queryString) {
        if (queryString != null) {
            String[] s;
            for (String a : s = queryString.split("&")) {
                String[] q = a.split("=");
                String[] z = new String[]{q.length > 1 ? q[1] : ""};
                qs.put(q[0], z);
            }
        }
    }

    public static String getBaseUri(HttpServerRequest request) {
        return "http://" + (String)request.headers().get("Host") + "/";
    }

    public static Map<String, String> getHeaders(HttpServerRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry e : request.headers().entrySet()) {
            headers.put((String)e.getKey(), (String)e.getValue());
        }
        return headers;
    }
}

