/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.vertx.AtmosphereCoordinator;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.http.ServerWebSocket;

public class VertxAtmosphere {
    private static final Logger logger = LoggerFactory.getLogger(VertxAtmosphere.class);
    private final Builder b;
    private final AtmosphereCoordinator coordinator = new AtmosphereCoordinator();

    private VertxAtmosphere(Builder b) {
        this.b = b;
        RouteMatcher routeMatcher = new RouteMatcher();
        routeMatcher.get(b.url, this.handleHttp());
        routeMatcher.post(b.url, this.handleHttp());
        routeMatcher.noMatch(b.httpServer.requestHandler());
        b.httpServer.requestHandler((Handler)routeMatcher);
        b.httpServer.websocketHandler(this.handleWebSocket());
        if (b.resource != null) {
            this.coordinator.configure(b);
        }
        this.coordinator.ready();
    }

    public boolean matchPath(String path) {
        return this.coordinator.matchPath(path);
    }

    private Handler<HttpServerRequest> handleHttp() {
        return new Handler<HttpServerRequest>(){

            public void handle(HttpServerRequest req) {
                logger.trace("HTTP received");
                VertxAtmosphere.this.coordinator.route(req);
            }
        };
    }

    private Handler<ServerWebSocket> handleWebSocket() {
        return new Handler<ServerWebSocket>(){

            public void handle(ServerWebSocket webSocket) {
                logger.trace("WebSocket received {}", (Object)webSocket);
                VertxAtmosphere.this.coordinator.route(webSocket);
            }
        };
    }

    public static final class Builder {
        protected String url;
        protected HttpServer httpServer;
        protected Class<?> resource;
        protected final Map<String, String> initParams = new HashMap<String, String>();
        protected Class<? extends WebSocketProtocol> webSocketProtocol = SimpleHttpProtocol.class;
        protected Class<Broadcaster> broadcasterClass;
        protected BroadcasterFactory broadcasterFactory;
        protected Class<? extends BroadcasterCache> broadcasterCache;
        protected final List<AtmosphereInterceptor> interceptors = new ArrayList<AtmosphereInterceptor>();

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder httpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public VertxAtmosphere build() {
            return new VertxAtmosphere(this);
        }

        public Builder resource(Class<?> resource) {
            this.resource = resource;
            return this;
        }

        public Builder initParam(String name, String value) {
            this.initParams.put(name, value);
            return this;
        }

        public Builder broadcaster(Class<Broadcaster> broadcasterClass) {
            this.broadcasterClass = broadcasterClass;
            return this;
        }

        public Builder broadcasterFactory(BroadcasterFactory broadcasterFactory) {
            this.broadcasterFactory = broadcasterFactory;
            return this;
        }

        public Builder broadcasterCache(Class<? extends BroadcasterCache> broadcasterCache) {
            this.broadcasterCache = broadcasterCache;
            return this;
        }

        public Builder webSocketProtocol(Class<? extends WebSocketProtocol> webSocketProtocol) {
            this.webSocketProtocol = webSocketProtocol;
            return this;
        }

        public Builder interceptor(AtmosphereInterceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }
    }
}

