/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.JBossWebSocketHandler;
import org.atmosphere.cpr.AtmosphereConfig;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBossWebSocketSupport
extends JBossWebCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(JBossWebSocketSupport.class);
    private final HttpEventServlet websocketHandler;

    public JBossWebSocketSupport(AtmosphereConfig config) {
        super(config);
        this.websocketHandler = this.newWebSocketHandler(config);
    }

    private HttpEventServlet newWebSocketHandler(AtmosphereConfig config) {
        try {
            return new JBossWebSocketHandler(config);
        }
        catch (Exception e) {
            logger.error("Cannot instantiate JBossWebSocketHandler. Websocket events will not be handled.", e);
            return null;
        }
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    public void dispatch(HttpEvent httpEvent) throws IOException, ServletException {
        if (this.websocketHandler != null) {
            this.websocketHandler.event(httpEvent);
        }
    }
}

