/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSupport
implements HttpSessionListener {
    private final Logger logger = LoggerFactory.getLogger(SessionSupport.class);
    public static boolean initializationHint = false;

    public SessionSupport() {
        initializationHint = true;
    }

    @Override
    public void sessionCreated(HttpSessionEvent se) {
        this.logger.trace("Session created");
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent se) {
        this.logger.trace("Session destroyed");
        try {
            HttpSession s = se.getSession();
            if (BroadcasterFactory.getDefault() != null) {
                for (Broadcaster b : BroadcasterFactory.getDefault().lookupAll()) {
                    for (AtmosphereResource r : b.getAtmosphereResources()) {
                        if (r.session() == null || !r.session().getId().equals(s.getId())) continue;
                        ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).session(null);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("", t);
        }
    }
}

