/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResourceLifecycleInterceptor
implements AtmosphereInterceptor {
    private String method = "GET";
    private Integer timeoutInSeconds = -1;
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceLifecycleInterceptor.class);
    private final boolean force;

    public AtmosphereResourceLifecycleInterceptor() {
        this(false);
    }

    public AtmosphereResourceLifecycleInterceptor(boolean force) {
        this.force = force;
    }

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.ATMOSPHERERESOURCE_INTERCEPTOR_METHOD);
        if (s != null) {
            this.method = s;
        }
        if ((s = config.getInitParameter(ApplicationConfig.ATMOSPHERERESOURCE_INTERCEPTOR_TIMEOUT)) != null) {
            this.timeoutInSeconds = Integer.valueOf(s);
        }
    }

    public String method() {
        return this.method;
    }

    public int timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public AtmosphereResourceLifecycleInterceptor method(String method) {
        this.method = method;
        return this;
    }

    public AtmosphereResourceLifecycleInterceptor timeoutInSeconds(int timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        switch (r.transport()) {
            case JSONP: 
            case AJAX: 
            case LONG_POLLING: {
                r.resumeOnBroadcast(true);
                break;
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(final AtmosphereResource r) {
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.UNDEFINED) || Utils.webSocketMessage(r)) {
            return;
        }
        AtmosphereResourceImpl impl = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r);
        if ((this.force || impl.getRequest(false).getMethod().equalsIgnoreCase(this.method)) && !impl.action().equals(Action.CANCELLED) && impl.isInScope()) {
            logger.trace("Marking AtmosphereResource {} for suspend operation", (Object)r.uuid());
            r.addEventListener(new AtmosphereResourceEventListenerAdapter.OnBroadcast(){

                @Override
                public void onBroadcast(AtmosphereResourceEvent event) {
                    switch (r.transport()) {
                        case JSONP: 
                        case AJAX: 
                        case LONG_POLLING: {
                            break;
                        }
                        default: {
                            try {
                                r.getResponse().flushBuffer();
                                break;
                            }
                            catch (IOException e) {
                                logger.trace("", e);
                            }
                        }
                    }
                }
            }).suspend(this.timeoutInSeconds == -1 ? (long)this.timeoutInSeconds.intValue() : TimeUnit.MILLISECONDS.convert(this.timeoutInSeconds.intValue(), TimeUnit.SECONDS));
        }
    }

    public String toString() {
        return "Atmosphere LifeCycle";
    }
}

