/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import org.atmosphere.container.NettyCometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.ServletProxyFactory;
import org.atmosphere.vertx.AtmosphereUtils;
import org.atmosphere.vertx.VertxAsyncIOWriter;
import org.atmosphere.vertx.VertxAtmosphere;
import org.atmosphere.vertx.VertxWebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.ServerWebSocket;

public class AtmosphereCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereCoordinator.class);
    private final AtmosphereFramework framework = new AtmosphereFramework();
    private final ScheduledExecutorService suspendTimer;
    private final EndpointMapper<AtmosphereFramework.AtmosphereHandlerWrapper> mapper;
    private WebSocketProcessor webSocketProcessor;
    private final AsynchronousProcessor asynchronousProcessor = new NettyCometSupport(this.framework().getAtmosphereConfig());

    AtmosphereCoordinator() {
        this.framework.setAsyncSupport(this.asynchronousProcessor);
        this.suspendTimer = ExecutorsFactory.getScheduler(this.framework.getAtmosphereConfig());
        this.mapper = this.framework.endPointMapper();
    }

    public AtmosphereCoordinator configure(VertxAtmosphere.Builder b) {
        try {
            if (b.broadcasterFactory != null) {
                this.framework.setBroadcasterFactory(b.broadcasterFactory);
            }
        }
        catch (Throwable t) {
            logger.trace("", t);
        }
        if (b.broadcasterCache != null) {
            try {
                this.framework.setBroadcasterCacheClassName(b.broadcasterCache.getName());
            }
            catch (Throwable t) {
                logger.trace("", t);
            }
        }
        if (b.webSocketProtocol != null) {
            this.framework.setWebSocketProtocolClassName(b.webSocketProtocol.getName());
        }
        for (AtmosphereInterceptor atmosphereInterceptor : b.interceptors) {
            this.framework.interceptor(atmosphereInterceptor);
        }
        for (Map.Entry entry : b.initParams.entrySet()) {
            this.framework.addInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        ServletProxyFactory.getDefault().addMethodHandler("getServerInfo", new ServletProxyFactory.MethodHandler(){

            @Override
            public Object handle(Object clazz, Method method, Object[] methodObjects) {
                return "Vertosphere/1.0.0";
            }
        });
        this.discover(b.resource);
        return this;
    }

    public AtmosphereCoordinator discover(Class<?> clazz) {
        this.framework.addAnnotationPackage(clazz);
        return this;
    }

    public AtmosphereCoordinator ready() {
        this.framework().init();
        this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.framework);
        return this;
    }

    public boolean matchPath(String path) {
        try {
            return this.mapper.map(path, this.framework().getAtmosphereHandlers()) != null;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public AtmosphereCoordinator path(String mappingPath) {
        this.framework.addInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER_MAPPING, mappingPath);
        return this;
    }

    public AtmosphereCoordinator shutdown() {
        this.framework.destroy();
        return this;
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    public AtmosphereCoordinator route(ServerWebSocket webSocket) {
        Map<String, List<String>> paramMap = new QueryStringDecoder("?" + webSocket.query()).parameters();
        LinkedHashMap<String, String[]> params = new LinkedHashMap<String, String[]>(paramMap.size());
        for (Map.Entry<String, List<String>> entry : paramMap.entrySet()) {
            params.put(entry.getKey(), entry.getValue().toArray(new String[0]));
        }
        String contentType = "application/json";
        if (params.size() == 0) {
            params.put("X-atmo-protocol", new String[]{"true"});
            params.put("X-Atmosphere-Framework", new String[]{"2.1"});
            params.put("X-Atmosphere-tracking-id", new String[]{"0"});
            params.put("X-Atmosphere-Transport", new String[]{"websocket"});
            params.put("Content-Type", new String[]{contentType});
        } else if (params.containsKey("Content-Type") && ((String[])params.get("Content-Type")).length > 0) {
            contentType = ((String[])params.get("Content-Type"))[0];
        }
        AtmosphereRequest.Builder requestBuilder = new AtmosphereRequest.Builder();
        AtmosphereRequest r = requestBuilder.requestURI(webSocket.path()).requestURL("http://0.0.0.0" + webSocket.path()).contentType(contentType).pathInfo(webSocket.path()).queryStrings(params).build();
        final VertxWebSocket w = new VertxWebSocket(this.framework.getAtmosphereConfig(), webSocket);
        try {
            this.webSocketProcessor.open(w, r, AtmosphereResponse.newInstance(this.framework.getAtmosphereConfig(), r, w));
        }
        catch (IOException e) {
            logger.debug("", e);
        }
        webSocket.dataHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer data) {
                AtmosphereCoordinator.this.webSocketProcessor.invokeWebSocketProtocol(w, data.toString());
            }
        });
        webSocket.exceptionHandler(new Handler<Throwable>(){

            @Override
            public void handle(Throwable event) {
                w.close();
                logger.debug("", event);
                AtmosphereCoordinator.this.webSocketProcessor.close(w, 1006);
            }
        });
        webSocket.closeHandler(new VoidHandler(){

            @Override
            protected void handle() {
                w.close();
                AtmosphereCoordinator.this.webSocketProcessor.close(w, 1005);
            }
        });
        return this;
    }

    public AtmosphereCoordinator route(AtmosphereRequest request, AtmosphereResponse response) throws IOException {
        final VertxAsyncIOWriter w = (VertxAsyncIOWriter)VertxAsyncIOWriter.class.cast(response.getAsyncIOWriter());
        try {
            Action a = this.framework.doCometSupport(request, response);
            final AtmosphereResourceImpl impl = (AtmosphereResourceImpl)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
            String transport = (String)request.getAttribute(FrameworkConfig.TRANSPORT_IN_USE);
            if (transport == null) {
                transport = request.getHeader("X-Atmosphere-Transport");
            }
            logger.debug("Transport {} action {}", (Object)transport, (Object)a);
            final Action action = (Action)request.getAttribute(NettyCometSupport.SUSPEND);
            if (action != null && action.type() == Action.TYPE.SUSPEND && action.timeout() != -1L) {
                final AtomicReference f = new AtomicReference();
                f.set(this.suspendTimer.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        if (!w.isClosed() && System.currentTimeMillis() - w.lastTick() > action.timeout()) {
                            AtmosphereCoordinator.this.asynchronousProcessor.endRequest(impl, false);
                            ((Future)f.get()).cancel(true);
                        }
                    }
                }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
            }
        }
        catch (Throwable e) {
            logger.error("Unable to process request", e);
        }
        return this;
    }

    public AtmosphereCoordinator route(final HttpServerRequest request) {
        boolean async = false;
        try {
            VertxAsyncIOWriter w = new VertxAsyncIOWriter(request);
            final AtmosphereRequest r = AtmosphereUtils.request(request);
            final AtmosphereResponse res = new AtmosphereResponse.Builder().asyncIOWriter(w).writeHeader(false).request(r).build();
            request.response().exceptionHandler(new Handler<Throwable>(){

                @Override
                public void handle(Throwable event) {
                    try {
                        logger.debug("exceptionHandler", event);
                        ((AsynchronousProcessor)AsynchronousProcessor.class.cast(AtmosphereCoordinator.this.framework.getAsyncSupport())).cancelled(r, res);
                    }
                    catch (IOException e) {
                        logger.debug("", e);
                    }
                    catch (ServletException e) {
                        logger.debug("", e);
                    }
                }
            });
            if (r.getMethod().equalsIgnoreCase("POST")) {
                async = true;
                request.bodyHandler(new Handler<Buffer>(){

                    @Override
                    public void handle(Buffer body) {
                        r.body(body.toString());
                        try {
                            AtmosphereCoordinator.this.route(r, res);
                            request.response().end();
                        }
                        catch (IOException e1) {
                            logger.debug("", e1);
                        }
                    }
                });
            }
            if (!async) {
                this.route(r, res);
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
        return this;
    }
}

