/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.Closeable;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.TCPSSLHelper;
import org.vertx.java.core.net.impl.VertxNetHandler;

public class DefaultNetClient
implements NetClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultNetClient.class);
    private final VertxInternal vertx;
    private final DefaultContext actualCtx;
    private final TCPSSLHelper tcpHelper = new TCPSSLHelper();
    private Bootstrap bootstrap;
    private final Map<Channel, DefaultNetSocket> socketMap = new ConcurrentHashMap<Channel, DefaultNetSocket>();
    private int reconnectAttempts;
    private long reconnectInterval = 1000L;
    private boolean configurable = true;
    private final Closeable closeHook = new Closeable(){

        @Override
        public void close(Handler<AsyncResult<Void>> doneHandler) {
            DefaultNetClient.this.close();
            doneHandler.handle(new DefaultFutureResult<Void>((Void)null));
        }
    };

    public DefaultNetClient(VertxInternal vertx) {
        this.vertx = vertx;
        this.actualCtx = vertx.getOrCreateContext();
        this.actualCtx.addCloseHook(this.closeHook);
    }

    @Override
    public NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.connect(port, host, connectHandler, this.reconnectAttempts);
        return this;
    }

    @Override
    public NetClient connect(int port, Handler<AsyncResult<NetSocket>> connectCallback) {
        this.connect(port, "localhost", connectCallback);
        return this;
    }

    @Override
    public void close() {
        for (NetSocket netSocket : this.socketMap.values()) {
            netSocket.close();
        }
        this.actualCtx.removeCloseHook(this.closeHook);
    }

    @Override
    public NetClient setReconnectAttempts(int attempts) {
        this.checkConfigurable();
        if (attempts < -1) {
            throw new IllegalArgumentException("reconnect attempts must be >= -1");
        }
        this.reconnectAttempts = attempts;
        return this;
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public NetClient setReconnectInterval(long interval) {
        this.checkConfigurable();
        if (interval < 1L) {
            throw new IllegalArgumentException("reconnect interval nust be >= 1");
        }
        this.reconnectInterval = interval;
        return this;
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public boolean isTCPNoDelay() {
        return this.tcpHelper.isTCPNoDelay();
    }

    @Override
    public int getSendBufferSize() {
        return this.tcpHelper.getSendBufferSize();
    }

    @Override
    public int getReceiveBufferSize() {
        return this.tcpHelper.getReceiveBufferSize();
    }

    @Override
    public boolean isTCPKeepAlive() {
        return this.tcpHelper.isTCPKeepAlive();
    }

    @Override
    public boolean isReuseAddress() {
        return this.tcpHelper.isReuseAddress();
    }

    @Override
    public int getSoLinger() {
        return this.tcpHelper.getSoLinger();
    }

    @Override
    public int getTrafficClass() {
        return this.tcpHelper.getTrafficClass();
    }

    @Override
    public int getConnectTimeout() {
        return this.tcpHelper.getConnectTimeout();
    }

    @Override
    public NetClient setTCPNoDelay(boolean tcpNoDelay) {
        this.checkConfigurable();
        this.tcpHelper.setTCPNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetClient setSendBufferSize(int size) {
        this.checkConfigurable();
        this.tcpHelper.setSendBufferSize(size);
        return this;
    }

    @Override
    public NetClient setReceiveBufferSize(int size) {
        this.checkConfigurable();
        this.tcpHelper.setReceiveBufferSize(size);
        return this;
    }

    @Override
    public NetClient setTCPKeepAlive(boolean keepAlive) {
        this.checkConfigurable();
        this.tcpHelper.setTCPKeepAlive(keepAlive);
        return this;
    }

    @Override
    public NetClient setReuseAddress(boolean reuse) {
        this.checkConfigurable();
        this.tcpHelper.setReuseAddress(reuse);
        return this;
    }

    @Override
    public NetClient setSoLinger(int linger) {
        this.checkConfigurable();
        this.tcpHelper.setSoLinger(linger);
        return this;
    }

    @Override
    public NetClient setTrafficClass(int trafficClass) {
        this.checkConfigurable();
        this.tcpHelper.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetClient setConnectTimeout(int timeout) {
        this.checkConfigurable();
        this.tcpHelper.setConnectTimeout(timeout);
        return this;
    }

    @Override
    public boolean isSSL() {
        return this.tcpHelper.isSSL();
    }

    @Override
    public String getKeyStorePath() {
        return this.tcpHelper.getKeyStorePath();
    }

    @Override
    public String getKeyStorePassword() {
        return this.tcpHelper.getKeyStorePassword();
    }

    @Override
    public String getTrustStorePath() {
        return this.tcpHelper.getTrustStorePath();
    }

    @Override
    public String getTrustStorePassword() {
        return this.tcpHelper.getTrustStorePassword();
    }

    @Override
    public boolean isTrustAll() {
        return this.tcpHelper.isTrustAll();
    }

    @Override
    public NetClient setSSL(boolean ssl) {
        this.checkConfigurable();
        this.tcpHelper.setSSL(ssl);
        return this;
    }

    @Override
    public NetClient setSSLContext(SSLContext sslContext) {
        this.checkConfigurable();
        this.tcpHelper.setExternalSSLContext(sslContext);
        return this;
    }

    @Override
    public NetClient setKeyStorePath(String path) {
        this.checkConfigurable();
        this.tcpHelper.setKeyStorePath(path);
        return this;
    }

    @Override
    public NetClient setKeyStorePassword(String pwd) {
        this.checkConfigurable();
        this.tcpHelper.setKeyStorePassword(pwd);
        return this;
    }

    @Override
    public NetClient setTrustStorePath(String path) {
        this.checkConfigurable();
        this.tcpHelper.setTrustStorePath(path);
        return this;
    }

    @Override
    public NetClient setTrustStorePassword(String pwd) {
        this.checkConfigurable();
        this.tcpHelper.setTrustStorePassword(pwd);
        return this;
    }

    @Override
    public NetClient setTrustAll(boolean trustAll) {
        this.checkConfigurable();
        this.tcpHelper.setTrustAll(trustAll);
        return this;
    }

    @Override
    public NetClient setUsePooledBuffers(boolean pooledBuffers) {
        this.checkConfigurable();
        this.tcpHelper.setUsePooledBuffers(pooledBuffers);
        return this;
    }

    @Override
    public boolean isUsePooledBuffers() {
        return this.tcpHelper.isUsePooledBuffers();
    }

    private void checkConfigurable() {
        if (!this.configurable) {
            throw new IllegalStateException("Can't set property after connect has been called");
        }
    }

    private void connect(final int port, final String host, final Handler<AsyncResult<NetSocket>> connectHandler, final int remainingAttempts) {
        if (this.bootstrap == null) {
            this.tcpHelper.checkSSL(this.vertx);
            this.bootstrap = new Bootstrap();
            this.bootstrap.group(this.actualCtx.getEventLoop());
            this.bootstrap.channel(NioSocketChannel.class);
            this.bootstrap.handler(new ChannelInitializer<Channel>(){

                @Override
                protected void initChannel(Channel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (DefaultNetClient.this.tcpHelper.isSSL()) {
                        SslHandler sslHandler = DefaultNetClient.this.tcpHelper.createSslHandler(DefaultNetClient.this.vertx, true);
                        pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                    }
                    if (DefaultNetClient.this.tcpHelper.isSSL()) {
                        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                    }
                    pipeline.addLast("handler", (ChannelHandler)new VertxNetHandler(DefaultNetClient.this.vertx, DefaultNetClient.this.socketMap));
                }
            });
            this.configurable = false;
        }
        this.tcpHelper.applyConnectionOptions(this.bootstrap);
        ChannelFuture future = this.bootstrap.connect(new InetSocketAddress(host, port));
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                final Channel ch = channelFuture.channel();
                if (channelFuture.isSuccess()) {
                    if (DefaultNetClient.this.tcpHelper.isSSL()) {
                        SslHandler sslHandler = ch.pipeline().get(SslHandler.class);
                        Future<Channel> fut = sslHandler.handshakeFuture();
                        fut.addListener(new GenericFutureListener<Future<Channel>>(){

                            @Override
                            public void operationComplete(Future<Channel> future) throws Exception {
                                if (future.isSuccess()) {
                                    DefaultNetClient.this.connected(ch, connectHandler);
                                } else {
                                    DefaultNetClient.this.failed(ch, future.cause(), connectHandler);
                                }
                            }
                        });
                    } else {
                        DefaultNetClient.this.connected(ch, connectHandler);
                    }
                } else if (remainingAttempts > 0 || remainingAttempts == -1) {
                    DefaultNetClient.this.actualCtx.execute(ch.eventLoop(), new Runnable(){

                        @Override
                        public void run() {
                            log.debug("Failed to create connection. Will retry in " + DefaultNetClient.this.reconnectInterval + " milliseconds");
                            DefaultNetClient.this.vertx.setTimer(DefaultNetClient.this.reconnectInterval, new Handler<Long>(){

                                @Override
                                public void handle(Long timerID) {
                                    DefaultNetClient.this.connect(port, host, connectHandler, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1);
                                }
                            });
                        }
                    });
                } else {
                    DefaultNetClient.this.failed(ch, channelFuture.cause(), connectHandler);
                }
            }
        });
    }

    private void connected(final Channel ch, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.actualCtx.execute(ch.eventLoop(), new Runnable(){

            @Override
            public void run() {
                DefaultNetClient.this.doConnected(ch, connectHandler);
            }
        });
    }

    private void doConnected(Channel ch, Handler<AsyncResult<NetSocket>> connectHandler) {
        DefaultNetSocket sock = new DefaultNetSocket(this.vertx, ch, this.actualCtx, this.tcpHelper, true);
        this.socketMap.put(ch, sock);
        connectHandler.handle(new DefaultFutureResult<DefaultNetSocket>(sock));
    }

    private void failed(Channel ch, final Throwable t, final Handler<AsyncResult<NetSocket>> connectHandler) {
        ch.close();
        this.actualCtx.execute(ch.eventLoop(), new Runnable(){

            @Override
            public void run() {
                DefaultNetClient.doFailed(connectHandler, t);
            }
        });
    }

    private static void doFailed(Handler<AsyncResult<NetSocket>> connectHandler, Throwable t) {
        connectHandler.handle(new DefaultFutureResult<Throwable>(t));
    }
}

