/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.ConnectionBase;
import org.vertx.java.core.net.impl.TCPSSLHelper;

public class DefaultNetSocket
extends ConnectionBase
implements NetSocket {
    private final String writeHandlerID;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Void> drainHandler;
    private final Handler<Message<Buffer>> writeHandler;
    private Queue<Buffer> pendingData;
    private boolean paused = false;
    private final TCPSSLHelper helper;
    private boolean client;
    private ChannelFuture writeFuture;

    public DefaultNetSocket(VertxInternal vertx, Channel channel, DefaultContext context, TCPSSLHelper helper, boolean client) {
        super(vertx, channel, context);
        this.helper = helper;
        this.client = client;
        this.writeHandlerID = UUID.randomUUID().toString();
        this.writeHandler = new Handler<Message<Buffer>>(){

            @Override
            public void handle(Message<Buffer> msg) {
                DefaultNetSocket.this.write(msg.body());
            }
        };
        vertx.eventBus().registerLocalHandler(this.writeHandlerID, this.writeHandler);
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public NetSocket write(Buffer data) {
        ByteBuf buf = data.getByteBuf();
        this.write(buf);
        return this;
    }

    @Override
    public NetSocket write(String str) {
        this.write(Unpooled.copiedBuffer(str, CharsetUtil.UTF_8));
        return this;
    }

    @Override
    public NetSocket write(String str, String enc) {
        if (enc == null) {
            this.write(str);
        } else {
            this.write(Unpooled.copiedBuffer(str, Charset.forName(enc)));
        }
        return this;
    }

    @Override
    public NetSocket dataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
        return this;
    }

    @Override
    public NetSocket pause() {
        this.paused = true;
        this.doPause();
        return this;
    }

    @Override
    public NetSocket resume() {
        if (!this.paused) {
            return this;
        }
        this.paused = false;
        if (this.pendingData != null) {
            Buffer buf;
            while ((buf = this.pendingData.poll()) != null) {
                this.vertx.runOnContext(new VoidHandler(){

                    @Override
                    protected void handle() {
                        DefaultNetSocket.this.handleDataReceived(buf);
                    }
                });
            }
        }
        this.doResume();
        return this;
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.doWriteQueueFull();
    }

    @Override
    public NetSocket endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public NetSocket drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        this.vertx.runOnContext(new VoidHandler(){

            @Override
            public void handle() {
                DefaultNetSocket.this.callDrainHandler();
            }
        });
        return this;
    }

    @Override
    public NetSocket sendFile(String filename) {
        return this.sendFile(filename, null);
    }

    @Override
    public NetSocket sendFile(String filename, final Handler<AsyncResult<Void>> resultHandler) {
        File f = new File(PathAdjuster.adjust(this.vertx, filename));
        if (f.isDirectory()) {
            throw new IllegalArgumentException("filename must point to a file and not to a directory");
        }
        ChannelFuture future = super.sendFile(f);
        if (resultHandler != null) {
            future.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    final DefaultFutureResult<Object> res = future.isSuccess() ? new DefaultFutureResult<Void>((Void)null) : new DefaultFutureResult<Throwable>(future.cause());
                    DefaultNetSocket.this.vertx.runOnContext(new Handler<Void>(){

                        @Override
                        public void handle(Void v) {
                            resultHandler.handle(res);
                        }
                    });
                }
            });
        }
        return this;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return super.localAddress();
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public NetSocket closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    @Override
    public void close() {
        if (this.writeFuture != null) {
            this.writeFuture.addListener(ChannelFutureListener.CLOSE);
            this.channel.flush();
        } else {
            super.close();
        }
    }

    @Override
    protected DefaultContext getContext() {
        return super.getContext();
    }

    @Override
    protected void handleClosed() {
        this.setContext();
        if (this.endHandler != null) {
            try {
                this.endHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
        super.handleClosed();
        if (this.vertx.eventBus() != null) {
            this.vertx.eventBus().unregisterHandler(this.writeHandlerID, this.writeHandler);
        }
    }

    @Override
    public void handleInterestedOpsChanged() {
        this.setContext();
        this.callDrainHandler();
    }

    void handleDataReceived(Buffer data) {
        if (this.paused) {
            if (this.pendingData == null) {
                this.pendingData = new ArrayDeque<Buffer>();
            }
            this.pendingData.add(data);
            return;
        }
        if (this.dataHandler != null) {
            this.setContext();
            try {
                this.dataHandler.handle(data);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    private void write(ByteBuf buff) {
        this.writeFuture = super.write(buff);
    }

    private void callDrainHandler() {
        if (this.drainHandler != null && !this.writeQueueFull()) {
            try {
                this.drainHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    @Override
    public NetSocket ssl(final Handler<Void> handler) {
        SslHandler sslHandler = this.channel.pipeline().get(SslHandler.class);
        if (sslHandler == null) {
            sslHandler = this.helper.createSslHandler(this.vertx, this.client);
            this.channel.pipeline().addFirst(sslHandler);
        }
        sslHandler.handshakeFuture().addListener(new GenericFutureListener<Future<Channel>>(){

            @Override
            public void operationComplete(final Future<Channel> future) throws Exception {
                if (DefaultNetSocket.this.context.isOnCorrectWorker(DefaultNetSocket.this.channel.eventLoop())) {
                    if (future.isSuccess()) {
                        try {
                            DefaultNetSocket.this.vertx.setContext(DefaultNetSocket.this.context);
                            handler.handle(null);
                        }
                        catch (Throwable t) {
                            DefaultNetSocket.this.context.reportException(t);
                        }
                    } else {
                        DefaultNetSocket.this.context.reportException(future.cause());
                    }
                } else {
                    DefaultNetSocket.this.context.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (future.isSuccess()) {
                                handler.handle(null);
                            } else {
                                DefaultNetSocket.this.context.reportException(future.cause());
                            }
                        }
                    });
                }
            }
        });
        return this;
    }

    @Override
    public boolean isSsl() {
        return this.channel.pipeline().get(SslHandler.class) != null;
    }
}

