/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.util.Map;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.BaseTransport;
import org.vertx.java.core.sockjs.impl.Session;

class XhrTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(XhrTransport.class);
    private static final Buffer H_BLOCK;

    XhrTransport(VertxInternal vertx, RouteMatcher rm, String basePath, final Map<String, Session> sessions, final JsonObject config, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, config);
        String xhrBase = basePath + "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/";
        String xhrRE = xhrBase + "xhr";
        String xhrStreamRE = xhrBase + "xhr_streaming";
        Handler<HttpServerRequest> xhrOptionsHandler = XhrTransport.createCORSOptionsHandler(config, "OPTIONS, POST");
        rm.optionsWithRegEx(xhrRE, xhrOptionsHandler);
        rm.optionsWithRegEx(xhrStreamRE, xhrOptionsHandler);
        this.registerHandler(rm, sockHandler, xhrRE, false, config);
        this.registerHandler(rm, sockHandler, xhrStreamRE, true, config);
        String xhrSendRE = basePath + "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/" + "xhr_send";
        rm.optionsWithRegEx(xhrSendRE, xhrOptionsHandler);
        rm.postWithRegEx(xhrSendRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                String sessionID;
                Session session;
                if (log.isTraceEnabled()) {
                    log.trace("XHR send, post, " + req.uri());
                }
                if ((session = (Session)sessions.get(sessionID = req.params().get("param0"))) != null && !session.isClosed()) {
                    XhrTransport.this.handleSend(req, session);
                } else {
                    req.response().setStatusCode(404);
                    BaseTransport.setJSESSIONID(config, req);
                    req.response().end();
                }
            }
        });
    }

    private void registerHandler(RouteMatcher rm, final Handler<SockJSSocket> sockHandler, String re, final boolean streaming, final JsonObject config) {
        rm.postWithRegEx(re, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                if (log.isTraceEnabled()) {
                    log.trace("XHR, post, " + req.uri());
                }
                BaseTransport.setNoCacheHeaders(req);
                String sessionID = req.params().get("param0");
                Session session = XhrTransport.this.getSession(config.getLong("session_timeout"), config.getLong("heartbeat_period"), sessionID, sockHandler);
                session.setInfo(req.localAddress(), req.remoteAddress(), req.uri(), req.headers());
                session.register(streaming ? new XhrStreamingListener(config.getInteger("max_bytes_streaming"), req, session) : new XhrPollingListener(req, session));
            }
        });
    }

    private void handleSend(final HttpServerRequest req, final Session session) {
        req.bodyHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer buff) {
                String msgs = buff.toString();
                if (msgs.equals("")) {
                    req.response().setStatusCode(500);
                    req.response().end("Payload expected.");
                    return;
                }
                if (!session.handleMessages(msgs)) {
                    XhrTransport.this.sendInvalidJSON(req.response());
                } else {
                    req.response().headers().set("Content-Type", "text/plain; charset=UTF-8");
                    BaseTransport.setNoCacheHeaders(req);
                    BaseTransport.setJSESSIONID(XhrTransport.this.config, req);
                    BaseTransport.setCORS(req);
                    req.response().setStatusCode(204);
                    req.response().end();
                }
                if (log.isTraceEnabled()) {
                    log.trace("XHR send processed ok");
                }
            }
        });
    }

    static {
        byte[] bytes = new byte[2049];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = 104;
        }
        bytes[bytes.length - 1] = 10;
        H_BLOCK = new Buffer(bytes);
    }

    private class XhrStreamingListener
    extends BaseXhrListener {
        int bytesSent;
        int maxBytesStreaming;

        XhrStreamingListener(int maxBytesStreaming, HttpServerRequest req, Session session) {
            super(req, session);
            this.maxBytesStreaming = maxBytesStreaming;
            this.addCloseHandler(req.response(), session);
        }

        @Override
        public void sendFrame(String body) {
            boolean hr = this.headersWritten;
            super.sendFrame(body);
            if (!hr) {
                this.req.response().write(H_BLOCK);
            }
            String sbody = body + "\n";
            Buffer buff = new Buffer(sbody);
            this.req.response().write(buff);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                this.close();
            }
        }

        @Override
        public void close() {
            if (log.isTraceEnabled()) {
                log.trace("XHR stream closing listener");
            }
            if (!this.closed) {
                this.session.resetListener();
                try {
                    this.req.response().end();
                    this.req.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private class XhrPollingListener
    extends BaseXhrListener {
        XhrPollingListener(HttpServerRequest req, Session session) {
            super(req, session);
            this.addCloseHandler(req.response(), session);
        }

        @Override
        public void sendFrame(String body) {
            super.sendFrame(body);
            this.req.response().write(body + "\n");
            this.close();
        }

        @Override
        public void close() {
            if (log.isTraceEnabled()) {
                log.trace("XHR poll closing listener");
            }
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.req.response().end();
                    this.req.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private abstract class BaseXhrListener
    extends BaseTransport.BaseListener {
        boolean headersWritten;

        BaseXhrListener(HttpServerRequest req, Session session) {
            super(req, session);
        }

        @Override
        public void sendFrame(String body) {
            if (log.isTraceEnabled()) {
                log.trace("XHR sending frame");
            }
            if (!this.headersWritten) {
                this.req.response().headers().set("Content-Type", "application/javascript; charset=UTF-8");
                BaseTransport.setJSESSIONID(XhrTransport.this.config, this.req);
                BaseTransport.setCORS(this.req);
                this.req.response().setChunked(true);
                this.headersWritten = true;
            }
        }

        @Override
        public void close() {
        }
    }
}

