/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import org.vertx.java.core.http.WebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrameInternal;

public class DefaultWebSocketFrame
implements WebSocketFrameInternal,
ReferenceCounted {
    private final WebSocketFrame.FrameType type;
    private final boolean isFinalFrame;
    private ByteBuf binaryData;

    public DefaultWebSocketFrame() {
        this(null, Unpooled.EMPTY_BUFFER, true);
    }

    public DefaultWebSocketFrame(WebSocketFrame.FrameType frameType) {
        this(frameType, Unpooled.EMPTY_BUFFER, true);
    }

    public DefaultWebSocketFrame(String textData) {
        this(textData, true);
    }

    public DefaultWebSocketFrame(String textData, boolean isFinalFrame) {
        this.type = WebSocketFrame.FrameType.TEXT;
        this.isFinalFrame = isFinalFrame;
        this.binaryData = Unpooled.copiedBuffer(textData, CharsetUtil.UTF_8);
    }

    public DefaultWebSocketFrame(WebSocketFrame.FrameType type, ByteBuf binaryData) {
        this(type, binaryData, true);
    }

    public DefaultWebSocketFrame(WebSocketFrame.FrameType type, ByteBuf binaryData, boolean isFinalFrame) {
        this.type = type;
        this.isFinalFrame = isFinalFrame;
        this.binaryData = Unpooled.unreleasableBuffer(binaryData);
    }

    @Override
    public WebSocketFrame.FrameType type() {
        return this.type;
    }

    @Override
    public boolean isText() {
        return this.type == WebSocketFrame.FrameType.TEXT;
    }

    @Override
    public boolean isBinary() {
        return this.type == WebSocketFrame.FrameType.BINARY;
    }

    @Override
    public ByteBuf getBinaryData() {
        return this.binaryData;
    }

    @Override
    public String textData() {
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    @Override
    public void setBinaryData(ByteBuf binaryData) {
        if (this.binaryData != null) {
            this.binaryData.release();
        }
        this.binaryData = binaryData;
    }

    @Override
    public void setTextData(String textData) {
        if (this.binaryData != null) {
            this.binaryData.release();
        }
        this.binaryData = Unpooled.copiedBuffer(textData, CharsetUtil.UTF_8);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(type: " + (Object)((Object)this.type()) + ", " + "data: " + this.getBinaryData() + ')';
    }

    @Override
    public int refCnt() {
        return this.binaryData.refCnt();
    }

    @Override
    public ReferenceCounted retain() {
        return this.binaryData.retain();
    }

    @Override
    public ReferenceCounted retain(int increment) {
        return this.binaryData.retain(increment);
    }

    @Override
    public boolean release() {
        return this.binaryData.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.binaryData.release(decrement);
    }

    @Override
    public boolean isFinalFrame() {
        return this.isFinalFrame;
    }
}

